/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.FastaSequenceIndexEntry;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.readers.AsciiLineReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class FastaSequenceIndexCreator {
    private FastaSequenceIndexCreator() {
    }

    public static void create(Path fastaFile, boolean overwrite) throws IOException {
        Path indexFile = ReferenceSequenceFileFactory.getFastaIndexFileName(fastaFile);
        if (!overwrite && Files.exists(indexFile, new LinkOption[0])) {
            throw new SAMException("Index file " + indexFile + " already exists for " + fastaFile);
        }
        FastaSequenceIndex index = FastaSequenceIndexCreator.buildFromFasta(fastaFile);
        index.write(indexFile);
    }

    public static FastaSequenceIndex buildFromFasta(Path fastaFile) throws IOException {
        try (AsciiLineReader in = AsciiLineReader.from(IOUtil.openFileForReading(fastaFile));){
            String previous = in.readLine();
            if (previous == null) {
                throw new SAMException("Cannot index empty file: " + fastaFile);
            }
            if (previous.charAt(0) != '>') {
                throw new SAMException("Wrong sequence header: " + previous);
            }
            int sequenceIndex = -1;
            long location = in.getPosition();
            FastaSequenceIndex index = new FastaSequenceIndex();
            FaiEntryBuilder entry = null;
            String line = in.readLine();
            while (previous != null) {
                if (previous.charAt(0) == '>') {
                    if (entry != null) {
                        index.add(entry.build());
                    }
                    entry = new FaiEntryBuilder(sequenceIndex++, previous, line, in.getLineTerminatorLength(), location);
                } else if (line != null && line.charAt(0) == '>') {
                    location = in.getPosition();
                } else if (line != null && !line.isEmpty()) {
                    entry.updateWithSequence(line, in.getLineTerminatorLength());
                }
                previous = line;
                line = in.readLine();
            }
            index.add(entry.build());
            FastaSequenceIndex fastaSequenceIndex = index;
            return fastaSequenceIndex;
        }
    }

    private static class FaiEntryBuilder {
        private final int index;
        private final String contig;
        private final long location;
        private final int basesPerLine;
        private final int endOfLineLength;
        private long size;
        private boolean lessBasesFound;

        private FaiEntryBuilder(int index, String header, String firstSequenceLine, int endOfLineLength, long location) {
            if (header == null || header.charAt(0) != '>') {
                throw new SAMException("Wrong sequence header: " + header);
            }
            if (firstSequenceLine == null) {
                throw new SAMException("Empty sequences could not be indexed");
            }
            this.index = index;
            this.contig = SAMSequenceRecord.truncateSequenceName(header.substring(1).trim());
            this.location = location;
            this.basesPerLine = firstSequenceLine.length();
            this.endOfLineLength = endOfLineLength;
            this.size = firstSequenceLine.length();
            this.lessBasesFound = false;
        }

        private void updateWithSequence(String sequence, int endOfLineLength) {
            if (this.endOfLineLength != endOfLineLength) {
                throw new SAMException(String.format("Different end of line for the same sequence was found.", new Object[0]));
            }
            if (sequence.length() > this.basesPerLine) {
                throw new SAMException(String.format("Sequence line for {} was longer than the expected length ({}): {}", this.contig, this.basesPerLine, sequence));
            }
            if (sequence.length() < this.basesPerLine) {
                if (this.lessBasesFound) {
                    throw new SAMException(String.format("Only last line could have less than {} bases for '{}' sequence, but at least two are different. Last sequence line: {}", this.basesPerLine, this.contig, sequence));
                }
                this.lessBasesFound = true;
            }
            this.size += (long)sequence.length();
        }

        private FastaSequenceIndexEntry build() {
            return new FastaSequenceIndexEntry(this.contig, this.location, this.size, this.basesPerLine, this.basesPerLine + this.endOfLineLength, this.index);
        }
    }
}

