/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.util.BitUtil;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class MouseShortcut
extends Shortcut {
    public static final int BUTTON_WHEEL_UP = 143;
    public static final int BUTTON_WHEEL_DOWN = 142;
    private final int myButton;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    private final int myClickCount;

    public static int getButton(MouseEvent event) {
        if (event instanceof MouseWheelEvent) {
            MouseWheelEvent wheel = (MouseWheelEvent)event;
            return 0.0 < wheel.getPreciseWheelRotation() ? 142 : 143;
        }
        return event.getButton();
    }

    public MouseShortcut(int button, @JdkConstants.InputEventMask int modifiers, int clickCount) {
        this.myButton = button;
        this.myModifiers = MouseShortcut.mapOldModifiers(modifiers);
        if (clickCount < 1) {
            throw new IllegalArgumentException("wrong clickCount: " + clickCount);
        }
        this.myClickCount = clickCount;
    }

    public int getButton() {
        return this.myButton;
    }

    @JdkConstants.InputEventMask
    public int getModifiers() {
        return this.myModifiers;
    }

    public int getClickCount() {
        return this.myClickCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MouseShortcut other = (MouseShortcut)obj;
        return this.myButton == other.myButton && this.myModifiers == other.myModifiers && this.myClickCount == other.myClickCount;
    }

    public int hashCode() {
        return this.myButton + this.myModifiers + this.myClickCount;
    }

    @JdkConstants.InputEventMask
    private static int mapOldModifiers(@JdkConstants.InputEventMask int modifiers) {
        if (BitUtil.isSet((int)modifiers, (int)1)) {
            modifiers |= 0x40;
        }
        if (BitUtil.isSet((int)modifiers, (int)8)) {
            modifiers |= 0x200;
        }
        if (BitUtil.isSet((int)modifiers, (int)32)) {
            modifiers |= 0x2000;
        }
        if (BitUtil.isSet((int)modifiers, (int)2)) {
            modifiers |= 0x80;
        }
        if (BitUtil.isSet((int)modifiers, (int)4)) {
            modifiers |= 0x100;
        }
        return modifiers &= 0x23C0;
    }

    @Override
    public boolean isKeyboard() {
        return false;
    }

    @Override
    public boolean startsWith(@NotNull Shortcut sc) {
        if (sc == null) {
            MouseShortcut.$$$reportNull$$$0(0);
        }
        return this.equals(sc);
    }

    public String toString() {
        return "button=" + this.myButton + " clickCount=" + this.myClickCount + " modifiers=" + this.myModifiers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sc", "com/intellij/openapi/actionSystem/MouseShortcut", "startsWith"));
    }
}

