/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="VcsManagerConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class VcsConfiguration
implements PersistentStateComponent<VcsConfiguration> {
    private static final Logger LOG = Logger.getInstance(VcsConfiguration.class);
    public static final long ourMaximumFileForBaseRevisionSize = 500000L;
    @NonNls
    public static final String PATCH = "patch";
    @NonNls
    public static final String DIFF = "diff";
    public boolean OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT = false;
    public boolean CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = !PlatformUtils.isPyCharm() && !PlatformUtils.isRubyMine();
    public boolean CHECK_CODE_CLEANUP_BEFORE_PROJECT_COMMIT = false;
    public boolean CHECK_NEW_TODO = true;
    public TodoPanelSettings myTodoPanelSettings = new TodoPanelSettings();
    public boolean PERFORM_UPDATE_IN_BACKGROUND = true;
    public boolean PERFORM_COMMIT_IN_BACKGROUND = true;
    public boolean PERFORM_EDIT_IN_BACKGROUND = true;
    public boolean PERFORM_CHECKOUT_IN_BACKGROUND = true;
    public boolean PERFORM_ADD_REMOVE_IN_BACKGROUND = true;
    public boolean PERFORM_ROLLBACK_IN_BACKGROUND = false;
    public volatile boolean CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND = false;
    @OptionTag(tag="confirmMoveToFailedCommit", nameAttribute="")
    public VcsShowConfirmationOption.Value MOVE_TO_FAILED_COMMIT_CHANGELIST = VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY;
    @OptionTag(tag="confirmRemoveEmptyChangelist", nameAttribute="")
    public VcsShowConfirmationOption.Value REMOVE_EMPTY_INACTIVE_CHANGELISTS = VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    public int CHANGED_ON_SERVER_INTERVAL = 60;
    public boolean SHOW_ONLY_CHANGED_IN_SELECTION_DIFF = true;
    public String DEFAULT_PATCH_EXTENSION = "patch";
    public boolean USE_CUSTOM_SHELF_PATH = false;
    public String CUSTOM_SHELF_PATH = null;
    public boolean MOVE_SHELVES = false;
    public boolean INCLUDE_TEXT_INTO_SHELF = true;
    public Boolean SHOW_PATCH_IN_EXPLORER = null;
    public boolean SHOW_FILE_HISTORY_DETAILS = true;
    public boolean SHOW_DIRTY_RECURSIVELY = false;
    public boolean LIMIT_HISTORY = true;
    public int MAXIMUM_HISTORY_ROWS = 1000;
    public String UPDATE_FILTER_SCOPE_NAME = null;
    public boolean USE_COMMIT_MESSAGE_MARGIN = true;
    public boolean WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = false;
    public boolean SHOW_UNVERSIONED_FILES_WHILE_COMMIT = true;
    public boolean LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = false;
    public boolean SHELVE_DETAILS_PREVIEW_SHOWN = false;
    public boolean VCS_LOG_DETAILS_PREVIEW_SHOWN = false;
    public boolean RELOAD_CONTEXT = true;
    @XCollection(elementName="path", propertyElementName="ignored-roots")
    public List<String> IGNORED_UNREGISTERED_ROOTS = ContainerUtil.newArrayList();
    public boolean FORCE_NON_EMPTY_COMMENT = false;
    public boolean CLEAR_INITIAL_COMMIT_MESSAGE = false;
    @Property(surroundWithTag=false)
    @XCollection(elementName="MESSAGE")
    public List<String> myLastCommitMessages = new ArrayList<String>();
    public String LAST_COMMIT_MESSAGE = null;
    public boolean MAKE_NEW_CHANGELIST_ACTIVE = false;
    public boolean PRESELECT_EXISTING_CHANGELIST = false;
    public boolean OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = false;
    public boolean REFORMAT_BEFORE_PROJECT_COMMIT = false;
    public boolean REARRANGE_BEFORE_PROJECT_COMMIT = false;
    @Transient
    public Map<String, ChangeBrowserSettings> changeBrowserSettings = new THashMap();
    public boolean UPDATE_GROUP_BY_PACKAGES = false;
    public boolean UPDATE_GROUP_BY_CHANGELIST = false;
    public boolean UPDATE_FILTER_BY_SCOPE = false;
    public boolean SHOW_FILE_HISTORY_AS_TREE = false;
    public boolean GROUP_MULTIFILE_MERGE_BY_DIRECTORY = false;
    private static final int MAX_STORED_MESSAGES = 25;
    private final PerformInBackgroundOption myUpdateOption = new UpdateInBackgroundOption();
    private final PerformInBackgroundOption myCommitOption = new CommitInBackgroundOption();
    private final PerformInBackgroundOption myEditOption = new EditInBackgroundOption();
    private final PerformInBackgroundOption myCheckoutOption = new CheckoutInBackgroundOption();
    private final PerformInBackgroundOption myAddRemoveOption = new AddRemoveInBackgroundOption();
    private final PerformInBackgroundOption myRollbackOption = new RollbackInBackgroundOption();

    @Override
    public VcsConfiguration getState() {
        return this;
    }

    @Override
    public void loadState(@NotNull VcsConfiguration state) {
        if (state == null) {
            VcsConfiguration.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static VcsConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            VcsConfiguration.$$$reportNull$$$0(1);
        }
        return ServiceManager.getService(project, VcsConfiguration.class);
    }

    public void saveCommitMessage(String comment) {
        this.LAST_COMMIT_MESSAGE = comment;
        if (comment == null || comment.length() == 0) {
            return;
        }
        this.myLastCommitMessages.remove(comment);
        this.addCommitMessage(comment);
    }

    private void addCommitMessage(@NotNull String comment) {
        if (comment == null) {
            VcsConfiguration.$$$reportNull$$$0(2);
        }
        if (this.myLastCommitMessages.size() >= 25) {
            this.myLastCommitMessages.remove(0);
        }
        this.myLastCommitMessages.add(comment);
    }

    public String getLastNonEmptyCommitMessage() {
        if (this.myLastCommitMessages.isEmpty()) {
            return null;
        }
        return this.myLastCommitMessages.get(this.myLastCommitMessages.size() - 1);
    }

    @NotNull
    public ArrayList<String> getRecentMessages() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myLastCommitMessages);
        if (arrayList == null) {
            VcsConfiguration.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public void replaceMessage(@NotNull String oldMessage, @NotNull String newMessage) {
        int index2;
        if (oldMessage == null) {
            VcsConfiguration.$$$reportNull$$$0(4);
        }
        if (newMessage == null) {
            VcsConfiguration.$$$reportNull$$$0(5);
        }
        if (oldMessage.equals(this.LAST_COMMIT_MESSAGE)) {
            this.LAST_COMMIT_MESSAGE = newMessage;
        }
        if ((index2 = this.myLastCommitMessages.indexOf(oldMessage)) >= 0) {
            this.myLastCommitMessages.remove(index2);
            this.myLastCommitMessages.add(index2, newMessage);
        } else {
            LOG.debug("Couldn't find message [" + oldMessage + "] in the messages history");
            this.addCommitMessage(newMessage);
        }
    }

    public PerformInBackgroundOption getUpdateOption() {
        return this.myUpdateOption;
    }

    public PerformInBackgroundOption getCommitOption() {
        return this.myCommitOption;
    }

    public PerformInBackgroundOption getEditOption() {
        return this.myEditOption;
    }

    public PerformInBackgroundOption getCheckoutOption() {
        return this.myCheckoutOption;
    }

    public PerformInBackgroundOption getAddRemoveOption() {
        return this.myAddRemoveOption;
    }

    public PerformInBackgroundOption getRollbackOption() {
        return this.myRollbackOption;
    }

    public String getPatchFileExtension() {
        return this.DEFAULT_PATCH_EXTENSION;
    }

    public void acceptLastCreatedPatchName(String string) {
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            return;
        }
        if (FileUtilRt.extensionEquals((String)string, (String)DIFF)) {
            this.DEFAULT_PATCH_EXTENSION = DIFF;
        } else if (FileUtilRt.extensionEquals((String)string, (String)PATCH)) {
            this.DEFAULT_PATCH_EXTENSION = PATCH;
        }
    }

    public boolean isChangedOnServerEnabled() {
        return this.CHECK_LOCALLY_CHANGED_CONFLICTS_IN_BACKGROUND;
    }

    public void addIgnoredUnregisteredRoots(@NotNull Collection<String> roots) {
        if (roots == null) {
            VcsConfiguration.$$$reportNull$$$0(6);
        }
        ArrayList<String> unregisteredRoots = new ArrayList<String>(this.IGNORED_UNREGISTERED_ROOTS);
        for (String root : roots) {
            if (unregisteredRoots.contains(root)) continue;
            unregisteredRoots.add(root);
        }
        this.IGNORED_UNREGISTERED_ROOTS = unregisteredRoots;
    }

    public void removeFromIgnoredUnregisteredRoots(@NotNull Collection<String> roots) {
        if (roots == null) {
            VcsConfiguration.$$$reportNull$$$0(7);
        }
        ArrayList<String> unregisteredRoots = new ArrayList<String>(this.IGNORED_UNREGISTERED_ROOTS);
        unregisteredRoots.removeAll(roots);
        this.IGNORED_UNREGISTERED_ROOTS = unregisteredRoots;
    }

    public boolean isIgnoredUnregisteredRoot(@NotNull String root) {
        if (root == null) {
            VcsConfiguration.$$$reportNull$$$0(8);
        }
        return this.IGNORED_UNREGISTERED_ROOTS.contains(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCommitMessage";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredUnregisteredRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFromIgnoredUnregisteredRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredUnregisteredRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RollbackInBackgroundOption
    implements PerformInBackgroundOption {
        private RollbackInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_ROLLBACK_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_ROLLBACK_IN_BACKGROUND = true;
        }
    }

    private class AddRemoveInBackgroundOption
    implements PerformInBackgroundOption {
        private AddRemoveInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_ADD_REMOVE_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_ADD_REMOVE_IN_BACKGROUND = true;
        }
    }

    private class CheckoutInBackgroundOption
    implements PerformInBackgroundOption {
        private CheckoutInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_CHECKOUT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_CHECKOUT_IN_BACKGROUND = true;
        }
    }

    private class EditInBackgroundOption
    implements PerformInBackgroundOption {
        private EditInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_EDIT_IN_BACKGROUND;
        }

        @Override
        public void processSentToBackground() {
            VcsConfiguration.this.PERFORM_EDIT_IN_BACKGROUND = true;
        }
    }

    private class CommitInBackgroundOption
    implements PerformInBackgroundOption {
        private CommitInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_COMMIT_IN_BACKGROUND;
        }
    }

    private class UpdateInBackgroundOption
    implements PerformInBackgroundOption {
        private UpdateInBackgroundOption() {
        }

        @Override
        public boolean shouldStartInBackground() {
            return VcsConfiguration.this.PERFORM_UPDATE_IN_BACKGROUND;
        }
    }

    public static enum StandardConfirmation {
        ADD(VcsBundle.message("vcs.command.name.add", new Object[0])),
        REMOVE(VcsBundle.message("vcs.command.name.remove", new Object[0]));

        private final String myId;

        private StandardConfirmation(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }

    public static enum StandardOption {
        ADD(VcsBundle.message("vcs.command.name.add", new Object[0])),
        REMOVE(VcsBundle.message("vcs.command.name.remove", new Object[0])),
        EDIT(VcsBundle.message("vcs.command.name.edit", new Object[0])),
        CHECKOUT(VcsBundle.message("vcs.command.name.checkout", new Object[0])),
        STATUS(VcsBundle.message("vcs.command.name.status", new Object[0])),
        UPDATE(VcsBundle.message("vcs.command.name.update", new Object[0]));

        private final String myId;

        private StandardOption(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }
    }
}

