/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.introspector;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.mssql.model.MsKey;
import com.intellij.database.dialects.mssql.model.MsModCustomType;
import com.intellij.database.dialects.mssql.model.MsModSchemaObject;
import com.intellij.database.dialects.mssql.model.MsSchemaObject;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a*\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010\u001f\u001a\u0004\u0018\u00010\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0002\u001a7\u0010 \u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u0002H!0$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010&\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001c\u0010*\u001a\u0004\u0018\u00010+*\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0.H\u0002\u001a \u0010/\u001a\u000200*\u0002012\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u000103H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"2\u0010\u0007\u001a&\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\t0\t \u0004*\u0012\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"ALIAS_TYPE_KIND", "", "MUFFLED_WORDS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SURROGATE_NAME_PATTERN", "TABLE_TYPE_KIND", "VARIABLE_TYPES", "Lcom/google/common/collect/ImmutableSet;", "", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "name", "makeCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "makeDataType", "Lcom/intellij/database/model/DataType;", "type_name", "max_length", "", "precision", "scale", "normalizeExpression", "expression", "normalizePredicateExpression", "renewType", "T", "Lcom/intellij/database/dialects/mssql/model/MsModCustomType;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "typeId", "(Lcom/intellij/database/model/families/ModNamingFamily;ILjava/lang/String;)Lcom/intellij/database/dialects/mssql/model/MsModCustomType;", "unpackEvents", "", "Lcom/intellij/database/model/TrigEvent;", "findKeyByColumns", "Lcom/intellij/database/dialects/mssql/model/MsKey;", "Lcom/intellij/database/dialects/mssql/model/MsTable;", "names", "", "setCreatedAndModifiedTimestamps", "", "Lcom/intellij/database/dialects/mssql/model/MsModSchemaObject;", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.dialects"})
public final class MsIntrospectorKt {
    private static final Pattern MUFFLED_WORDS = Pattern.compile("\\(\\d+(\\.\\d+)?\\)", 2);
    private static final byte ALIAS_TYPE_KIND = 1;
    private static final byte TABLE_TYPE_KIND = 2;
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^\\s*\\w{2}\\S{2,18}__[\\dA-F]{8,16}\\s*$", 2);
    private static final ImmutableSet<String> VARIABLE_TYPES = ImmutableSet.of((Object)"decimal", (Object)"numeric", (Object)"varbinary", (Object)"varchar", (Object)"binary", (Object)"char", (Object[])new String[]{"nvarchar", "nchar", "time", "datetime2", "datetimeoffset"});

    private static final <T extends MsModCustomType> T renewType(ModNamingFamily<? extends T> family, int typeId, String name) {
        MsModCustomType type = (MsModCustomType)family.find(new Predicate<T>(typeId){
            final /* synthetic */ int $typeId;

            public final boolean test(T it) {
                T t = it;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                return t.getTypeId() == this.$typeId;
            }
            {
                this.$typeId = n;
            }
        });
        if (type != null) {
            type.setName(name);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsModCustomType)family.get(name);
        if (type != null && type.getTypeId() == 0) {
            type.setTypeId(typeId);
            type.resetSyncPending();
            return (T)type;
        }
        type = (MsModCustomType)family.createNewOne();
        type.setTypeId(typeId);
        type.setName(name);
        return (T)type;
    }

    private static final MsKey findKeyByColumns(@NotNull MsTable $receiver, List<String> names) {
        Object v1;
        block1: {
            Family family = $receiver.getKeys();
            Intrinsics.checkExpressionValueIsNotNull((Object)family, (String)"this.keys");
            Iterable $receiver$iv = family;
            for (Object element$iv : $receiver$iv) {
                MsKey it = (MsKey)element$iv;
                if (!it.areColNames(names)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final String normalizePredicateExpression(String expression) {
        return MsIntrospectorKt.normalizeExpression(expression);
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizeExpression(String expression) {
        int index$iv$iv;
        int startFound$iv$iv;
        String exp;
        CharSequence charSequence;
        if (expression == null || (charSequence = (CharSequence)expression).length() == 0) {
            return null;
        }
        CharSequence $receiver$iv = expression;
        CharSequence $receiver$iv$iv = $receiver$iv;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv2 = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv2);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv2) {
                if (!match$iv$iv) {
                    startFound$iv$iv2 = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (($receiver$iv = (CharSequence)(exp = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
            return null;
        }
        int n = exp.length();
        if (n > 2 && exp.charAt(0) == '(' && exp.charAt(n - 1) == ')') {
            $receiver$iv$iv = exp;
            startIndex$iv$iv = 1;
            endIndex$iv$iv = n - 1;
            CharSequence charSequence2 = $receiver$iv$iv;
            if (charSequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence2).substring(startIndex$iv$iv, endIndex$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String $receiver$iv2 = string;
            CharSequence $receiver$iv$iv2 = $receiver$iv2;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $receiver$iv$iv2.length() - 1;
            startFound$iv$iv = 0;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                index$iv$iv = startFound$iv$iv == 0 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $receiver$iv$iv2.charAt(index$iv$iv);
                boolean bl = match$iv$iv = it <= ' ';
                if (startFound$iv$iv == 0) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = 1;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            exp = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
        }
        Matcher m = MUFFLED_WORDS.matcher(exp);
        while (exp.length() >= 3 && m.find()) {
            void $receiver$iv3;
            int p1 = m.start();
            int p2 = m.end();
            String endIndex$iv$iv2 = exp;
            startFound$iv$iv = 0;
            StringBuilder stringBuilder = new StringBuilder();
            String string = endIndex$iv$iv2;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(startFound$iv$iv, p1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            endIndex$iv$iv2 = exp;
            startFound$iv$iv = p1 + 1;
            index$iv$iv = p2 - 1;
            stringBuilder = stringBuilder.append(string3);
            String string4 = endIndex$iv$iv2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(startFound$iv$iv, index$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string5;
            endIndex$iv$iv2 = exp;
            stringBuilder = stringBuilder.append(string3);
            String string6 = endIndex$iv$iv2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(p2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string7;
            endIndex$iv$iv2 = stringBuilder.append(string3).toString();
            CharSequence $receiver$iv$iv3 = (CharSequence)$receiver$iv3;
            int startIndex$iv$iv3 = 0;
            int endIndex$iv$iv3 = $receiver$iv$iv3.length() - 1;
            boolean startFound$iv$iv3 = false;
            while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                boolean match$iv$iv;
                int index$iv$iv3 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                char it = $receiver$iv$iv3.charAt(index$iv$iv3);
                boolean bl = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv3) {
                    if (!match$iv$iv) {
                        startFound$iv$iv3 = true;
                        continue;
                    }
                    ++startIndex$iv$iv3;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv3;
            }
            exp = ((Object)$receiver$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString();
            m = MUFFLED_WORDS.matcher(exp);
        }
        return exp;
    }

    private static final Set<TrigEvent> unpackEvents(byte e) {
        int n;
        byte $receiver$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = e;
        byte that$iv = 1;
        byte $receiver$iv$iv = $receiver$iv;
        int n2 = Byte.toUnsignedInt($receiver$iv$iv);
        if ((byte)(n2 & (n = Byte.toUnsignedInt($receiver$iv$iv = that$iv))) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $receiver$iv = e;
        that$iv = 2;
        $receiver$iv$iv = $receiver$iv;
        n2 = Byte.toUnsignedInt($receiver$iv$iv);
        if ((byte)(n2 & (n = Byte.toUnsignedInt($receiver$iv$iv = that$iv))) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        $receiver$iv = e;
        that$iv = 4;
        $receiver$iv$iv = $receiver$iv;
        n2 = Byte.toUnsignedInt($receiver$iv$iv);
        if ((byte)(n2 & (n = Byte.toUnsignedInt($receiver$iv$iv = that$iv))) != 0) {
            events.add(TrigEvent.DELETE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull MsModSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        $receiver.setCreatedTimestamp(createdTimestamp);
        $receiver.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final String catalogPrefix(BasicDatabase database) {
        return '[' + database.getName() + "].sys";
    }

    private static final boolean detectSurrogateName(String name) {
        if (name == null) {
            return false;
        }
        return SURROGATE_NAME_PATTERN.matcher(name).matches();
    }

    private static final DataType makeDataType(String type_name, int max_length, int precision, byte scale) {
        DataType dt;
        if (type_name != null) {
            if (VARIABLE_TYPES.contains((Object)type_name)) {
                if (Intrinsics.areEqual((Object)type_name, (Object)"time") || Intrinsics.areEqual((Object)type_name, (Object)"datetime2") || Intrinsics.areEqual((Object)type_name, (Object)"datetimeoffset")) {
                    int size = scale >= 0 && scale <= 6 ? (int)scale : -1;
                    LengthUnit units = size >= 0 ? LengthUnit.DIGIT : null;
                    DataType dataType = DataTypeFactory.of(null, type_name, size, 0, units, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026nits, null, false, false)");
                    dt = dataType;
                } else if (precision > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, precision, scale, null, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else if (Intrinsics.areEqual((Object)type_name, (Object)"char") || Intrinsics.areEqual((Object)type_name, (Object)"nchar") || Intrinsics.areEqual((Object)type_name, (Object)"varchar") || Intrinsics.areEqual((Object)type_name, (Object)"nvarchar") || Intrinsics.areEqual((Object)type_name, (Object)"varbinary")) {
                    boolean national;
                    boolean bl = national = type_name.charAt(0) == 'n';
                    int length = max_length == -1 ? Integer.MAX_VALUE : (national ? max_length >> 1 : max_length);
                    DataType dataType = DataTypeFactory.of(null, type_name, length, 0, LengthUnit.CHAR, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026CHAR, null, false, false)");
                    dt = dataType;
                } else if (max_length > 0) {
                    DataType dataType = DataTypeFactory.of(null, type_name, max_length, scale, null, null, false, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(null,\u2026null, null, false, false)");
                    dt = dataType;
                } else {
                    DataType dataType = DataTypeFactory.of(type_name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                    dt = dataType;
                }
            } else {
                DataType dataType = DataTypeFactory.of(type_name);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(type_name)");
                dt = dataType;
            }
        } else {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            dt = dataType;
        }
        return dt;
    }

    private static final CascadeRule makeCascadeRule(byte code) {
        CascadeRule cascadeRule;
        switch (code) {
            case 1: {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 2: {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 3: {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e instanceof MsSchemaObject && !(e instanceof MsTableType) && ((MsSchemaObject)e).getModifiedTimestamp() != null;
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(@NotNull BasicElement e) {
        return MsIntrospectorKt.canCheckOutdated(e);
    }

    @NotNull
    public static final /* synthetic */ MsModCustomType access$renewType(@NotNull ModNamingFamily family, int typeId, @NotNull String name) {
        return MsIntrospectorKt.renewType(family, typeId, name);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@Nullable String type_name, int max_length, int precision, byte scale) {
        return MsIntrospectorKt.makeDataType(type_name, max_length, precision, scale);
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(@NotNull MsModSchemaObject $receiver, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        MsIntrospectorKt.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(@Nullable String name) {
        return MsIntrospectorKt.detectSurrogateName(name);
    }

    @Nullable
    public static final /* synthetic */ String access$normalizeExpression(@Nullable String expression) {
        return MsIntrospectorKt.normalizeExpression(expression);
    }

    @Nullable
    public static final /* synthetic */ String access$normalizePredicateExpression(@Nullable String expression) {
        return MsIntrospectorKt.normalizePredicateExpression(expression);
    }

    @NotNull
    public static final /* synthetic */ CascadeRule access$makeCascadeRule(byte code) {
        return MsIntrospectorKt.makeCascadeRule(code);
    }

    @Nullable
    public static final /* synthetic */ MsKey access$findKeyByColumns(@NotNull MsTable $receiver, @NotNull List names) {
        return MsIntrospectorKt.findKeyByColumns($receiver, names);
    }

    @NotNull
    public static final /* synthetic */ Set access$unpackEvents(byte e) {
        return MsIntrospectorKt.unpackEvents(e);
    }

    @NotNull
    public static final /* synthetic */ String access$catalogPrefix(@NotNull BasicDatabase database) {
        return MsIntrospectorKt.catalogPrefix(database);
    }
}

