/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.DataSourceStorageFileType;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFileTypeFactoryBase
extends FileTypeFactory {
    public void createFileTypes(@NotNull FileTypeConsumer consumer2) {
        if (consumer2 == null) {
            DbFileTypeFactoryBase.$$$reportNull$$$0(0);
        }
        consumer2.consume((FileType)new DataSourceStorageFileType(), "ids");
        consumer2.consume((FileType)DbStorageFileType.SqliteStorage.INSTANCE, (String)null);
        consumer2.consume((FileType)DbStorageFileType.H2Storage.INSTANCE, (String)null);
        consumer2.consume((FileType)PlainTextFileType.INSTANCE, "csv");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vfs/DbFileTypeFactoryBase", "createFileTypes"));
    }

    public static class DbFileTypeDetector
    implements FileTypeRegistry.FileTypeDetector {
        private final List<DbStorageFileType> myFileTypes;

        DbFileTypeDetector(FileTypeManager manager) {
            this.myFileTypes = ContainerUtil.findAll((Object[])manager.getRegisteredFileTypes(), DbStorageFileType.class);
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                DbFileTypeDetector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                DbFileTypeDetector.$$$reportNull$$$0(1);
            }
            if (firstCharsIfText != null) {
                return null;
            }
            for (DbStorageFileType fileType : this.myFileTypes) {
                String prefix = fileType.getFilePrefix();
                if (prefix.length() == 0 || firstBytes.length() <= prefix.length() || !prefix.equals(new String(firstBytes.toBytes(), 0, prefix.length()))) continue;
                return fileType;
            }
            return null;
        }

        public int getVersion() {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstBytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/vfs/DbFileTypeFactoryBase$DbFileTypeDetector";
            objectArray[2] = "detect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

