/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import com.jetbrains.php.framework.FrameworkWorkingFolderService;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class FrameworkPathCompletionUtil {
    private static final Logger LOG = Logger.getInstance(FrameworkPathCompletionUtil.class);

    FrameworkPathCompletionUtil() {
    }

    static void addPathCompletionVariants(CompletionResultSet result, String text, Project project) {
        VirtualFile currentFile;
        int startOffset;
        FrameworkWorkingFolderService service = FrameworkWorkingFolderService.getInstance(project);
        String path = service.getWorkingFolder();
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (vFile == null) {
            LOG.warn("Failed to find current working directory " + path);
            return;
        }
        String chosenPath = FrameworkPathCompletionUtil.getPathPrefix(text);
        if (!chosenPath.startsWith("\"")) {
            startOffset = text.length() - chosenPath.length();
        } else {
            startOffset = -1;
            chosenPath = StringUtil.trimStart((String)chosenPath, (String)"\"");
        }
        String providedPath = FrameworkPathCompletionUtil.getProvidedPartOfPath(chosenPath);
        if (providedPath.isEmpty() && SystemInfo.isWindows && FrameworkPathCompletionUtil.isWindowsRootString(chosenPath)) {
            String resultingString = chosenPath + "/";
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(resultingString);
            if (root != null) {
                CompletionResultSet resultSet = result.withPrefixMatcher(chosenPath);
                resultSet.addElement((LookupElement)new FrameworkPathLookupElement(root, resultingString, startOffset));
                return;
            }
        }
        if ((currentFile = FileUtil.isAbsolute((String)(providedPath = FileUtil.toSystemIndependentName((String)providedPath))) ? LocalFileSystem.getInstance().findFileByPath(providedPath) : vFile.findFileByRelativePath(providedPath)) == null || !currentFile.isDirectory()) {
            return;
        }
        VirtualFile[] children = currentFile.getChildren();
        String prefixForCompletion = FrameworkPathCompletionUtil.getPrefixForCompletion(chosenPath);
        CompletionResultSet resultSet = result.withPrefixMatcher(prefixForCompletion);
        for (VirtualFile child : children) {
            String name = child.getName();
            resultSet.addElement((LookupElement)new FrameworkPathLookupElement(child, name, startOffset));
        }
    }

    private static boolean isWindowsRootString(String chosenPath) {
        return chosenPath.length() == 2 && ':' == chosenPath.charAt(1) && Character.isLetter(chosenPath.charAt(0));
    }

    private static String getProvidedPartOfPath(String chosenPath) {
        int indexOfSeparator = Math.max(chosenPath.lastIndexOf("/"), chosenPath.lastIndexOf("\\"));
        return chosenPath.substring(0, indexOfSeparator + 1);
    }

    private static String getPathPrefix(String inputText) {
        if (inputText.endsWith(" ")) {
            return "";
        }
        List parts = StringUtil.splitHonorQuotes((String)inputText, (char)' ');
        if (parts.isEmpty()) {
            return "";
        }
        return (String)parts.get(parts.size() - 1);
    }

    private static String getPrefixForCompletion(String chosenPath) {
        int indexOfSeparator = Math.max(chosenPath.lastIndexOf("/"), chosenPath.lastIndexOf("\\"));
        if (indexOfSeparator != -1) {
            return chosenPath.substring(indexOfSeparator + 1);
        }
        return chosenPath;
    }

    private static class FrameworkPathLookupElement
    extends LookupElement {
        private final VirtualFile myChild;
        private final String myName;
        private final int startOffset;

        private FrameworkPathLookupElement(VirtualFile child, String name, int beginningOffset) {
            this.myChild = child;
            this.myName = name;
            this.startOffset = beginningOffset;
        }

        @NotNull
        public String getLookupString() {
            if (this.myChild.isDirectory()) {
                String string = this.myChild.getName() + "/";
                if (string == null) {
                    FrameworkPathLookupElement.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = this.myChild.getName();
            if (string == null) {
                FrameworkPathLookupElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void renderElement(LookupElementPresentation presentation) {
            presentation.setItemText(this.myName);
            Icon icon = this.myChild.isDirectory() ? PlatformIcons.FOLDER_ICON : this.myChild.getFileType().getIcon();
            presentation.setIcon(icon);
        }

        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                FrameworkPathLookupElement.$$$reportNull$$$0(2);
            }
            if (this.startOffset != -1 && this.myName.contains(" ")) {
                Document document = context.getEditor().getDocument();
                document.insertString(this.startOffset, (CharSequence)"\"");
                document.insertString(context.getTailOffset(), (CharSequence)"\"");
            }
        }

        public boolean isCaseSensitive() {
            return SystemInfo.isFileSystemCaseSensitive;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/completion/FrameworkPathCompletionUtil$FrameworkPathLookupElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/completion/FrameworkPathCompletionUtil$FrameworkPathLookupElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

