/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.PhpRunUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkVersionDetector<V> {
    private static final Logger LOG = Logger.getInstance(PhpTestFrameworkVersionDetector.class);
    private static final String[] VERSION_OPTIONS = new String[]{"--version"};

    @NotNull
    public V getVersion(@NotNull Project project, @NotNull PhpInterpreter interpreter, @Nullable String executable) throws ExecutionException {
        if (project == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(1);
        }
        String name = this.getPresentableName();
        if (StringUtil.isEmpty((String)executable)) {
            throw new ExecutionException(PhpBundle.message("php.test.framework.version.path.to.exe.is.invalid", name));
        }
        String output = this.getCommandOutput(project, interpreter, executable);
        if (StringUtil.isEmpty((String)output)) {
            String options = Arrays.toString(this.getVersionOptions());
            throw new ExecutionException(PhpBundle.message("php.test.framework.version.detector.empty.output", options));
        }
        V v = this.parse(output);
        if (v == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(2);
        }
        return v;
    }

    @NotNull
    protected String[] getVersionOptions() {
        if (VERSION_OPTIONS == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(3);
        }
        return VERSION_OPTIONS;
    }

    @NotNull
    protected abstract String getPresentableName();

    @NotNull
    protected String getTitle() {
        String string = PhpBundle.message("php.test.framework.version.getting.version.title", this.getPresentableName());
        if (string == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected abstract V parse(@NotNull String var1) throws ExecutionException;

    private String getCommandOutput(@NotNull Project project, @NotNull PhpInterpreter interpreter, @NotNull String executable) throws ExecutionException {
        String[] options;
        String phpBinaryPath;
        if (project == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(6);
        }
        if (executable == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)(phpBinaryPath = interpreter.getPathToPhpExecutable()))) {
            throw new ExecutionException(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP Interpreter"));
        }
        PhpCommandSettings command = PhpCommandSettings.createHelperCommand(phpBinaryPath, interpreter.isRemote());
        command.setScript(executable);
        for (String option : options = this.getVersionOptions()) {
            command.addArgument(option);
        }
        GeneralCommandLine commandLine = command.createGeneralCommandLine();
        PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
        ProcessOutput output = PhpExecutionUtil.getProcessOutput(project, data, commandLine, this.getTitle(), null, 30000);
        String stderr = output.getStderr();
        String stdout = output.getStdout();
        if (StringUtil.isEmpty((String)stdout)) {
            throw new ExecutionException(StringUtil.isNotEmpty((String)stderr) ? stderr : PhpBundle.message("php.test.framework.version.detector.empty.output", commandLine.getCommandLineString()));
        }
        if (StringUtil.isNotEmpty((String)stderr)) {
            LOG.debug("Error on executing '" + commandLine.toString() + "': " + stderr);
        }
        return stdout;
    }

    @Nullable
    public static String getPathToExecutable(@NotNull String toolName, @Nullable String path, boolean isLocal) {
        if (toolName == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(8);
        }
        if (!isLocal || StringUtil.isEmpty((String)path) || StringUtil.endsWith((CharSequence)path, (CharSequence)".phar")) {
            return path;
        }
        String scriptName = PathUtil.getFileName((String)path);
        if (SystemInfo.isWindows) {
            String vendor = path;
            for (int attempt = 0; !PhpTestFrameworkVersionDetector.isVendorDir(vendor) && attempt < 2; ++attempt) {
                vendor = PathUtil.getParentPath((String)vendor);
            }
            if (PhpTestFrameworkVersionDetector.isVendorDir(vendor)) {
                String script;
                String name = StringUtil.toLowerCase((String)toolName);
                VirtualFile file = PhpRunUtil.findFile(FileUtil.join((String[])new String[]{vendor, name, name, "bin", script = FileUtil.getNameWithoutExtension((String)scriptName)}));
                if (file == null) {
                    file = PhpRunUtil.findFile(FileUtil.join((String[])new String[]{vendor, name, name, script}));
                }
                if (file != null) {
                    return file.getPath();
                }
            }
        } else {
            VirtualFile file = PhpRunUtil.findFile(path);
            if (file != null) {
                return file.getCanonicalPath();
            }
        }
        return path;
    }

    private static boolean isVendorDir(@NotNull String parent) {
        if (parent == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(9);
        }
        return FileUtil.namesEqual((String)PathUtil.getFileName((String)parent), (String)"vendor");
    }

    public static int versionCompare(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(10);
        }
        if (version2 == null) {
            PhpTestFrameworkVersionDetector.$$$reportNull$$$0(11);
        }
        String[] versions1 = version1.split("\\.");
        String[] versions2 = version2.split("\\.");
        int length = Math.min(versions1.length, versions2.length);
        for (int i = 0; i < length; ++i) {
            int cmp;
            try {
                int first = Integer.parseInt(versions1[i].trim());
                int second = Integer.parseInt(versions2[i].trim());
                cmp = Integer.compare(first, second);
            }
            catch (NumberFormatException e) {
                cmp = versions1[i].compareTo(versions2[i]);
            }
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(versions1.length, versions2.length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpTestFrameworkVersionDetector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpTestFrameworkVersionDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommandOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathToExecutable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVendorDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "versionCompare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

