/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.composer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.composer.LanguageLevelComposerParser;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelComposerSettingConfig
implements ComposerSettingSyncConfigClient<String> {
    @NonNls
    private static final List<String> TAGS = ContainerUtil.newSmartList((Object)"require");

    @Override
    @Nullable
    public String parse(@NotNull Map<String, JsonElement> elements) {
        if (elements == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(0);
        }
        if (elements.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, JsonElement> entry : elements.entrySet()) {
            JsonElement element = entry.getValue();
            if (element == null || !element.isJsonObject()) continue;
            JsonObject object = element.getAsJsonObject();
            JsonElement php = object.get("php");
            if (php == null) {
                php = object.get("PHP");
            }
            if (php == null || !php.isJsonPrimitive()) continue;
            return php.getAsString();
        }
        return null;
    }

    @Override
    public boolean updateSetting(@NotNull Project project, @Nullable String setting) {
        PhpLanguageLevel requiredLevel;
        PhpProjectConfigurationFacade facade;
        PhpLanguageLevel currentLevel;
        if (project == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(1);
        }
        if ((currentLevel = (facade = PhpProjectConfigurationFacade.getInstance(project)).getLanguageLevel()) != (requiredLevel = LanguageLevelComposerParser.getMinRequiredLanguageLevel(setting, project))) {
            facade.setLanguageLevel(requiredLevel);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getSettingTitle() {
        String string = PhpBundle.message(PlatformUtils.isPhpStorm() ? "actions.detect.language.level.loaded.from.composer.title" : "actions.detect.language.level.loaded.from.composer.idea.title", new Object[0]);
        if (string == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder.Settings showSettings() {
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.PHP;
        if (settings == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(3);
        }
        return settings;
    }

    @Override
    public boolean isDefaultSettings(@NotNull Project project, @Nullable String composerJsonPath) {
        if (project == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(4);
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        return PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel() == PhpProjectConfigurationFacade.getInstance(defaultProject).getLanguageLevel();
    }

    @Override
    @NotNull
    public List<String> getPath() {
        List<String> list = TAGS;
        if (list == null) {
            LanguageLevelComposerSettingConfig.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/composer/LanguageLevelComposerSettingConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/composer/LanguageLevelComposerSettingConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "showSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateSetting";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

