/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.smartStepInto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoCaller;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoVariant;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSmartStepIntoHandler
extends XSmartStepIntoHandler<PhpSmartStepIntoVariant> {
    private static final Set<String> CALL_USER_FUNCTION = ContainerUtil.newHashSet((Object[])new String[]{"call_user_func", "call_user_func_array", "forward_static_call", "forward_static_call_array"});
    private static final Set<String> CALL_USER_METHOD = ContainerUtil.newHashSet((Object[])new String[]{"call_user_method", "call_user_method_array"});
    private final XDebugSession mySession;
    private final PhpDebugProcess myProcess;

    public PhpSmartStepIntoHandler(PhpDebugProcess process) {
        this.mySession = process.getSession();
        this.myProcess = process;
    }

    @NotNull
    public List<PhpSmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        int newEndOffset;
        int line;
        if (position == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        ArrayList variants = Lists.newArrayList();
        HashSet visitedCalls = Sets.newHashSet();
        assert (document != null);
        int lineEnd = line = position.getLine();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.mySession.getProject()).getPsiFile(document);
        if (file != null && (newEndOffset = this.iterateInLine(file, document, line, variants, visitedCalls)) != -1) {
            lineEnd = document.getLineNumber(newEndOffset);
        }
        if (lineEnd != line) {
            for (PhpSmartStepIntoVariant variant : variants) {
                variant.setLineEnd(lineEnd);
            }
        }
        ArrayList arrayList = variants;
        if (arrayList == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public int iterateInLine(@NotNull PsiFile file, @NotNull Document document, int line, @NotNull List<PhpSmartStepIntoVariant> variants, @NotNull Set<PhpExpression> visited) {
        TextRange textRange;
        if (file == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        if (document == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(3);
        }
        if (variants == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(4);
        }
        if (visited == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(5);
        }
        try {
            textRange = PhpSmartStepIntoHandler.getRangeOfStatement(file, document, line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return -1;
        }
        int off = textRange.getStartOffset();
        while (off < textRange.getEndOffset()) {
            PsiElement element = file.findElementAt(off);
            if (element != null) {
                PhpSmartStepIntoHandler.processElement(element, variants, visited, textRange.getStartOffset(), line);
                off = element.getTextRange().getEndOffset();
                continue;
            }
            ++off;
        }
        return textRange.getEndOffset();
    }

    public static List<PsiElement> getElements(TextRange textRange, PsiFile file) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        int off = textRange.getStartOffset();
        while (off < textRange.getEndOffset()) {
            PsiElement element = file.findElementAt(off);
            if (element != null) {
                elements.add(element);
                off = element.getTextRange().getEndOffset();
                continue;
            }
            ++off;
        }
        return elements;
    }

    public static TextRange getRangeOfStatement(PsiFile file, Document document, int line) {
        TextRange textRange = new TextRange(document.getLineStartOffset(line), document.getLineEndOffset(line));
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        PsiElement startElement = file.findElementAt(startOffset);
        if (startElement != null) {
            Object statement;
            Object v0 = statement = (startElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(startElement, false)) == null ? null : PhpPsiUtil.getParentByCondition(startElement, false, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (statement != null && !(statement instanceof ControlStatement) && !(statement instanceof GroupStatement)) {
                int statementEnd = statement.getTextRange().getEndOffset();
                endOffset = Math.max(statementEnd, endOffset);
                textRange = new TextRange(startOffset, endOffset);
            }
        }
        return textRange;
    }

    private static void processElement(@NotNull PsiElement element, @NotNull List<PhpSmartStepIntoVariant> variants, @NotNull Set<PhpExpression> visited, int lineOffset, int line) {
        FieldReference field;
        boolean isCallback;
        FunctionReference function;
        NewExpression newExpression;
        if (element == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(6);
        }
        if (variants == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(7);
        }
        if (visited == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(8);
        }
        if (PhpSmartStepIntoHandler.shouldProcess(visited, lineOffset, (PhpExpression)(newExpression = (NewExpression)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)NewExpression.INSTANCEOF)))) {
            ClassReference reference = newExpression.getClassReference();
            if (reference != null) {
                variants.add(new PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant(line, "__construct", newExpression.getText(), reference.getText(), null));
            }
            PhpSmartStepIntoHandler.processElement(newExpression.getParent(), variants, visited, lineOffset, line);
        }
        if (PhpSmartStepIntoHandler.shouldProcess(visited, lineOffset, (PhpExpression)(function = (FunctionReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF))) && !(isCallback = PhpSmartStepIntoHandler.tryToProcessAsCallback(function, variants, line))) {
            if (function instanceof MethodReference) {
                PhpSmartStepIntoHandler.processMemberReference(variants, (MemberReference)((MethodReference)function), line);
            } else {
                String functionName = PhpSmartStepIntoHandler.getFunctionName(function);
                if (!StringUtil.isEmpty((String)functionName)) {
                    variants.add(new PhpSmartStepIntoVariant.PhpFunctionSmartStepIntoVariant(line, functionName, function.getText()));
                } else {
                    PsiElement variable = PhpSmartStepIntoHandler.getVariable(function);
                    if (variable != null) {
                        variants.add(new PhpSmartStepIntoVariant.PhpFunctionSmartStepIntoVariant(line, variable.getText(), function.getText()));
                    }
                }
            }
            PhpSmartStepIntoHandler.processElement(function.getParent(), variants, visited, lineOffset, line);
        }
        if (PhpSmartStepIntoHandler.shouldProcess(visited, lineOffset, (PhpExpression)(field = (FieldReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)FieldReference.INSTANCEOF)))) {
            PhpSmartStepIntoHandler.processMemberReference(variants, (MemberReference)field, line);
        }
    }

    private static boolean tryToProcessAsCallback(@NotNull FunctionReference function, @NotNull List<PhpSmartStepIntoVariant> variants, int line) {
        List<String> callbackFunction;
        if (function == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(9);
        }
        if (variants == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(10);
        }
        if ((callbackFunction = PhpSmartStepIntoHandler.getCallbackFunctionName(function)) != null) {
            if (callbackFunction.size() == 1) {
                variants.add(new PhpSmartStepIntoVariant.PhpFunctionSmartStepIntoVariant(line, callbackFunction.get(0), function.getText()));
            } else if (callbackFunction.size() == 2) {
                variants.add(new PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant(line, callbackFunction.get(1), function.getText(), callbackFunction.get(0), null));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static List<String> getCallbackFunctionName(@NotNull FunctionReference reference) {
        PsiElement[] parameters;
        String functionName;
        if (reference == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(11);
        }
        if (CALL_USER_FUNCTION.contains(functionName = reference.getName())) {
            PsiElement[] parameters2 = reference.getParameters();
            if (parameters2.length > 0) {
                PsiElement function = parameters2[0];
                if (function instanceof StringLiteralExpression) {
                    List split;
                    String name = PhpCodeInsightUtil.toString(function);
                    List list = split = name == null ? null : StringUtil.split((String)name, (String)"::");
                    return split != null && split.size() > 1 ? split : (name == null ? null : StringUtil.split((String)name, (String)"->"));
                }
                if (function instanceof Variable) {
                    return ContainerUtil.newArrayList((Object[])new String[]{function.getText()});
                }
                if (function instanceof ArrayCreationExpression) {
                    PsiElement clazz = PhpPsiUtil.getChildOfType(function, PhpElementTypes.ARRAY_VALUE);
                    PsiElement method = clazz == null ? null : PhpPsiUtil.getChildOfType(function, PhpElementTypes.ARRAY_VALUE, clazz);
                    return PhpSmartStepIntoHandler.extractMethodReferenceByElements(method == null ? null : method.getFirstChild(), clazz == null ? null : clazz.getFirstChild());
                }
            }
        } else if (CALL_USER_METHOD.contains(functionName) && (parameters = reference.getParameters()).length > 1) {
            PsiElement methodReferenceElement = parameters[0];
            PsiElement classReferenceElement = parameters[1];
            return PhpSmartStepIntoHandler.extractMethodReferenceByElements(methodReferenceElement, classReferenceElement);
        }
        return null;
    }

    @Nullable
    private static List<String> extractMethodReferenceByElements(@Nullable PsiElement method, @Nullable PsiElement clazz) {
        if (clazz != null && method != null) {
            String classReference = PhpSmartStepIntoHandler.getValue(clazz);
            String methodReference = PhpSmartStepIntoHandler.getValue(method);
            if (classReference != null && methodReference != null) {
                return ContainerUtil.newArrayList((Object[])new String[]{classReference, methodReference});
            }
        }
        return null;
    }

    @Nullable
    private static String getValue(@NotNull PsiElement element) {
        if (element == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(12);
        }
        if (element instanceof StringLiteralExpression) {
            return PhpCodeInsightUtil.toString(element);
        }
        if (element instanceof Variable) {
            return element.getText();
        }
        if (element instanceof NewExpression) {
            ClassReference reference = ((NewExpression)element).getClassReference();
            return reference == null ? null : reference.getText();
        }
        return null;
    }

    private static boolean shouldProcess(@NotNull Set<PhpExpression> visited, int lineOffset, @Nullable PhpExpression expression) {
        if (visited == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(13);
        }
        return expression != null && expression.getTextRange().getStartOffset() >= lineOffset && visited.add(expression);
    }

    private static void processMemberReference(@NotNull List<PhpSmartStepIntoVariant> variants, @NotNull MemberReference member, int line) {
        PsiElement expression;
        if (variants == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(14);
        }
        if (member == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(15);
        }
        if ((expression = PhpSmartStepIntoHandler.getClassReference(member)) == null) {
            return;
        }
        if (expression instanceof Variable || expression instanceof ClassReference || expression instanceof FieldReference) {
            PhpSmartStepIntoHandler.addMemberVariant(variants, member, null, expression.getText(), line);
        } else if (expression instanceof NewExpression) {
            ClassReference classRef = ((NewExpression)expression).getClassReference();
            if (classRef != null) {
                PhpSmartStepIntoHandler.addMemberVariant(variants, member, null, classRef.getText(), line);
            }
        } else {
            final ArrayList<String> references = new ArrayList<String>();
            final Ref classReference = new Ref();
            expression.accept((PsiElementVisitor)new PhpElementVisitor(){

                public void visitPhpFunctionCall(FunctionReference reference) {
                    String functionName = PhpSmartStepIntoHandler.getFunctionName(reference);
                    if (StringUtil.isNotEmpty((String)functionName)) {
                        references.add(functionName);
                    }
                }

                public void visitPhpMethodReference(MethodReference reference) {
                    String functionName;
                    reference.acceptChildren((PsiElementVisitor)this);
                    PsiElement expression = PhpSmartStepIntoHandler.getClassReference((MemberReference)reference);
                    if (references.isEmpty() && classReference.isNull()) {
                        ClassReference classRef;
                        if (expression instanceof Variable) {
                            classReference.set((Object)expression.getText());
                        } else if (expression instanceof NewExpression && (classRef = ((NewExpression)expression).getClassReference()) != null) {
                            classReference.set((Object)classRef.getText());
                        }
                    }
                    if (StringUtil.isNotEmpty((String)(functionName = PhpSmartStepIntoHandler.getMethodName(reference)))) {
                        references.add(functionName);
                    }
                }
            });
            PhpSmartStepIntoHandler.addMemberVariant(variants, member, references, (String)classReference.get(), line);
        }
    }

    @Nullable
    private static PsiElement getClassReference(@NotNull MemberReference member) {
        PhpExpression expression;
        if (member == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(16);
        }
        if ((expression = member.getClassReference()) instanceof ParenthesizedExpression) {
            expression = ((ParenthesizedExpression)expression).unparenthesize();
        }
        return expression;
    }

    private static void addMemberVariant(@NotNull List<PhpSmartStepIntoVariant> variants, @NotNull MemberReference member, @Nullable List<String> references, @Nullable String classReference, int line) {
        String functionName;
        if (variants == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(17);
        }
        if (member == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(18);
        }
        String string = functionName = member instanceof MethodReference ? PhpSmartStepIntoHandler.getMethodName((MethodReference)member) : "__get";
        if (StringUtil.isNotEmpty((String)functionName)) {
            variants.add(new PhpSmartStepIntoVariant.PhpMethodSmartStepIntoVariant(line, functionName, member.getText(), classReference, references));
        }
    }

    @Nullable
    private static String getFunctionName(@NotNull FunctionReference functionReference) {
        String fqn;
        if (functionReference == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(19);
        }
        return (fqn = functionReference.getFQN()) != null ? PhpLangUtil.toName(fqn) : null;
    }

    @Nullable
    private static String getMethodName(@NotNull MethodReference methodReference) {
        PhpPsiElement functionElement;
        String functionName;
        if (methodReference == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(20);
        }
        if (StringUtil.isNotEmpty((String)(functionName = methodReference.getName()))) {
            return functionName;
        }
        PhpPsiElement parameters = (PhpPsiElement)PhpPsiUtil.getChildByCondition((PsiElement)methodReference, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        PhpPsiElement phpPsiElement = functionElement = parameters == null ? null : parameters.getPrevPsiSibling();
        if (functionElement instanceof Variable) {
            String variableName = functionElement.getName();
            return StringUtil.isEmpty((String)variableName) ? null : "$" + variableName;
        }
        return null;
    }

    @Nullable
    private static PsiElement getVariable(@NotNull FunctionReference function) {
        ParameterList parameterList;
        if (function == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(21);
        }
        PsiElement variable = (parameterList = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)ParameterList.INSTANCEOF)) == null ? null : PhpPsiUtil.findPrevSiblingOfAnyType((PsiElement)parameterList, new IElementType[]{PhpStubElementTypes.VARIABLE});
        return variable instanceof Variable ? variable : null;
    }

    public void startStepInto(@NotNull PhpSmartStepIntoVariant variant) {
        if (variant == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(22);
        }
        new PhpSmartStepIntoCaller(this.myProcess, this.mySession.getProject()).startStepInto(variant);
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            PhpSmartStepIntoHandler.$$$reportNull$$$0(23);
        }
        return PhpBundle.message("debug.process.smart.step.into.popup", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/smartStepInto/PhpSmartStepIntoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateInLine";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToProcessAsCallback";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCallbackFunctionName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processMemberReference";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMemberVariant";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

