/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.connection.PhpDebugServer;
import com.jetbrains.php.debug.xdebug.connection.XdebugServerConnectionManager;
import com.jetbrains.php.debug.xdebug.debugger.XdebugDriver;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.util.QueryString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XdebugExtension
implements PhpDebugExtension {
    public static final XdebugExtension INSTANCE = new XdebugExtension();
    public static final String NAME = "xdebug";
    private static final String XDEBUG_REMOTE_ENABLE = "xdebug.remote_enable";
    private static final String XDEBUG_REMOTE_HOST = "xdebug.remote_host";
    private static final String XDEBUG_REMOTE_PORT = "xdebug.remote_port";
    private static final String XDEBUG_REMOTE_MODE = "xdebug.remote_mode";
    private static final String XDEBUG_COVERAGE_ENABLE = "xdebug.coverage_enable";
    private static final String PARAMETER_XDEBUG_SESSION_START = "XDEBUG_SESSION_START";
    private static final String ENV_XDEBUG_CONFIG = "XDEBUG_CONFIG";

    @Override
    @NotNull
    public String getId() {
        if (NAME == null) {
            XdebugExtension.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            XdebugExtension.$$$reportNull$$$0(1);
        }
        return NAME;
    }

    @Override
    @NotNull
    public List<PhpConfigurationOption> getDebugConfigurationsOptions(@NotNull Project project, @NotNull String remoteHost) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(2);
        }
        if (remoteHost == null) {
            XdebugExtension.$$$reportNull$$$0(3);
        }
        ArrayList options = ContainerUtil.newArrayList((Object[])new PhpConfigurationOption[]{new PhpConfigurationOption(XDEBUG_REMOTE_ENABLE, 1), new PhpConfigurationOption(XDEBUG_REMOTE_MODE, "req")});
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        options.add(new PhpConfigurationOption(XDEBUG_REMOTE_PORT, state.getXDebugDebugPort()));
        options.add(new PhpConfigurationOption(XDEBUG_REMOTE_HOST, remoteHost));
        ArrayList arrayList = options;
        if (arrayList == null) {
            XdebugExtension.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PhpDebugServer startDebugServer(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(5);
        }
        int debugPort = PhpProjectDebugConfiguration.getInstance(project).getState().getXDebugDebugPort();
        PhpDebugServer phpDebugServer = this.startDebugServer(project, debugPort);
        if (phpDebugServer == null) {
            XdebugExtension.$$$reportNull$$$0(6);
        }
        return phpDebugServer;
    }

    @Override
    @NotNull
    public PhpDebugServer startDebugServer(@NotNull Project project, int port) throws ExecutionException {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(7);
        }
        PhpDebugServer phpDebugServer = (PhpDebugServer)XdebugServerConnectionManager.getInstance().start(port);
        if (phpDebugServer == null) {
            XdebugExtension.$$$reportNull$$$0(8);
        }
        return phpDebugServer;
    }

    @Override
    @NotNull
    public PhpDebugConnectionManager createDebugConnectionManager() {
        PhpDebugConnectionManager phpDebugConnectionManager = new PhpDebugConnectionManager();
        if (phpDebugConnectionManager == null) {
            XdebugExtension.$$$reportNull$$$0(9);
        }
        return phpDebugConnectionManager;
    }

    @Override
    @NotNull
    public PhpDebugDriver getDebugDriver() {
        XdebugDriver xdebugDriver = XdebugDriver.INSTANCE;
        if (xdebugDriver == null) {
            XdebugExtension.$$$reportNull$$$0(10);
        }
        return xdebugDriver;
    }

    @Override
    @NotNull
    public Map<String, String> getDebugEnv(@NotNull Project project, boolean breakAtTheFirstLine, @NotNull String sessionId) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(11);
        }
        if (sessionId == null) {
            XdebugExtension.$$$reportNull$$$0(12);
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put(ENV_XDEBUG_CONFIG, "idekey=" + sessionId);
        HashMap<String, String> hashMap = envs;
        if (hashMap == null) {
            XdebugExtension.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public QueryString getDebugQuery(@NotNull Project project, boolean breakAtFistLine, @NotNull String sessionId) {
        if (project == null) {
            XdebugExtension.$$$reportNull$$$0(14);
        }
        if (sessionId == null) {
            XdebugExtension.$$$reportNull$$$0(15);
        }
        QueryString queryString = new QueryString();
        queryString.addParameter(PARAMETER_XDEBUG_SESSION_START, sessionId);
        QueryString queryString2 = queryString;
        if (queryString2 == null) {
            XdebugExtension.$$$reportNull$$$0(16);
        }
        return queryString2;
    }

    @NotNull
    public static List<PhpConfigurationOption> getCoverageConfigurationsOptions() {
        List<PhpConfigurationOption> list = Collections.singletonList(new PhpConfigurationOption(XDEBUG_COVERAGE_ENABLE, 1));
        if (list == null) {
            XdebugExtension.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/XdebugExtension";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHost";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/XdebugExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugConfigurationsOptions";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugServer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugConnectionManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugDriver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugEnv";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugQuery";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageConfigurationsOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDebugConfigurationsOptions";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startDebugServer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDebugEnv";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDebugQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

