/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerStackValue;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerValue;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpression;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpressionImpl;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpressionValue;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerResponseHandler;
import com.jetbrains.php.debug.zend.messages.GetVarRequest;
import com.jetbrains.php.debug.zend.messages.GetVarResponse;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerStackFrame
extends PhpStackFrame<ZendDebuggerConnection> {
    protected final String[] GET_VARIABLES_PATH;
    private final List<? extends Pair<String, String>> myParameters;

    public ZendDebuggerStackFrame(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, int stackDepth, int stackSize, @NotNull String fileName, int lineNumber, @NotNull String functionName, @NotNull List<? extends Pair<String, String>> parameters, @NotNull Runnable reloader) {
        if (debugProcess == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(1);
        }
        if (functionName == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(3);
        }
        if (reloader == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(4);
        }
        super(debugProcess, reloader, fileName, lineNumber - 1, functionName, stackSize, stackDepth);
        this.GET_VARIABLES_PATH = new String[]{"array(\"this\"=>(isset($this) ? array(\"this\"=>$this) : null),\"vars\"=>get_defined_vars(),\"globals\"=>$GLOBALS)"};
        this.myParameters = parameters;
    }

    @Override
    @NotNull
    protected XDebuggerEvaluator createEvaluator() {
        XDebugSession session = this.getDebugProcess().getSession();
        PhpEvaluator phpEvaluator = new PhpEvaluator(session.getProject(), session.getCurrentPosition()){

            @Override
            public void evaluateExpression(@NotNull String expressionToEvaluate, final @NotNull String presentation, final @NotNull String expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
                ZendDebuggerConnection connection;
                if (expressionToEvaluate == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (presentation == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (callback == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((connection = (ZendDebuggerConnection)ZendDebuggerStackFrame.this.getDebugProcess().getConnection()) == null) {
                    callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
                    return;
                }
                connection.send(new GetVarRequest(expressionToEvaluate), new ZendDebuggerResponseHandler<GetVarResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull GetVarResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ZendDebuggerExpressionImpl zendExpression = new ZendDebuggerExpressionImpl(expression, presentation);
                        String variableContent = message.getVariableContent();
                        Project project = ZendDebuggerStackFrame.this.getDebugProcess().getSession().getProject();
                        ZendDebuggerExpressionValue value = ZendDebuggerExpressionValue.deserialize(project, (ZendDebuggerExpression)zendExpression, variableContent.getBytes());
                        if (value.isString() && "IDE_EVAL_ERR".equals(value.getValue())) {
                            callback.errorOccurred(PhpBundle.message("debug.error.cannot.evaluate.expression", new Object[0]));
                            return;
                        }
                        zendExpression.setValue(value);
                        callback.evaluated((XValue)new ZendDebuggerValue(ZendDebuggerStackFrame.this.getDebugProcess(), zendExpression));
                    }

                    @Override
                    public void onErrorResponse(@NotNull GetVarResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        callback.errorOccurred(PhpBundle.message("debug.error.cannot.evaluate.expression", new Object[0]));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "message";
                        objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackFrame$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccessResponse";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onErrorResponse";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expressionToEvaluate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "presentation";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackFrame$1";
                objectArray[2] = "evaluateExpression";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpEvaluator == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(5);
        }
        return phpEvaluator;
    }

    @Override
    protected void computeVariables(@NotNull XCompositeNode node) {
        if (node == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(6);
        }
        if (this.getDepth() == 0) {
            this.computeLocalVariables(node);
        } else {
            this.computeStackVariables(node);
        }
    }

    private void computeLocalVariables(final @NotNull XCompositeNode node) {
        ZendDebuggerConnection connection;
        if (node == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(7);
        }
        if ((connection = (ZendDebuggerConnection)this.getDebugProcess().getConnection()) == null) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        connection.send(new GetVarRequest(2, this.GET_VARIABLES_PATH), new ZendDebuggerResponseHandler<GetVarResponse>(){

            @Override
            public void onSuccessResponse(@NotNull GetVarResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                String variableContent = message.getVariableContent();
                Project project = ZendDebuggerStackFrame.this.getDebugProcess().getSession().getProject();
                ZendDebuggerExpressionValue globalsValue = ZendDebuggerExpressionValue.deserialize(project, null, variableContent.getBytes());
                ZendDebuggerExpression[] children = globalsValue.getChildren();
                XValueChildrenList values = new XValueChildrenList();
                for (ZendDebuggerExpression child : children) {
                    String variableName;
                    if (PhpLangUtil.equalsVariableNames("this", child.getLastName())) {
                        ZendDebuggerExpressionValue value = child.getValue();
                        ZendDebuggerExpression[] zendDebuggerExpressionArray = value.getChildren();
                        int n = zendDebuggerExpressionArray.length;
                        for (int i = 0; i < n; ++i) {
                            ZendDebuggerExpression valueChild = zendDebuggerExpressionArray[i];
                            ZendDebuggerStackFrame.this.addVariable(values, valueChild.getLastName(), new ZendDebuggerValue(ZendDebuggerStackFrame.this.getDebugProcess(), valueChild));
                        }
                        continue;
                    }
                    if ("vars".equals(child.getLastName())) {
                        for (ZendDebuggerExpression valueChild : child.getValue().getChildren()) {
                            variableName = valueChild.getLastName();
                            if (!ZendDebuggerStackFrame.isVar(variableName) || !ZendDebuggerStackFrame.this.isVisible(valueChild)) continue;
                            ZendDebuggerStackFrame.this.addVariable(values, variableName, new ZendDebuggerValue(ZendDebuggerStackFrame.this.getDebugProcess(), valueChild));
                        }
                        continue;
                    }
                    if (!"globals".equals(child.getLastName())) continue;
                    for (ZendDebuggerExpression valueChild : child.getValue().getChildren()) {
                        variableName = valueChild.getLastName();
                        if (!ZendDebuggerStackFrame.isSuperGlobal(variableName) || !ZendDebuggerStackFrame.this.isVisible(valueChild)) continue;
                        values.add(variableName, (XValue)new ZendDebuggerValue(ZendDebuggerStackFrame.this.getDebugProcess(), valueChild));
                    }
                }
                node.addChildren(values, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackFrame$2", "onSuccessResponse"));
            }
        });
    }

    private void addVariable(@NotNull XValueChildrenList values, @NotNull String variableName, @NotNull ZendDebuggerValue value) {
        if (values == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(8);
        }
        if (variableName == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(9);
        }
        if (value == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(10);
        }
        this.myRuntimeEnvironment.registerVariable(value);
        values.add(variableName, (XValue)value);
    }

    private void computeStackVariables(@NotNull XCompositeNode node) {
        if (node == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(11);
        }
        ZendDebuggerConnection connection = (ZendDebuggerConnection)this.getDebugProcess().getConnection();
        node.addChildren(XValueChildrenList.EMPTY, true);
        if (connection == null) {
            return;
        }
        XValueChildrenList values = new XValueChildrenList();
        for (Pair<String, String> pair : this.myParameters) {
            String variableName = (String)pair.getFirst();
            ZendDebuggerExpressionImpl zendExpression = new ZendDebuggerExpressionImpl(variableName, variableName);
            Project project = this.getDebugProcess().getSession().getProject();
            zendExpression.setValue(ZendDebuggerExpressionValue.deserialize(project, (ZendDebuggerExpression)zendExpression, (String)pair.getSecond()));
            values.add(((ZendDebuggerExpression)zendExpression).getLastName(), (XValue)new ZendDebuggerStackValue(this.getDebugProcess(), zendExpression, this.getDepth()));
        }
        node.addChildren(values, true);
    }

    private boolean isVisible(@NotNull ZendDebuggerExpression variable) {
        String variableName;
        if (variable == null) {
            ZendDebuggerStackFrame.$$$reportNull$$$0(12);
        }
        if (PhpLangUtil.isSuperGlobal(variableName = variable.getLastName()) && variable.getValue().getChildrenCount() == 0) {
            return !this.isHideEmptySuperGlobals();
        }
        return !ZendDebuggerStackFrame.isEvalCache(variableName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackFrame";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerStackFrame";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeVariables";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeLocalVariables";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addVariable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeStackVariables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

