/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.codeSmell.PhpCaseInsensitiveProcessor;
import com.jetbrains.php.lang.inspections.quickfix.PhpCaseSensitiveQuickFix;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpCaseInsensitiveFunctionProcessor
implements PhpCaseInsensitiveProcessor {
    ProblemsHolder myHolder;

    public PhpCaseInsensitiveFunctionProcessor(ProblemsHolder holder) {
        this.myHolder = holder;
    }

    @Override
    public void process(PhpReference reference, String resolvedElementName) {
        ASTNode nameNode = reference.getNameNode();
        Object elementToRegister = nameNode != null ? nameNode.getPsi() : reference;
        this.myHolder.registerProblem((PsiElement)elementToRegister, PhpBundle.message("inspection.codeSmell.function.call.is.not.casesensitive", new Object[0]), new LocalQuickFix[]{new PhpFunctionCaseInsensitiveQuickFix(resolvedElementName)});
    }

    static class PhpFunctionCaseInsensitiveQuickFix
    extends PhpCaseSensitiveQuickFix {
        PhpFunctionCaseInsensitiveQuickFix(String resolvedName) {
            super(resolvedName);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            FunctionReference reference;
            PsiElement startElement;
            if (project == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(1);
            }
            if ((startElement = descriptor.getStartElement()) instanceof FunctionReference) {
                reference = (FunctionReference)startElement;
            } else if (startElement.getParent() instanceof FunctionReference) {
                reference = (FunctionReference)startElement.getParent();
            } else {
                return;
            }
            this.doSimpleComittedReplace(project, (PhpReference)reference);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.case.sensitive.name", "function/method reference");
            if (string == null) {
                PhpFunctionCaseInsensitiveQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpCaseInsensitiveFunctionProcessor$PhpFunctionCaseInsensitiveQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpCaseInsensitiveFunctionProcessor$PhpFunctionCaseInsensitiveQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

