/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpWrongStringConcatenationInspection
extends PhpInspection {
    private static final ReplacePlusToConcatQuickFix REPLACE_PLUS_TO_CONCAT_FIX = new ReplacePlusToConcatQuickFix();
    public static final String REPLACE_PLUS_TO_CONCAT_FIX_NAME = REPLACE_PLUS_TO_CONCAT_FIX.getName();
    private static final ReplacePlusAsgnToConcatAsgnQuickFix REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX = new ReplacePlusAsgnToConcatAsgnQuickFix();
    public static final String REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX_NAME = REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX.getName();
    public boolean DISABLE_FOR_MAGIC_PROPERTIES = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpWrongStringConcatenationInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (PhpTokenTypes.opPLUS == expression.getOperationType()) {
                    int numberOfStrings = PhpWrongStringConcatenationInspection.this.checkOperands(expression.getLeftOperand(), expression.getRightOperand());
                    PhpWrongStringConcatenationInspection.inspect((PhpExpression)expression, numberOfStrings, isOnTheFly, holder, REPLACE_PLUS_TO_CONCAT_FIX);
                }
            }

            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                PsiElement operation = expression.getOperation();
                if (operation == null) {
                    return;
                }
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opPLUS_ASGN)) {
                    int numberOfStrings = PhpWrongStringConcatenationInspection.this.checkOperands((PsiElement)expression.getVariable(), (PsiElement)expression.getValue());
                    PhpWrongStringConcatenationInspection.inspect((PhpExpression)expression, numberOfStrings, isOnTheFly, holder, REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpWrongStringConcatenationInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void inspect(PhpExpression expression, int numberOfStrings, boolean isOnTheFly, @NotNull ProblemsHolder holder, LocalQuickFix quickFix) {
        if (holder == null) {
            PhpWrongStringConcatenationInspection.$$$reportNull$$$0(2);
        }
        if (numberOfStrings >= 1) {
            String message = PhpWrongStringConcatenationInspection.getInspectionMessage(isOnTheFly);
            if (numberOfStrings == 2) {
                holder.registerProblem((PsiElement)expression, message, new LocalQuickFix[]{quickFix});
            } else {
                holder.registerProblem((PsiElement)expression, message, LocalQuickFix.EMPTY_ARRAY);
            }
        }
    }

    private static String getInspectionMessage(boolean isOnTheFly) {
        String message = isOnTheFly ? PhpBundle.message("inspection.wrong.string.concatenation.operator.problem", new Object[0]) : PhpBundle.message("inspection.wrong.string.concatenation.operator.problem.batch", new Object[0]);
        return message;
    }

    private int checkOperands(@Nullable PsiElement leftOperand, @Nullable PsiElement rightOperand) {
        if (!(leftOperand instanceof PhpTypedElement) || !(rightOperand instanceof PhpTypedElement)) {
            return 0;
        }
        PhpTypedElement typedLeftOperand = (PhpTypedElement)leftOperand;
        PhpTypedElement typedRightOperand = (PhpTypedElement)rightOperand;
        Project project = leftOperand.getProject();
        int answer = 0;
        if (this.isString(typedLeftOperand, project)) {
            ++answer;
        }
        if (this.isString(typedRightOperand, project)) {
            ++answer;
        }
        return answer;
    }

    private boolean isString(PhpTypedElement element, Project project) {
        if (element instanceof FieldReference && this.isTypeTricky(element, project)) {
            return false;
        }
        PhpType type = element.getType().global(project);
        return type.getTypes().contains("\\string") && type.getTypes().size() == 1;
    }

    private boolean isTypeTricky(PhpTypedElement element, Project project) {
        FieldReference reference = (FieldReference)element;
        ASTNode nameNode = reference.getNameNode();
        if (nameNode == null || PhpPsiUtil.isOfType(nameNode, PhpStubElementTypes.VARIABLE)) {
            return true;
        }
        PhpExpression classReference = reference.getClassReference();
        if (PhpWrongStringConcatenationInspection.chainIsTooDeep(classReference)) {
            return true;
        }
        return this.DISABLE_FOR_MAGIC_PROPERTIES && PhpWrongStringConcatenationInspection.isAccessedViaMagicMethod(project, reference, classReference);
    }

    private static boolean chainIsTooDeep(PhpExpression classReference) {
        return MemberReferenceImpl.getDepth(classReference) == 100;
    }

    private static boolean isAccessedViaMagicMethod(Project project, FieldReference reference, PhpExpression classReference) {
        if (classReference instanceof PhpReference && ((PhpReference)classReference).multiResolve(false).length > 0) {
            PhpType type = classReference.getType().global(project);
            PhpIndex index = PhpIndex.getInstance((Project)project);
            if (reference.multiResolve(false).length == 0 && reference.getReferenceType() == PhpModifier.State.DYNAMIC && PhpCodeInsightUtil.hasMagicMethod(type, index, reference.isWriteAccess() ? "__set" : "__get")) {
                return true;
            }
        }
        return false;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JBCheckBox myDisableForMagicProperties;
        private JPanel myPanel;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myDisableForMagicProperties.setSelected(PhpWrongStringConcatenationInspection.this.DISABLE_FOR_MAGIC_PROPERTIES);
            this.myDisableForMagicProperties.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpWrongStringConcatenationInspection.this.DISABLE_FOR_MAGIC_PROPERTIES = OptionsPanel.this.myDisableForMagicProperties.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myDisableForMagicProperties = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.wrong.string.concatenation.operator.option.ignore.magic"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class ReplacePlusAsgnToConcatAsgnQuickFix
    implements LocalQuickFix {
        private ReplacePlusAsgnToConcatAsgnQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace '+=' to '.='" == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(0);
            }
            return "Replace '+=' to '.='";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(2);
            }
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)descriptor.getPsiElement();
            selfAssignmentExpression.getOperation().replace(PhpPsiElementFactory.createOpConcatAsgn(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusAsgnToConcatAsgnQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusAsgnToConcatAsgnQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReplacePlusToConcatQuickFix
    implements LocalQuickFix {
        private ReplacePlusToConcatQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace '+' to '.'" == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(0);
            }
            return "Replace '+' to '.'";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            BinaryExpression binaryExpression;
            PsiElement operation;
            if (project == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(2);
            }
            if ((operation = (binaryExpression = (BinaryExpression)descriptor.getPsiElement()).getOperation()) != null) {
                int operationOffset = operation.getStartOffsetInParent();
                String currentText = binaryExpression.getText();
                String newText = currentText.substring(0, operationOffset) + '.' + currentText.substring(operationOffset + 1);
                ConcatenationExpression result = PhpPsiElementFactory.createFromText(project, ConcatenationExpression.class, newText);
                assert (result != null);
                binaryExpression.replace((PsiElement)result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusToConcatQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusToConcatQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

