/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.suppression;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressAllForFileCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForFileCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForStatementCommentFix;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSuppressionUtil {
    private static final String SUPPRESS_INSPECTIONS_TAG_NAME = "@noinspection";

    private PhpSuppressionUtil() {
    }

    public static SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(0);
        }
        return new SuppressQuickFix[]{new PhpSuppressForStatementCommentFix(toolId), new PhpSuppressForFileCommentFix(toolId), new PhpSuppressAllForFileCommentFix()};
    }

    public static boolean isSuppressedFor(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (element == null) {
            return true;
        }
        if (element.getContainingFile() instanceof PhpExpressionCodeFragment || PhpParameterBasedTypeProvider.isMeta(element)) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (toolId == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(9);
            }
            if (PhpSuppressionUtil.getSuppressedInStatement(element, toolId) != null) {
                return true;
            }
            if (PhpSuppressionUtil.getSuppressedInFile(element, toolId) != null) {
                return true;
            }
            return false;
        });
    }

    @Nullable
    private static PsiComment getSuppressedInStatement(PsiElement place, @NotNull String toolId) {
        PsiElement statement;
        PsiComment suppressionHolderElement;
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(2);
        }
        if ((suppressionHolderElement = PhpSuppressionUtil.getSuppressionComment(toolId, statement = PhpSuppressionUtil.findEnclosingSuppressibleElement(place))) != null) {
            return suppressionHolderElement;
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressedInFile(PsiElement place, @NotNull String toolId) {
        PsiFile file;
        PsiComment suppressionHolderElement;
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(3);
        }
        if ((suppressionHolderElement = PhpSuppressionUtil.getSuppressionComment(toolId, (PsiElement)(file = place.getContainingFile()))) != null) {
            return suppressionHolderElement;
        }
        return null;
    }

    @NotNull
    public static List<PhpDocComment> getPhpDocComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(4);
        }
        if (element instanceof Statement || element instanceof PhpNamedElement || element instanceof PsiComment) {
            PsiElement parent;
            PhpPsiElement prev = element instanceof PsiComment ? PhpPsiElementImpl.findPrevPhpPsiElement(element) : ((PhpPsiElement)element).getPrevPsiSibling();
            SmartList comments = new SmartList();
            if (element instanceof PhpCase && prev instanceof PhpCase) {
                PsiElement child = prev.getLastChild();
                ASTNode nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child.getNode());
                PsiElement sibling = null;
                if (nonWhitespaceSibling != null) {
                    sibling = nonWhitespaceSibling.getPsi();
                }
                if (sibling instanceof PhpDocComment) {
                    comments.add((PhpDocComment)sibling);
                }
            }
            while (prev instanceof PhpDocComment) {
                comments.add((PhpDocComment)prev);
                prev = prev.getPrevPsiSibling();
            }
            if (comments.size() == 0 && (element instanceof Statement || element instanceof Parameter) && ((parent = element.getParent()) instanceof GroupStatement || parent instanceof ParameterList) && (prev = ((PhpPsiElement)parent).getPrevPsiSibling()) instanceof PhpDocComment) {
                comments.add((PhpDocComment)prev);
            }
            SmartList smartList = comments;
            if (smartList == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(5);
            }
            return smartList;
        }
        if (element instanceof PhpFile) {
            SmartList result = null;
            for (PsiElement child = element.getFirstChild().getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child.getNode() instanceof CompositeElement)) continue;
                if (!PhpDocComment.INSTANCEOF.value((Object)child)) break;
                if (result == null) {
                    result = new SmartList();
                }
                result.add((PhpDocComment)child);
            }
            SmartList smartList = result != null ? result : Collections.emptyList();
            if (smartList == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(6);
            }
            return smartList;
        }
        List<PhpDocComment> list = Collections.emptyList();
        if (list == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static PsiComment getSuppressionComment(@NotNull String toolId, @Nullable PsiElement element) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(8);
        }
        if (element != null) {
            List<PhpDocComment> comments = PhpSuppressionUtil.getPhpDocComments(element);
            for (PhpDocComment comment : comments) {
                PsiElement[] children = comment.getChildren();
                if (children.length <= 0 || !(children[0] instanceof PhpDocTag) || !((PhpDocTag)children[0]).getNameCS().equals(SUPPRESS_INSPECTIONS_TAG_NAME) || !SuppressionUtil.isInspectionToolIdMentioned((String)((PhpDocTag)children[0]).getTagValue(), (String)toolId)) continue;
                return comment;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findEnclosingSuppressibleElement(@Nullable PsiElement element) {
        Object r = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof Statement && !(e instanceof GroupStatement) || e instanceof PhpNamedElement && !(e instanceof PhpDocPsiElement) && !(e instanceof VariableImpl) || e instanceof PsiComment), (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        return r;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressionUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpDocComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInStatement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPhpDocComments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionComment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSuppressedFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

