/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPsiChooserDialog<DialogElement extends PsiElement>
extends DialogWrapper {
    private final Comparator<DialogElement> ELEMENTS_NAME_COMPARATOR = (element1, element2) -> this.getElementName(element1).compareToIgnoreCase(this.getElementName(element2));
    private final SortedListModel<DialogElement> myListModel = new SortedListModel(this.ELEMENTS_NAME_COMPARATOR);
    private final JList myList = new JBList(this.myListModel);
    private final JPanel myWholePanel = new JPanel(new BorderLayout());

    public abstract Collection<DialogElement> getList();

    public abstract DialogElement getInstanceByName(String var1);

    public PhpPsiChooserDialog(JComponent parent, String title) {
        super((Component)parent, false);
        this.setTitle(title);
    }

    protected abstract String getElementName(@NotNull DialogElement var1);

    public void initialization(Condition<DialogElement> filter, @Nullable String initialSelection) {
        this.createList(this.getList(), filter);
        this.myWholePanel.add(ScrollPaneFactory.createScrollPane((Component)this.myList));
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiElement element = (PsiElement)value;
                this.append(PhpPsiChooserDialog.this.getElementName(element));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/php/phpunit/PhpPsiChooserDialog$1", "customizeCellRenderer"));
            }
        });
        this.myList.setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                PhpPsiChooserDialog.this.close(0);
                return true;
            }
        }.installOn((Component)this.myList);
        int index = this.getIndexToSelect(initialSelection);
        if (index == -1) {
            this.myList.clearSelection();
        } else {
            ScrollingUtil.selectItem((JList)this.myList, (int)index);
        }
        this.init();
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PhpPsiChooserDialog.this.updateOkAction();
            }
        });
        this.updateOkAction();
    }

    private void updateOkAction() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1);
    }

    private int getIndexToSelect(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return -1;
        }
        DialogElement element = this.getInstanceByName(name);
        if (element == null) {
            return -1;
        }
        return this.myListModel.indexOf(element);
    }

    private void createList(Collection<DialogElement> elements, Condition<DialogElement> filter) {
        for (PsiElement element : elements) {
            if (!filter.value((Object)element)) continue;
            this.myListModel.add((Object)element);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myWholePanel;
    }

    public DialogElement getSelectedElement() {
        return (DialogElement)((PsiElement)this.myList.getSelectedValue());
    }
}

