/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpParameterRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof Parameter;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(1);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_PARAMETER;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(2);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PARAMETER;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(3);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_PARAMETER = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(4);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PARAMETER = enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        void var8_10;
        PsiElement[] parameters;
        if (element == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(6);
        }
        if (conflicts == null) {
            PhpParameterRenameProcessor.$$$reportNull$$$0(7);
        }
        PsiElement parent = element.getParent();
        assert (parent instanceof ParameterList);
        PsiElement[] psiElementArray = parameters = ((ParameterList)parent).getParameters();
        int n = psiElementArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            PsiElement parameter = psiElementArray[var8_10];
            assert (parameter instanceof Parameter);
            if (parameter != element && PhpLangUtil.equalsParameterNames(newName, ((Parameter)parameter).getName())) {
                conflicts.putValue((Object)parameter, (Object)PhpBundle.message("conflict.parameter.with.same.name.already.exists", new Object[0]));
            }
            ++var8_10;
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(element, true, null);
        for (PhpNamedElement phpNamedElement : declarations) {
            if (!newName.equals(phpNamedElement.getName()) || phpNamedElement instanceof Parameter) continue;
            conflicts.putValue((Object)phpNamedElement, (Object)PhpBundle.message("conflict.variable.with.same.name.already.exists", new Object[0]));
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpParameterRenameProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingNameConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

