/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.script;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.run.script.PhpScriptRunConfiguration;
import com.jetbrains.php.run.script.PhpScriptRunConfigurationType;
import org.jetbrains.annotations.Nullable;

public class PhpScriptRuntimeConfigurationProducer
extends RunConfigurationProducer<PhpScriptRunConfiguration> {
    public PhpScriptRuntimeConfigurationProducer() {
        super((ConfigurationType)PhpScriptRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(PhpScriptRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        VirtualFile root;
        Location location = context.getLocation();
        if (!(location instanceof PsiLocation)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (PhpScriptRuntimeConfigurationProducer.inTest(element)) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (!PhpScriptRuntimeConfigurationProducer.isValid(containingFile)) {
            return false;
        }
        VirtualFile file = containingFile.getVirtualFile();
        sourceElement.set((Object)containingFile);
        if (!FileTypeManager.getInstance().isFileOfType(file, (FileType)ScratchFileType.INSTANCE) && (root = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getContentRootForFile(file)) == null) {
            return false;
        }
        PhpScriptRunConfiguration.Settings params = (PhpScriptRunConfiguration.Settings)configuration.getSettings();
        params.setPath(file.getPresentableUrl());
        configuration.setName(configuration.suggestedName());
        return true;
    }

    public boolean isConfigurationFromContext(PhpScriptRunConfiguration configuration, ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        PsiElement anchor = location.getPsiElement();
        if (PhpScriptRuntimeConfigurationProducer.inTest(anchor)) {
            return false;
        }
        PsiFile containingFile = anchor.getContainingFile();
        if (PhpScriptRuntimeConfigurationProducer.isValid(containingFile)) {
            VirtualFile configurationFile;
            VirtualFile containingVirtualFile = containingFile.getVirtualFile();
            PhpScriptRunConfiguration.Settings params = (PhpScriptRunConfiguration.Settings)configuration.getSettings();
            String path = params.getPath();
            if (path != null && (configurationFile = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
                return StringUtil.equals((CharSequence)containingVirtualFile.getPath(), (CharSequence)configurationFile.getPath());
            }
        }
        return false;
    }

    private static boolean inTest(@Nullable PsiElement anchor) {
        PhpClass parentClass = (PhpClass)PhpPsiUtil.getParentByCondition(anchor, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        return parentClass != null && PhpUnitUtil.isRunnableTestClass(parentClass);
    }

    private static boolean isValid(@Nullable PsiFile containingFile) {
        return containingFile != null && containingFile.getFileType() == PhpFileType.INSTANCE && containingFile.getVirtualFile() != null;
    }
}

