/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inject;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import java.util.EnumSet;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.ecmascript.EcmaScriptUnicodeRegexpLanguage;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRegexpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();

    public boolean characterNeedsEscaping(char c) {
        return c == '/';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        DialectOptionHolder dialect = JSRegexpHost.dialectOfHost((RegExpElement)group);
        if (dialect != null && dialect.isECMA4) {
            return group.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP;
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            return group.getType() == RegExpGroup.Type.NAMED_GROUP;
        }
        return false;
    }

    public boolean isValidGroupName(String name, @NotNull RegExpGroup group) {
        int codePoint;
        DialectOptionHolder holder;
        if (group == null) {
            JSRegexpHost.$$$reportNull$$$0(0);
        }
        if ((holder = JSRegexpHost.dialectOfHost((RegExpElement)group)) == null || !holder.isECMA6) {
            return super.isValidGroupName(name, group);
        }
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        int firstCodePoint = (name = StringUtil.replaceUnicodeEscapeSequences((String)name)).codePointAt(0);
        if (!JSRegexpHost.isGroupNameStart(firstCodePoint)) {
            return false;
        }
        for (int index = Character.charCount(firstCodePoint); index < name.length(); index += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(index);
            if (JSRegexpHost.isGroupNamePart(codePoint)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGroupNameStart(int codePoint) {
        return Character.isUnicodeIdentifierStart(codePoint) || codePoint == 36 || codePoint == 95;
    }

    private static boolean isGroupNamePart(int codePoint) {
        return Character.isUnicodeIdentifierPart(codePoint) || codePoint == 36 || codePoint == 95;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        DialectOptionHolder dialect = JSRegexpHost.dialectOfHost((RegExpElement)ref);
        if (dialect != null && dialect.isECMA4) {
            return ref.isPythonNamedGroupRef();
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            return ref.isNamedGroupRef();
        }
        return false;
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        DialectOptionHolder dialect = JSRegexpHost.dialectOfHost(context);
        if (dialect != null && dialect.isECMA4) {
            EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
            if (enumSet == null) {
                JSRegexpHost.$$$reportNull$$$0(1);
            }
            return enumSet;
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.NAMED_GROUP);
            if (enumSet == null) {
                JSRegexpHost.$$$reportNull$$$0(2);
            }
            return enumSet;
        }
        EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            JSRegexpHost.$$$reportNull$$$0(3);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return EcmaScriptUnicodeRegexpLanguage.INSTANCE.equals(regExpChar.getContainingFile().getLanguage()) && regExpChar.getUnescapedText().charAt(1) == 'u';
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        DialectOptionHolder dialect;
        if (lookbehindGroup == null) {
            JSRegexpHost.$$$reportNull$$$0(4);
        }
        if ((dialect = JSRegexpHost.dialectOfHost((RegExpElement)lookbehindGroup)) != null && dialect.isECMA4) {
            return RegExpLanguageHost.Lookbehind.VARIABLE_LENGTH_ALTERNATION;
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            return RegExpLanguageHost.Lookbehind.FULL;
        }
        return RegExpLanguageHost.Lookbehind.NOT_SUPPORTED;
    }

    private static boolean isES6Regexp(@Nullable DialectOptionHolder dialect) {
        return dialect != null && (dialect.isECMA6 || dialect.isTypeScript);
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            JSRegexpHost.$$$reportNull$$$0(5);
        }
        return this.myPropertiesProvider.isValidCategory(category);
    }

    @NotNull
    public String[][] getAllKnownProperties() {
        String[][] stringArray = this.myPropertiesProvider.getAllKnownProperties();
        if (stringArray == null) {
            JSRegexpHost.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        return this.myPropertiesProvider.getPropertyDescription(name);
    }

    @NotNull
    public String[][] getKnownCharacterClasses() {
        String[][] stringArray = this.myPropertiesProvider.getKnownCharacterClasses();
        if (stringArray == null) {
            JSRegexpHost.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @Nullable
    private static DialectOptionHolder dialectOfHost(@NotNull RegExpElement element) {
        if (element == null) {
            JSRegexpHost.$$$reportNull$$$0(8);
        }
        return DialectDetector.dialectOfElement(FileContextUtil.getFileContext((PsiFile)element.getContainingFile()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inject/JSRegexpHost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inject/JSRegexpHost";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKnownProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownCharacterClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

