/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.control.JSSimplifyIfStatementFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            ConstantIfStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            ConstantIfStatementJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantIfStatementJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        JSIfStatement ifStatement = (JSIfStatement)PsiTreeUtil.getParentOfType((PsiElement)location, JSIfStatement.class);
        if (ifStatement == null) {
            return null;
        }
        return new JSSimplifyIfStatementFix(ControlFlowUtils.isFalse(ifStatement.getCondition()));
    }

    protected static void replaceStatementOrRemove(JSStatement statement, @NonNls String newStatement) throws IncorrectOperationException {
        ASTNode fromText = StringUtil.isEmptyOrSpaces((String)newStatement) ? null : JSChangeUtil.createJSTreeFromTextWithContext(newStatement, (PsiElement)statement);
        PsiElement statementToAdd = fromText != null ? fromText.getPsi() : null;
        JSStatement anchor = statement;
        PsiElement parent = anchor.getParent();
        while (statementToAdd != null) {
            anchor = parent.addAfter(statementToAdd, (PsiElement)anchor);
            statementToAdd = PsiTreeUtil.getNextSiblingOfType((PsiElement)statementToAdd, JSStatement.class);
        }
        statement.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/ConstantIfStatementJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        public void visitJSIfStatement(JSIfStatement statement) {
            super.visitJSIfStatement(statement);
            JSExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            JSStatement thenBranch = statement.getThen();
            if (thenBranch == null) {
                return;
            }
            if (ControlFlowUtils.isTrue(condition) || ControlFlowUtils.isFalse(condition)) {
                this.registerStatementError((JSStatement)statement, new Object[0]);
            }
        }
    }
}

