/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.FullSearchSpecificator;
import org.jetbrains.idea.perforce.perforce.jobs.JobsSearchSpecificator;

public class JobSearchParametersPanel {
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private final JTextField myJobName;
    private final JTextField myUser;
    private final JTextField myDateBefore;
    private final JTextField myDateAfter;
    private final JTextField myDescription;
    private final StatusComboBox myStatus;

    public JobSearchParametersPanel() {
        GridBagConstraints gb = DefaultGb.create();
        gb.fill = 2;
        gb.anchor = 17;
        this.myPanel.add((Component)new JLabel("Job name pattern:"), gb);
        gb.gridx = 1;
        this.myJobName = new JTextField();
        this.myPanel.add((Component)this.myJobName, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.myPanel.add((Component)new JLabel("Status:"), gb);
        gb.gridx = 1;
        this.myStatus = new StatusComboBox();
        this.myPanel.add((Component)this.myStatus, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.myPanel.add((Component)new JLabel("User name pattern:"), gb);
        gb.gridx = 1;
        this.myUser = new JTextField();
        this.myPanel.add((Component)this.myUser, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.myPanel.add((Component)new JLabel("Date Before:"), gb);
        gb.gridx = 1;
        this.myDateBefore = new JTextField();
        this.myPanel.add((Component)this.myDateBefore, gb);
        ++gb.gridy;
        gb.gridx = 1;
        JLabel formatLabel = new JLabel("'yyyy/mm/dd' or 'yyyy/mm/dd:hh:mm:ss'");
        formatLabel.setForeground(UIUtil.getInactiveTextColor());
        this.myPanel.add((Component)formatLabel, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.myPanel.add((Component)new JLabel("Date After:"), gb);
        gb.gridx = 1;
        this.myDateAfter = new JTextField();
        this.myPanel.add((Component)this.myDateAfter, gb);
        ++gb.gridy;
        gb.gridx = 1;
        JLabel formatLabel2 = new JLabel("'yyyy/mm/dd' or 'yyyy/mm/dd:hh:mm:ss'");
        formatLabel2.setForeground(UIUtil.getInactiveTextColor());
        this.myPanel.add((Component)formatLabel2, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.myPanel.add((Component)new JLabel("Description pattern:"), gb);
        gb.gridx = 1;
        this.myDescription = new JTextField();
        this.myPanel.add((Component)this.myDescription, gb);
    }

    public JComponent getPreferredFocusTarget() {
        return this.myJobName;
    }

    private static boolean notEmpty(JTextField f) {
        String t = f.getText();
        return t != null && t.trim().length() > 0;
    }

    public JobsSearchSpecificator createSpecificator() {
        FullSearchSpecificator result = new FullSearchSpecificator();
        if (JobSearchParametersPanel.notEmpty(this.myJobName)) {
            result.addStandardConstraint(FullSearchSpecificator.Parts.jobname, this.myJobName.getText().trim());
        }
        if (JobSearchParametersPanel.notEmpty(this.myUser)) {
            result.addStandardConstraint(FullSearchSpecificator.Parts.user, this.myUser.getText().trim());
        }
        if (!"*".equals(this.myStatus.getSelectedItem())) {
            result.addStandardConstraint(FullSearchSpecificator.Parts.status, this.myStatus.getSelectedItem().trim());
        }
        if (JobSearchParametersPanel.notEmpty(this.myDateBefore)) {
            result.addStandardConstraint(FullSearchSpecificator.Parts.dateBefore, this.myDateBefore.getText().trim());
        }
        if (JobSearchParametersPanel.notEmpty(this.myDateAfter)) {
            result.addStandardConstraint(FullSearchSpecificator.Parts.dateAfter, this.myDateAfter.getText().trim());
        }
        if (JobSearchParametersPanel.notEmpty(this.myDescription)) {
            result.addStandardConstraint(FullSearchSpecificator.Parts.description, this.myDescription.getText().trim());
        }
        return result;
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    private static class SignComboBox
    extends JComboBox {
        private SignComboBox() {
            super(new String[]{"=", "<", ">", "<=", ">="});
            this.setSelectedIndex(0);
            this.setEditable(false);
        }

        @Override
        public String getSelectedItem() {
            return (String)super.getSelectedItem();
        }
    }

    private static class StatusComboBox
    extends JComboBox {
        private StatusComboBox() {
            super(new String[]{"*", "open", "closed", "suspended"});
            this.setSelectedIndex(0);
            this.setEditable(false);
        }

        @Override
        public String getSelectedItem() {
            return (String)super.getSelectedItem();
        }
    }

    private static class AnyFieldGroup {
        private final JComboBox myNameField;
        private final SignComboBox mySign;
        private final JTextField myText;

        private AnyFieldGroup(List<String> freeFields) {
            this.myNameField = new JComboBox<String>(ArrayUtil.toStringArray(freeFields));
            this.myNameField.setEditable(false);
            this.mySign = new SignComboBox();
            this.myText = new JTextField();
        }

        public void addSelf(JPanel main, GridBagConstraints gb) {
            gb.gridx = 0;
            ++gb.gridy;
            main.add((Component)this.myNameField, gb);
            ++gb.gridx;
            gb.fill = 0;
            main.add((Component)this.mySign, gb);
            gb.fill = 2;
            ++gb.gridx;
            main.add((Component)this.myText, gb);
        }

        public void enable(boolean value) {
            this.myNameField.setEnabled(value);
            this.mySign.setEnabled(value);
            this.myText.setEnabled(value);
        }

        public String getValue() {
            return this.myText.getText();
        }
    }
}

