/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CssInHtmlReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            CssInHtmlReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssInHtmlReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlAttributeValue) {
            LinkedList<PsiReference> references = new LinkedList<PsiReference>();
            String text = ((XmlAttributeValue)element).getValue();
            if (StringUtil.isNotEmpty((String)text)) {
                int offset = ((XmlAttributeValue)element).getValueTextRange().getStartOffset() - element.getTextRange().getStartOffset();
                this.doExtractReferences(text, element, references, offset);
                PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    CssInHtmlReferenceProvider.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            CssInHtmlReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    protected abstract void doExtractReferences(@NotNull String var1, @NotNull PsiElement var2, @NotNull List<PsiReference> var3, int var4);

    public ElementFilter getFilter() {
        return new CssInHtmlElementFilter();
    }

    protected boolean isSuitableContextElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CssInHtmlReferenceProvider.$$$reportNull$$$0(4);
        }
        return CssSupportLoader.isInFileThatSupportsCssResolve(psiElement);
    }

    protected abstract boolean isSuitableAttribute(String var1, XmlAttribute var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssInHtmlReferenceProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssInHtmlReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableContextElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class CssInHtmlElementFilter
    implements ElementFilter {
        CssInHtmlElementFilter() {
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            XmlAttribute xmlAttribute;
            String attrName;
            PsiElement parent;
            PsiElement psiElement = (PsiElement)element;
            return CssInHtmlReferenceProvider.this.isSuitableContextElement(psiElement) && (parent = psiElement.getParent()) instanceof XmlAttribute && CssInHtmlReferenceProvider.this.isSuitableAttribute(attrName = (xmlAttribute = (XmlAttribute)parent).getName(), xmlAttribute) && xmlAttribute.getParent().getNamespacePrefix().isEmpty();
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }
}

