/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssValueDeclaration;
import com.intellij.psi.css.CssValueImportedAlias;
import com.intellij.psi.css.CssValueRule;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueReference
extends PsiReferenceBase<PsiElement>
implements CssReference {
    private static final ResolveCache.AbstractResolver<CssValueReference, CssNamedElement> RESOLVER = (reference, incompleteCode) -> {
        String text = reference.getValue();
        if (text.isEmpty()) {
            return null;
        }
        Ref result = Ref.create();
        CssValueReference.processValueRules(reference.getElement(), (Processor<CssNamedElement>)((Processor)element -> {
            if (text.equals(element.getName())) {
                result.set(element);
                return false;
            }
            return true;
        }));
        return (CssNamedElement)result.get();
    };

    public CssValueReference(@NotNull PsiElement element) {
        if (element == null) {
            CssValueReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "@value " + this.getCanonicalText() + " not found";
        if (string == null) {
            CssValueReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
    }

    @NotNull
    public Object[] getVariants() {
        SmartList result = new SmartList();
        CssValueReference.processValueRules(this.myElement, (Processor<CssNamedElement>)((Processor)element -> {
            String name = element.getName();
            if (name != null) {
                ItemPresentation presentation;
                LookupElementBuilder lookup = LookupElementBuilder.create((PsiNamedElement)element).withIcon(CssValueRule.ICON).withTypeText("@value");
                if (element instanceof CssValueDeclaration) {
                    lookup = lookup.withTailText(" " + ((CssValueDeclaration)element).getValueValueText(), true);
                } else if (element instanceof CssValueImportedAlias && (presentation = element.getPresentation()) != null && presentation.getLocationString() != null) {
                    String text = name.equals(presentation.getPresentableText()) ? " from " + presentation.getLocationString() : " " + presentation.getPresentableText() + " from " + presentation.getLocationString();
                    lookup = lookup.withTailText(text, true);
                }
                result.add((Object)lookup);
            }
            return true;
        }));
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            CssValueReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static void processValueRules(@NotNull PsiElement element, @NotNull Processor<CssNamedElement> processor) {
        CssRulesetList rulesetList;
        if (element == null) {
            CssValueReference.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            CssValueReference.$$$reportNull$$$0(4);
        }
        if ((rulesetList = (CssRulesetList)PsiTreeUtil.getParentOfType((PsiElement)element, CssRulesetList.class)) == null) {
            return;
        }
        for (PsiElement child = rulesetList.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof CssValueRule) || ((CssValueRule)child).processValueDeclaringElements(processor)) continue;
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssValueReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssValueReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processValueRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

