/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramColorManager {
    public static final Color NODE_HEADER_COLOR = new JBColor(new Color(215, 213, 172), (Color)Gray._60);
    public static final Color NODE_BG_COLOR = new JBColor(() -> JBColor.isBright() ? new Color(252, 250, 209) : UIUtil.getToolTipBackground());

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        Color c;
        PsiFile psiFile;
        Object element;
        FileColorManager colorManager = FileColorManager.getInstance((Project)builder.getProject());
        DiagramScopeManager scopeManager = builder.getDataModel().getScopeManager();
        if (colorManager.isEnabled() && scopeManager != null && node != null && (element = node.getIdentifyingElement()) instanceof PsiElement && ((PsiElement)element).isValid() && (psiFile = ((PsiElement)element).getContainingFile()) != null && psiFile.isValid() && (c = colorManager.getFileColor(psiFile)) != null) {
            return this.getGradientColor(c);
        }
        return NODE_HEADER_COLOR;
    }

    @NotNull
    protected Color getGradientColor(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int delta = 60;
        JBColor jBColor = new JBColor(new Color(DiagramColorManager.isMax(r, g, b) ? r : Math.max(0, r - 60), DiagramColorManager.isMax(g, b, r) ? g : Math.max(0, g - 60), DiagramColorManager.isMax(b, r, g) ? b : Math.max(0, b - 60)), c);
        if (jBColor == null) {
            DiagramColorManager.$$$reportNull$$$0(0);
        }
        return jBColor;
    }

    public boolean drawGradientInHeader() {
        return true;
    }

    private static boolean isMax(int a, int b, int c) {
        return a >= b && a >= c && (a != b || a != c);
    }

    public Color getNodeBackground(Project project, Object nodeElement, boolean selected) {
        PsiFile psiFile;
        if (selected) {
            return UIUtil.getListSelectionBackground();
        }
        FileColorManager colorManager = FileColorManager.getInstance((Project)project);
        if (colorManager.isEnabled() && nodeElement instanceof PsiElement && ((PsiElement)nodeElement).isValid() && (psiFile = ((PsiElement)nodeElement).getContainingFile()) != null) {
            Color fileColor = colorManager.getFileColor(psiFile);
            if (fileColor != null) {
                return fileColor;
            }
            return JBColor.background();
        }
        return NODE_BG_COLOR;
    }

    public Color getToolbarColor() {
        return UIUtil.getControlColor();
    }

    public abstract Color getNodeForegroundColor(boolean var1);

    public abstract Color getEdgeColor(DiagramEdge var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/DiagramColorManager", "getGradientColor"));
    }
}

