/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.net.HostAndPort;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsCase;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.PortsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.util.PathMappingSettings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerProcessUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File buildDockerImageArchive(@NotNull File dockerfile, File ... srcHelpersDirs) throws IOException {
        if (dockerfile == null) {
            DockerProcessUtil.$$$reportNull$$$0(0);
        }
        if (srcHelpersDirs == null) {
            DockerProcessUtil.$$$reportNull$$$0(1);
        }
        File tarFile = FileUtil.createTempFile((String)"helpers-docker-image", (String)".tar");
        try (TarArchiveOutputStream tarStream = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tarFile))));){
            tarStream.setLongFileMode(2);
            for (File srcHelpersDir : srcHelpersDirs) {
                for (File file : FileUtils.listFiles((File)srcHelpersDir, (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.directoryFileFilter())) {
                    TarArchiveEntry tarEntry = new TarArchiveEntry(file);
                    tarEntry.setName(FileUtil.getRelativePath((File)srcHelpersDir, (File)file));
                    tarStream.putArchiveEntry((ArchiveEntry)tarEntry);
                    if (!file.isDirectory()) {
                        FileUtils.copyFile((File)file, (OutputStream)tarStream);
                    }
                    tarStream.closeArchiveEntry();
                }
            }
            TarArchiveEntry tarEntry = new TarArchiveEntry(dockerfile);
            tarEntry.setName("Dockerfile");
            tarStream.putArchiveEntry((ArchiveEntry)tarEntry);
            FileUtils.copyFile((File)dockerfile, (OutputStream)tarStream);
            tarStream.closeArchiveEntry();
        }
        return tarFile;
    }

    @NotNull
    public static String[] getShContainerCommand() {
        String[] stringArray = new String[]{"/bin/sh"};
        if (stringArray == null) {
            DockerProcessUtil.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public static VolumesBuilder setupVolumesBinds(@Nullable PathMappingSettings mappings) throws RemoteSdkException {
        VolumesBuilder volumesBuilder = DockerProcessUtil.setupVolumesBinds(mappings, null);
        if (volumesBuilder == null) {
            DockerProcessUtil.$$$reportNull$$$0(3);
        }
        return volumesBuilder;
    }

    @NotNull
    public static VolumesBuilder setupVolumesBinds(@Nullable PathMappingSettings mappings, @Nullable DockerContainerSettings containerSettings) throws RemoteSdkException {
        VolumesBuilder bindingBuilder = VolumesBuilder.builder();
        if (mappings != null) {
            for (PathMappingSettings.PathMapping mapping : mappings.getPathMappings()) {
                bindingBuilder.addBoundVolume(mapping.getRemoteRoot(), DockerUtil.toUnixPath(mapping.getLocalRoot()));
            }
        }
        if (containerSettings != null) {
            bindingBuilder.addBoundVolumes(containerSettings.getVolumeBindings());
        }
        VolumesBuilder volumesBuilder = bindingBuilder;
        if (volumesBuilder == null) {
            DockerProcessUtil.$$$reportNull$$$0(4);
        }
        return volumesBuilder;
    }

    @NotNull
    public static String getBuildVersion() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        if (string == null) {
            DockerProcessUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static DockerCredentialsHolder getDockerCredentialsHolder(@NotNull RemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            DockerProcessUtil.$$$reportNull$$$0(6);
        }
        final Ref result = Ref.create();
        commonCredentials.switchOnConnectionType(new CredentialsCase[]{new DockerCredentialsCase(){

            public void process(DockerCredentialsHolder credentials) {
                result.set((Object)credentials);
            }
        }});
        if (result.isNull()) {
            throw new IllegalArgumentException();
        }
        DockerCredentialsHolder dockerCredentialsHolder = (DockerCredentialsHolder)result.get();
        if (dockerCredentialsHolder == null) {
            DockerProcessUtil.$$$reportNull$$$0(7);
        }
        return dockerCredentialsHolder;
    }

    @NotNull
    public static PortsBuilder getWebServerBindPorts(@Nullable HostAndPort data) {
        PortsBuilder portsBuilder = PortsBuilder.builder();
        if (data != null && data.hasPort()) {
            portsBuilder.addPortBinding(data.getPort(), data.getPort());
        }
        PortsBuilder portsBuilder2 = portsBuilder;
        if (portsBuilder2 == null) {
            DockerProcessUtil.$$$reportNull$$$0(8);
        }
        return portsBuilder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcHelpersDirs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerProcessUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerProcessUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShContainerCommand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setupVolumesBinds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerCredentialsHolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerBindPorts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDockerImageArchive";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDockerCredentialsHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

