/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.graph.impl.view.DefaultBackgroundRendererImpl;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.ZoomingDelegate;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;

public class UmlGraphZoomableViewport
extends JBPanelWithEmptyText
implements ZoomableViewport,
Magnificator {
    private final Graph2DView myView;
    private ZoomingDelegate myDelegate;
    private final DiagramBuilder myBuilder;

    public UmlGraphZoomableViewport(DiagramBuilder builder) {
        super((LayoutManager)new BorderLayout());
        this.myBuilder = builder;
        this.myView = builder.getView();
        this.setBackground(((DefaultBackgroundRendererImpl)this.myView.getBackgroundRenderer()).getColor());
        Component component = this.myView.getComponent();
        for (JComponent c : UIUtil.uiTraverser((Component)component).filter(JComponent.class)) {
            c.setOpaque(false);
        }
        this.add(component, "Center");
    }

    public Magnificator getMagnificator() {
        return this;
    }

    public void paint(Graphics g) {
        if (this.myDelegate != null && this.myDelegate.isActive()) {
            this.myDelegate.paint(g);
        } else {
            super.paint(g);
        }
    }

    public Point magnify(double scale, Point at) {
        double oldZoom = this.myView.getZoom();
        double newZoom = oldZoom * scale;
        double oldX = this.myView.toWorldCoordX(at.x);
        double oldY = this.myView.toWorldCoordY(at.y);
        this.myBuilder.zoomView(newZoom);
        double newX = this.myView.toWorldCoordX(at.x);
        double newY = this.myView.toWorldCoordY(at.y);
        double cx = this.myView.getCenter().getX();
        double cy = this.myView.getCenter().getY();
        this.myView.setCenter(cx + oldX - newX, cy + oldY - newY);
        return new Point(0, 0);
    }

    public void magnificationStarted(Point at) {
        this.myDelegate = new ZoomingDelegate((JComponent)this.myView.getComponent(), (JComponent)((Object)this)){

            protected void scrollTo(int voffset, int hoffset) {
            }

            protected Point convertToContentCoordinates(Point point) {
                return point;
            }
        };
        this.myDelegate.magnificationStarted(at);
    }

    public void magnificationFinished(double magnification) {
        this.myDelegate.magnificationFinished(magnification);
        this.myDelegate = null;
    }

    public void magnify(double magnification) {
        this.myDelegate.magnify(magnification);
    }
}

