/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps.reference;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public class CucumberStepReference
implements PsiPolyVariantReference {
    private static final MyResolver RESOLVER = new MyResolver();
    private final PsiElement myStep;
    private final TextRange myRange;

    public CucumberStepReference(PsiElement step, TextRange range) {
        this.myStep = step;
        this.myRange = range;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myStep;
        if (psiElement == null) {
            CucumberStepReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            CucumberStepReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public PsiElement resolve() {
        ResolveResult[] result = this.multiResolve(true);
        return result.length == 1 ? result[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myStep.getText();
        if (string == null) {
            CucumberStepReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CucumberStepReference.$$$reportNull$$$0(3);
        }
        return this.myStep;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CucumberStepReference.$$$reportNull$$$0(4);
        }
        return this.myStep;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        ResolveResult[] resolvedResults;
        if (element == null) {
            CucumberStepReference.$$$reportNull$$$0(5);
        }
        for (ResolveResult rr : resolvedResults = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(rr.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Project project = this.getElement().getProject();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)project).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)RESOLVER, false, incompleteCode);
        if (resolveResultArray == null) {
            CucumberStepReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    private ResolveResult[] multiResolveInner() {
        ArrayList<1> result = new ArrayList<1>();
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        for (CucumberJvmExtensionPoint e : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            List<PsiElement> extensionResult = e.resolveStep(this.myStep);
            for (final PsiElement element : extensionResult) {
                if (element == null || resolvedElements.contains(element)) continue;
                resolvedElements.add(element);
                result.add(new ResolveResult(){

                    public PsiElement getElement() {
                        return element;
                    }

                    public boolean isValidResult() {
                        return true;
                    }
                });
            }
        }
        return result.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Nullable
    public AbstractStepDefinition resolveToDefinition() {
        Collection<AbstractStepDefinition> definitions = this.resolveToDefinitions();
        return definitions.isEmpty() ? null : definitions.iterator().next();
    }

    @NotNull
    public Collection<AbstractStepDefinition> resolveToDefinitions() {
        CucumberStepsIndex index = CucumberStepsIndex.getInstance(this.myStep.getProject());
        Collection<AbstractStepDefinition> collection = index.findStepDefinitions(this.myStep.getContainingFile(), (GherkinStepImpl)this.myStep);
        if (collection == null) {
            CucumberStepReference.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<CucumberStepReference> {
        private MyResolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull CucumberStepReference ref, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            ResolveResult[] resolveResultArray = ref.multiResolveInner();
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference$MyResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

