/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(value="path.macros.xml", roamingType=RoamingType.PER_OS)})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element>,
ModificationTracker {
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    public static final String MAVEN_REPOSITORY = "MAVEN_REPOSITORY";
    private static final Logger LOG = Logger.getInstance(PathMacrosImpl.class);
    private static final Set<String> SYSTEM_MACROS = new THashSet();
    private final Map<String, String> myLegacyMacros = new THashMap();
    private final Map<String, String> myMacros = new LinkedHashMap();
    private long myModificationStamp = 0L;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final List<String> myIgnoredMacros = ContainerUtil.createLockFreeCopyOnWriteList();
    private final AtomicClearableLazyValue<Map<String, String>> myUserMacroMapCache = new AtomicClearableLazyValue<Map<String, String>>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        protected Map<String, String> compute() {
            PathMacrosImpl.this.myLock.readLock().lock();
            if (PathMacrosImpl.this.myMacros.isEmpty()) {
                Map<String, String> map = Collections.emptyMap();
                Map<String, String> map2 = map;
                if (map2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return map2;
            }
            LinkedHashMap result2 = new LinkedHashMap();
            result2.putAll(PathMacrosImpl.this.myMacros);
            Map<String, String> map = Collections.unmodifiableMap(result2);
            Map<String, String> map3 = map;
            if (map3 == null) {
                1.$$$reportNull$$$0(1);
            }
            return map3;
            finally {
                PathMacrosImpl.this.myLock.readLock().unlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/PathMacrosImpl$1", "compute"));
        }
    };

    public static PathMacrosImpl getInstanceEx() {
        return (PathMacrosImpl)PathMacrosImpl.getInstance();
    }

    @NotNull
    public Set<String> getUserMacroNames() {
        Set<String> set = ((Map)this.myUserMacroMapCache.getValue()).keySet();
        if (set == null) {
            PathMacrosImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Map<String, String> getUserMacros() {
        Map map = (Map)this.myUserMacroMapCache.getValue();
        if (map == null) {
            PathMacrosImpl.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public Set<String> getToolMacroNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            PathMacrosImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemMacroNames() {
        Set<String> set = SYSTEM_MACROS;
        if (set == null) {
            PathMacrosImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Collection<String> getIgnoredMacroNames() {
        List<String> list2 = this.myIgnoredMacros;
        if (list2 == null) {
            PathMacrosImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        if (names == null) {
            PathMacrosImpl.$$$reportNull$$$0(5);
        }
        try {
            this.myLock.writeLock().lock();
            this.myIgnoredMacros.clear();
            this.myIgnoredMacros.addAll(names);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void addIgnoredMacro(@NotNull String name) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(6);
        }
        if (!this.myIgnoredMacros.contains(name)) {
            this.myIgnoredMacros.add(name);
        }
    }

    public long getModificationCount() {
        this.myLock.readLock().lock();
        try {
            long l = this.myModificationStamp;
            return l;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public boolean isIgnoredMacroName(@NotNull String macro) {
        if (macro == null) {
            PathMacrosImpl.$$$reportNull$$$0(7);
        }
        return this.myIgnoredMacros.contains(macro);
    }

    @NotNull
    public Set<String> getAllMacroNames() {
        Set set = ContainerUtil.union(this.getUserMacroNames(), this.getSystemMacroNames());
        if (set == null) {
            PathMacrosImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public String getValue(@NotNull String name) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(9);
        }
        try {
            this.myLock.readLock().lock();
            String string = this.myMacros.get(name);
            return string;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public void removeAllMacros() {
        try {
            this.myLock.writeLock().lock();
            this.myMacros.clear();
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @NotNull
    public Collection<String> getLegacyMacroNames() {
        this.myLock.readLock().lock();
        THashSet tHashSet = new THashSet(this.myLegacyMacros.keySet());
        THashSet tHashSet2 = tHashSet;
        if (tHashSet2 == null) {
            PathMacrosImpl.$$$reportNull$$$0(10);
        }
        return tHashSet2;
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMacro(@NotNull String name, @Nullable String value) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(11);
        }
        try {
            this.myLock.writeLock().lock();
            if (StringUtil.isEmptyOrSpaces((String)value)) {
                if (this.myMacros.remove(name) != null) {
                    this.userMacroModified();
                }
                return;
            }
            String prevValue = this.myMacros.put(name, value);
            if (!value.equals(prevValue)) {
                this.userMacroModified();
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private void userMacroModified() {
        ++this.myModificationStamp;
        this.myUserMacroMapCache.drop();
    }

    public void addLegacyMacro(@NotNull String name, @NotNull String value) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(12);
        }
        if (value == null) {
            PathMacrosImpl.$$$reportNull$$$0(13);
        }
        try {
            this.myLock.writeLock().lock();
            this.myLegacyMacros.put(name, value);
            this.myMacros.remove(name);
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void removeMacro(@NotNull String name) {
        if (name == null) {
            PathMacrosImpl.$$$reportNull$$$0(14);
        }
        try {
            this.myLock.writeLock().lock();
            LOG.assertTrue(this.myMacros.remove(name) != null);
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state");
            this.myLock.readLock().lock();
            for (Map.Entry<String, String> entry : this.myMacros.entrySet()) {
                String value = entry.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) continue;
                Element macro = new Element("macro");
                macro.setAttribute("name", entry.getKey());
                macro.setAttribute("value", value);
                element.addContent(macro);
            }
            for (String macro : this.myIgnoredMacros) {
                Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
                macroElement.setAttribute("name", macro);
                element.addContent(macroElement);
            }
            Iterator<Object> iterator = element;
            return iterator;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (element == null) {
            PathMacrosImpl.$$$reportNull$$$0(15);
        }
        try {
            this.myLock.writeLock().lock();
            for (Element macro : element.getChildren("macro")) {
                String name = macro.getAttributeValue("name");
                String value = macro.getAttributeValue("value");
                if (name == null || value == null || SYSTEM_MACROS.contains(name)) continue;
                if (value.length() > 1 && value.charAt(value.length() - 1) == '/') {
                    value = value.substring(0, value.length() - 1);
                }
                this.myMacros.put(name, value);
            }
            for (Element macroElement : element.getChildren(IGNORED_MACRO_ELEMENT)) {
                String ignoredName = macroElement.getAttributeValue("name");
                if (StringUtil.isEmpty((String)ignoredName) || this.myIgnoredMacros.contains(ignoredName)) continue;
                this.myIgnoredMacros.add(ignoredName);
            }
            this.userMacroModified();
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public void addMacroReplacements(@NotNull ReplacePathToMacroMap result2) {
        if (result2 == null) {
            PathMacrosImpl.$$$reportNull$$$0(16);
        }
        Map<String, String> userMacros = this.getUserMacros();
        for (String name : userMacros.keySet()) {
            String value = userMacros.get(name);
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            result2.addMacroReplacement(value, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacroExpands(@NotNull ExpandMacroToPathMap result2) {
        if (result2 == null) {
            PathMacrosImpl.$$$reportNull$$$0(17);
        }
        Map<String, String> userMacros = this.getUserMacros();
        for (String string : userMacros.keySet()) {
            String value = userMacros.get(string);
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            result2.addMacroExpand(string, value);
        }
        this.myLock.readLock().lock();
        try {
            for (Map.Entry entry : this.myLegacyMacros.entrySet()) {
                result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    static {
        SYSTEM_MACROS.add("APPLICATION_HOME_DIR");
        SYSTEM_MACROS.add("APPLICATION_PLUGINS_DIR");
        SYSTEM_MACROS.add("PROJECT_DIR");
        SYSTEM_MACROS.add("MODULE_WORKING_DIR");
        SYSTEM_MACROS.add("MODULE_DIR");
        SYSTEM_MACROS.add("USER_HOME");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/PathMacrosImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMacroNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMacros";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolMacroNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemMacroNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredMacroNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/PathMacrosImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMacroNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyMacroNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredMacroNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredMacro";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredMacroName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMacro";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addLegacyMacro";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeMacro";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addMacroReplacements";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMacroExpands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

