/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class DockablePopupManager<T extends JComponent> {
    protected ToolWindow myToolWindow;
    private Runnable myAutoUpdateRequest;
    @NotNull
    protected final Project myProject;

    public DockablePopupManager(@NotNull Project project) {
        if (project == null) {
            DockablePopupManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    protected abstract String getShowInToolWindowProperty();

    protected abstract String getAutoUpdateEnabledProperty();

    protected boolean getAutoUpdateDefault() {
        return false;
    }

    protected abstract String getAutoUpdateTitle();

    protected abstract String getRestorePopupDescription();

    protected abstract String getAutoUpdateDescription();

    protected abstract T createComponent();

    protected abstract void doUpdateComponent(PsiElement var1, PsiElement var2, T var3);

    protected void doUpdateComponent(Editor editor, PsiFile psiFile, boolean requestFocus) {
        this.doUpdateComponent(editor, psiFile);
    }

    protected abstract void doUpdateComponent(Editor var1, PsiFile var2);

    protected abstract void doUpdateComponent(@NotNull PsiElement var1);

    protected abstract String getTitle(PsiElement var1);

    protected abstract String getToolwindowId();

    public Content recreateToolWindow(PsiElement element, PsiElement originalElement) {
        if (this.myToolWindow == null) {
            this.createToolWindow(element, originalElement);
            return null;
        }
        Content content = this.myToolWindow.getContentManager().getSelectedContent();
        if (content == null || !this.myToolWindow.isVisible()) {
            this.restorePopupBehavior();
            this.createToolWindow(element, originalElement);
            return null;
        }
        return content;
    }

    public void createToolWindow(PsiElement element, PsiElement originalElement) {
        assert (this.myToolWindow == null);
        T component = this.createComponent();
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
        ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(this.getToolwindowId());
        this.myToolWindow = toolWindow == null ? toolWindowManagerEx.registerToolWindow(this.getToolwindowId(), true, ToolWindowAnchor.RIGHT, (Disposable)this.myProject) : toolWindow;
        this.myToolWindow.setIcon(AllIcons.Toolwindows.Documentation);
        this.myToolWindow.setAvailable(true, null);
        this.myToolWindow.setToHideOnEmptyContent(false);
        this.setToolwindowDefaultState();
        this.installComponentActions(this.myToolWindow, component);
        ContentManager contentManager = this.myToolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(component, this.getTitle(element), false);
        contentManager.addContent(content);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockablePopupManager.this.restorePopupBehavior();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/DockablePopupManager$1", "contentRemoved"));
            }
        });
        new UiNotifyConnector(component, new Activatable(){

            public void showNotify() {
                DockablePopupManager.this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(DockablePopupManager.this.getAutoUpdateEnabledProperty(), DockablePopupManager.this.getAutoUpdateDefault()));
            }

            public void hideNotify() {
                DockablePopupManager.this.restartAutoUpdate(false);
            }
        });
        this.myToolWindow.show(null);
        PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.TRUE.toString());
        this.restartAutoUpdate(PropertiesComponent.getInstance().getBoolean(this.getAutoUpdateEnabledProperty(), true));
        this.doUpdateComponent(element, originalElement, component);
    }

    protected void installComponentActions(ToolWindow toolWindow, T component) {
        ((ToolWindowEx)this.myToolWindow).setAdditionalGearActions((ActionGroup)new DefaultActionGroup(this.createActions()));
    }

    protected void setToolwindowDefaultState() {
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        this.myToolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.FLOATING, rectangle);
    }

    protected AnAction[] createActions() {
        ToggleAction toggleAutoUpdateAction = new ToggleAction(this.getAutoUpdateTitle(), this.getAutoUpdateDescription(), AllIcons.General.AutoscrollFromSource){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PropertiesComponent.getInstance().getBoolean(DockablePopupManager.this.getAutoUpdateEnabledProperty(), DockablePopupManager.this.getAutoUpdateDefault());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                PropertiesComponent.getInstance().setValue(DockablePopupManager.this.getAutoUpdateEnabledProperty(), state, DockablePopupManager.this.getAutoUpdateDefault());
                DockablePopupManager.this.restartAutoUpdate(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/documentation/DockablePopupManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return new AnAction[]{this.createRestorePopupAction(), toggleAutoUpdateAction};
    }

    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction anAction = new AnAction("Open as Popup", this.getRestorePopupDescription(), AllIcons.General.Pin_tab){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                DockablePopupManager.this.restorePopupBehavior();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/DockablePopupManager$4", "actionPerformed"));
            }
        };
        if (anAction == null) {
            DockablePopupManager.$$$reportNull$$$0(1);
        }
        return anAction;
    }

    void restartAutoUpdate(boolean state) {
        if (state && this.myToolWindow != null) {
            if (this.myAutoUpdateRequest == null) {
                this.myAutoUpdateRequest = this::updateComponent;
                UIUtil.invokeLaterIfNeeded(() -> IdeEventQueue.getInstance().addIdleListener(this.myAutoUpdateRequest, 500));
            }
        } else if (this.myAutoUpdateRequest != null) {
            IdeEventQueue.getInstance().removeIdleListener(this.myAutoUpdateRequest);
            this.myAutoUpdateRequest = null;
        }
    }

    public void updateComponent() {
        this.updateComponent(false);
    }

    public void updateComponent(boolean requestFocus) {
        if (this.myProject.isDisposed()) {
            return;
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
            if (!this.myProject.isOpen()) {
                return;
            }
            this.updateComponentInner((DataContext)dataContext, requestFocus);
        });
    }

    private void updateComponentInner(@NotNull DataContext dataContext, boolean requestFocus) {
        if (dataContext == null) {
            DockablePopupManager.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element != null) {
                this.doUpdateComponent(element);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
            PsiFile injectedFile;
            if (editor.isDisposed()) {
                return;
            }
            PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.myProject);
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2);
            PsiFile psiFile = injectedFile = injectedEditor != null ? PsiUtilBase.getPsiFileInEditor((Editor)injectedEditor, (Project)this.myProject) : null;
            if (injectedFile != null) {
                this.doUpdateComponent(injectedEditor, injectedFile, requestFocus);
            } else if (file2 != null) {
                this.doUpdateComponent(editor, file2, requestFocus);
            }
        });
    }

    public void restorePopupBehavior() {
        if (this.myToolWindow != null) {
            PropertiesComponent.getInstance().setValue(this.getShowInToolWindowProperty(), Boolean.FALSE.toString());
            ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
            toolWindowManagerEx.hideToolWindow(this.getToolwindowId(), false);
            toolWindowManagerEx.unregisterToolWindow(this.getToolwindowId());
            Disposer.dispose((Disposable)this.myToolWindow.getContentManager());
            this.myToolWindow = null;
            this.restartAutoUpdate(false);
        }
    }

    public boolean hasActiveDockedDocWindow() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DockablePopupManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DockablePopupManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestorePopupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateComponentInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

