/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeViewForProjectViewPane
implements IdeView {
    private final Supplier<? extends AbstractProjectViewPane> supplier;

    public IdeViewForProjectViewPane(Supplier<? extends AbstractProjectViewPane> supplier) {
        this.supplier = supplier;
    }

    @Nullable
    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory(this);
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        AbstractProjectViewPane pane = this.supplier.get();
        PsiDirectory[] psiDirectoryArray = pane == null ? PsiDirectory.EMPTY_ARRAY : pane.getSelectedDirectories();
        if (psiDirectoryArray == null) {
            IdeViewForProjectViewPane.$$$reportNull$$$0(0);
        }
        return psiDirectoryArray;
    }

    public void selectElement(PsiElement element) {
        AbstractProjectViewPane pane = this.supplier.get();
        if (pane == null || element == null) {
            return;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        boolean requestFocus = element instanceof PsiDirectory;
        pane.select(element, file2, requestFocus);
        if (!requestFocus && null == EditorHelper.openInEditor(element, false, true)) {
            pane.select(element, file2, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/IdeViewForProjectViewPane", "getDirectories"));
    }
}

