/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.componentsList.components;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class ScrollablePanel
extends JPanel
implements Scrollable {
    private int myUnitHeight = -1;
    private final int myUnitWidth = 10;

    public ScrollablePanel() {
    }

    public ScrollablePanel(LayoutManager layout) {
        super(layout);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.myUnitHeight < 0) {
            this.myUnitHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return 10;
        }
        return this.myUnitHeight;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

