/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectViewOpener
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        ToolWindowManagerEx manager;
        ToolWindow toolWindow;
        if (baseDir == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(0);
        }
        if ((toolWindow = (manager = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project)).getToolWindow(ToolWindowId.PROJECT_VIEW)) == null) {
            project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyListener(manager, project));
        } else {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> PlatformProjectViewOpener.activateProjectToolWindow(project, toolWindow)));
        }
    }

    private static void activateProjectToolWindow(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            PlatformProjectViewOpener.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                PlatformProjectViewOpener.$$$reportNull$$$0(3);
            }
            if (toolWindow == null) {
                PlatformProjectViewOpener.$$$reportNull$$$0(4);
            }
            if (project.isDisposed()) {
                return;
            }
            if (toolWindow.getType() != ToolWindowType.SLIDING) {
                toolWindow.activate(null);
            }
        }, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/PlatformProjectViewOpener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "activateProjectToolWindow";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$activateProjectToolWindow$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyListener
    implements ToolWindowManagerListener {
        private final ToolWindowManagerEx myManager;
        private final Project myProject;

        MyListener(ToolWindowManagerEx manager, Project project) {
            this.myManager = manager;
            this.myProject = project;
        }

        @Override
        public void toolWindowRegistered(@NotNull String id) {
            if (id == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            if (id.equals(ToolWindowId.PROJECT_VIEW)) {
                this.myManager.removeToolWindowManagerListener(this);
                PlatformProjectViewOpener.activateProjectToolWindow(this.myProject, this.myManager.getToolWindow(id));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/platform/PlatformProjectViewOpener$MyListener", "toolWindowRegistered"));
        }
    }
}

