/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.tasks.Task;
import com.intellij.tasks.context.ContextInfo;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkingContextManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.context.WorkingContextManager");
    @NonNls
    private static final String TASKS_FOLDER = "tasks";
    private final Project myProject;
    @NonNls
    private static final String TASKS_ZIP_POSTFIX = ".tasks.zip";
    @NonNls
    private static final String TASK_XML_POSTFIX = ".task.xml";
    private static final String CONTEXT_ZIP_POSTFIX = ".contexts.zip";
    private static final Comparator<JBZipEntry> ENTRY_COMPARATOR = (o1, o2) -> Long.signum(o2.getTime() - o1.getTime());

    public static WorkingContextManager getInstance(Project project) {
        return (WorkingContextManager)ServiceManager.getService((Project)project, WorkingContextManager.class);
    }

    public WorkingContextManager(Project project) {
        this.myProject = project;
    }

    public void loadContext(Element fromElement) {
        for (WorkingContextProvider provider : (WorkingContextProvider[])WorkingContextProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            try {
                Element child2 = fromElement.getChild(provider.getId());
                if (child2 == null) continue;
                provider.loadContext(child2);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void saveContext(Element toElement) {
        for (WorkingContextProvider provider : (WorkingContextProvider[])WorkingContextProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            try {
                Element child2 = new Element(provider.getId());
                provider.saveContext(child2);
                toElement.addContent(child2);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void clearContext() {
        for (WorkingContextProvider provider : (WorkingContextProvider[])WorkingContextProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            provider.clearContext();
        }
    }

    public void saveContext(Task task) {
        String entryName = task.getId() + TASK_XML_POSTFIX;
        this.saveContext(entryName, TASKS_ZIP_POSTFIX, task.getSummary());
    }

    public void saveContext(@Nullable String entryName, @Nullable String comment) {
        this.saveContext(entryName, CONTEXT_ZIP_POSTFIX, comment);
    }

    public boolean hasContext(String entryName) {
        return this.doEntryAction(CONTEXT_ZIP_POSTFIX, entryName, (ThrowableConsumer<JBZipEntry, Exception>)((ThrowableConsumer)entry -> {}));
    }

    private synchronized void saveContext(@Nullable String entryName, String zipPostfix, @Nullable String comment) {
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            if (entryName == null) {
                int i = archive.getEntries().size();
                do {
                    entryName = "context" + i++;
                } while (archive.getEntry("/" + entryName) != null);
            }
            JBZipEntry entry = archive.getOrCreateEntry("/" + entryName);
            if (comment != null) {
                entry.setComment(StringUtil.first((String)comment, (int)200, (boolean)true));
            }
            Element element = new Element("context");
            this.saveContext(element);
            String s = new XMLOutputter().outputString(element);
            entry.setData(s.getBytes(CharsetToolkit.UTF8_CHARSET));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private JBZipFile getTasksArchive(String postfix) {
        File file2 = this.getArchiveFile(postfix);
        try {
            return new JBZipFile(file2);
        }
        catch (IOException e) {
            file2.delete();
            JBZipFile zipFile = null;
            try {
                zipFile = new JBZipFile(file2);
                Notifications.Bus.notify((Notification)new Notification("Tasks", "Context Data Corrupted", "Context information history for " + this.myProject.getName() + " was corrupted.\nThe history was replaced with empty one.", NotificationType.ERROR), (Project)this.myProject);
            }
            catch (IOException e1) {
                LOG.error("Can't repair form context data corruption", (Throwable)e1);
            }
            return zipFile;
        }
    }

    private File getArchiveFile(String postfix) {
        File tasksFolder = new File(PathManager.getConfigPath(), TASKS_FOLDER);
        if (!tasksFolder.exists()) {
            tasksFolder.mkdirs();
        }
        String projectName = FileUtil.sanitizeFileName((String)this.myProject.getName());
        return new File(tasksFolder, projectName + postfix);
    }

    public void restoreContext(@NotNull Task task) {
        if (task == null) {
            WorkingContextManager.$$$reportNull$$$0(0);
        }
        this.loadContext(TASKS_ZIP_POSTFIX, task.getId() + TASK_XML_POSTFIX);
    }

    private boolean loadContext(String zipPostfix, String entryName) {
        return this.doEntryAction(zipPostfix, entryName, (ThrowableConsumer<JBZipEntry, Exception>)((ThrowableConsumer)entry -> {
            String s = new String(entry.getData(), CharsetToolkit.UTF8_CHARSET);
            this.loadContext(JdomKt.loadElement((CharSequence)s));
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean doEntryAction(String zipPostfix, String entryName, ThrowableConsumer<JBZipEntry, Exception> action) {
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            JBZipEntry entry = archive.getEntry(StringUtil.startsWithChar((CharSequence)entryName, (char)'/') ? entryName : "/" + entryName);
            if (entry == null) return false;
            action.consume((Object)entry);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    public List<ContextInfo> getContextHistory() {
        return this.getContextHistory(CONTEXT_ZIP_POSTFIX);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized List<ContextInfo> getContextHistory(String zipPostfix) {
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            List entries2 = archive.getEntries();
            List list2 = ContainerUtil.mapNotNull((Collection)entries2, (Function)((NullableFunction)entry -> entry.getName().startsWith("/context") ? new ContextInfo(entry.getName(), entry.getTime(), entry.getComment()) : null));
            return list2;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean loadContext(String name) {
        return this.loadContext(CONTEXT_ZIP_POSTFIX, name);
    }

    public void removeContext(String name) {
        this.removeContext(name, CONTEXT_ZIP_POSTFIX);
    }

    public void removeContext(Task task) {
        this.removeContext(task.getId(), TASKS_ZIP_POSTFIX);
    }

    private void removeContext(String name, String postfix) {
        try (JBZipFile archive = this.getTasksArchive(postfix);){
            JBZipEntry entry = archive.getEntry(name);
            if (entry != null) {
                archive.eraseEntry(entry);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void pack(int max, int delta) {
        this.pack(max, delta, CONTEXT_ZIP_POSTFIX);
        this.pack(max, delta, TASKS_ZIP_POSTFIX);
    }

    private synchronized void pack(int max, int delta, String zipPostfix) {
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            List entries2 = archive.getEntries();
            if (entries2.size() > max + delta) {
                JBZipEntry[] array = entries2.toArray(new JBZipEntry[0]);
                Arrays.sort(array, ENTRY_COMPARATOR);
                for (int i = array.length - 1; i >= max; --i) {
                    archive.eraseEntry(array[i]);
                }
                archive.gc();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public File getContextFile() {
        return this.getArchiveFile(CONTEXT_ZIP_POSTFIX);
    }

    public File getTaskFile() {
        return this.getArchiveFile(TASKS_ZIP_POSTFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/context/WorkingContextManager", "restoreContext"));
    }
}

