/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.snapshot;

import com.projectlibre1.configuration.Settings;
import com.projectlibre1.pm.snapshot.DataSnapshot;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.strings.Messages;
import java.io.Serializable;
import org.apache.commons.collections.Closure;

public class SnapshottableImpl
implements Snapshottable,
Serializable {
    DataSnapshot[] snapshots = null;
    private static String[] snapshotNames = null;

    public SnapshottableImpl(int n) {
        this.snapshots = new DataSnapshot[n];
    }

    @Override
    public DataSnapshot getSnapshot(Object object) {
        return this.snapshots[(Integer)object];
    }

    @Override
    public void setSnapshot(Object object, DataSnapshot dataSnapshot) {
        this.snapshots[((Integer)object).intValue()] = this.cloneSnapshot(dataSnapshot);
    }

    @Override
    public void saveCurrentToSnapshot(Object object) {
        this.setSnapshot(object, this.snapshots[CURRENT]);
    }

    @Override
    public DataSnapshot getCurrentSnapshot() {
        return this.snapshots[CURRENT];
    }

    @Override
    public void setCurrentSnapshot(DataSnapshot dataSnapshot) {
        this.snapshots[SnapshottableImpl.CURRENT.intValue()] = dataSnapshot;
    }

    @Override
    public void clearSnapshot(Object object) {
        this.snapshots[((Integer)object).intValue()] = null;
    }

    @Override
    public DataSnapshot cloneSnapshot(DataSnapshot dataSnapshot) {
        return dataSnapshot;
    }

    public static String snapshotName(int n) {
        String string = Messages.getString("Text.Baseline");
        if (n > 0) {
            string = string + " " + n;
        }
        return string;
    }

    public static String[] getSnapshotNames() {
        if (snapshotNames == null) {
            snapshotNames = new String[Settings.NUM_ARRAY_BASELINES];
            for (int i = 0; i < Settings.NUM_ARRAY_BASELINES; ++i) {
                SnapshottableImpl.snapshotNames[i] = SnapshottableImpl.snapshotName(i);
            }
        }
        return snapshotNames;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object cloneWithTask(Task task) {
        SnapshottableImpl snapshottableImpl = (SnapshottableImpl)this.clone();
        snapshottableImpl.snapshots = new DataSnapshot[this.snapshots.length];
        for (int i = 0; i < this.snapshots.length; ++i) {
            snapshottableImpl.snapshots[i] = this.snapshots[i] == null ? null : (DataSnapshot)((TaskSnapshot)this.snapshots[i]).deepCloneWithTask(task);
        }
        return snapshottableImpl;
    }

    public static class ClearSnapshotClosure
    implements Closure {
        Object snapshotId;

        public ClearSnapshotClosure(Object object) {
            this.snapshotId = object;
        }

        @Override
        public void execute(Object object) {
            if (object instanceof Snapshottable) {
                ((Snapshottable)object).clearSnapshot(this.snapshotId);
            }
        }
    }

    public static class SaveCurrentToSnapshotClosure
    implements Closure {
        Object snapshotId;

        public SaveCurrentToSnapshotClosure(Object object) {
            this.snapshotId = object;
        }

        @Override
        public void execute(Object object) {
            if (object instanceof Snapshottable) {
                ((Snapshottable)object).saveCurrentToSnapshot(this.snapshotId);
            }
        }
    }
}

