/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import javax.swing.table.AbstractTableModel;
import org.wiztools.commons.MultiValueMap;

public class TwoColumnTableModel
extends AbstractTableModel {
    private final String[] colNames;
    private Object[][] data = new String[0][0];

    public TwoColumnTableModel(String[] colNames) {
        if (colNames.length != 2) {
            throw new IllegalArgumentException("The length of array should be equal to 2.");
        }
        this.colNames = colNames;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void insertRow(Object key, Object value) {
        int len = this.data.length;
        Object[][] t = new Object[len + 1][2];
        t[0][0] = key;
        t[0][1] = value;
        for (int i = 1; i < len + 1; ++i) {
            System.arraycopy(this.data[i - 1], 0, t[i], 0, 2);
        }
        this.data = null;
        this.data = t;
        this.fireTableDataChanged();
    }

    public void deleteRow(int row) {
        int len = this.data.length;
        Object[][] t = new Object[len - 1][2];
        boolean passedDeletionRow = false;
        for (int i = 0; i < len; ++i) {
            if (i == row) {
                passedDeletionRow = true;
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                if (!passedDeletionRow) {
                    t[i][j] = this.data[i][j];
                    continue;
                }
                t[i - 1][j] = this.data[i][j];
            }
        }
        this.data = null;
        this.data = t;
        this.fireTableDataChanged();
    }

    public void setData(MultiValueMap<String, String> dataMap) {
        Object[][] o = new Object[dataMap.values().size()][2];
        int i = 0;
        for (String key : dataMap.keySet()) {
            for (String value : dataMap.get(key)) {
                o[i][0] = key;
                o[i][1] = value;
                ++i;
            }
        }
        this.data = null;
        this.data = o;
        this.fireTableDataChanged();
    }

    public Object[][] getData() {
        return this.data;
    }
}

