/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.Constants;
import com.yourkit.util.FileUtil;
import com.yourkit.util.PresentableException;
import com.yourkit.util.Strings;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class Agent {
    public static final long CAPABILITY_ATTACHED_AGENT = 1024L;
    public static final long CAPABILITY_EXCEPTION_EVENTS_NOT_AVAILABLE = 16384L;
    public static final long CAPABILITY_EXCEPTION_EVENTS_NOT_AVAILABLE_IBM = 65536L;
    public static final long CAPABILITY_EXCEPTION_EVENTS_NOT_AVAILABLE_BY_OPTION = 131072L;
    private static final boolean USE_PARENTHESES = Constants.OS_WINDOWS;
    @NotNull
    public static final String[] SNAPSHOT_NAME_MACROS = new String[]{"{date}", "{datetime}", "{pid}"};
    @NotNull
    public static final String DEFAULT_SNAPSHOT_NAME_FORMAT = "{sessionname}-{date}";

    private static String getDateForSnapshotFileName() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(new Date());
    }

    private static String getDateTimeForSnapshotFileName() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm", Locale.US).format(new Date());
    }

    private static String expandSnapshotNameMacros(@NotNull String nameWithMacros, @NotNull String sessionName, int pid) {
        if (nameWithMacros == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (sessionName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String name = Strings.replaceMultiple(Strings.notEmpty(nameWithMacros, DEFAULT_SNAPSHOT_NAME_FORMAT), "{sessionname}", FileUtil.toFileNamePart(sessionName), "{date}", Agent.getDateForSnapshotFileName(), "{datetime}", Agent.getDateTimeForSnapshotFileName(), "{pid}", Integer.toString(pid));
        return FileUtil.toFileNamePart(name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String getFileName(String fileNamePrefix, int index, String fileExtension) {
        String string;
        if (index == 0) {
            string = fileNamePrefix + fileExtension;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        if (USE_PARENTHESES) {
            string = fileNamePrefix + "(" + index + ")" + fileExtension;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = fileNamePrefix + "-" + index + fileExtension;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static File suggestSnapshotFile(@NotNull String snapshotNameFormat, @NotNull File directory, @NotNull String sessionName, int pid, @NotNull String fileExtension) {
        File file;
        int n;
        File[] fileArray;
        String nameWithoutNumber;
        String end;
        String start;
        int maxFound;
        if (snapshotNameFormat == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (sessionName == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException("Parameter 5 must not be null");
        }
        if (!directory.isDirectory()) {
            throw new PresentableException("Bad directory: " + FileUtil.normalize(directory) + "\n\nPlease check 'Settings | Snapshot Directory...'");
        }
        String fileNameExpanded = Agent.expandSnapshotNameMacros(snapshotNameFormat, sessionName, pid);
        File[] files = directory.listFiles();
        if (files != null) {
            maxFound = -1;
            start = USE_PARENTHESES ? fileNameExpanded + "(" : fileNameExpanded + "-";
            end = USE_PARENTHESES ? ")" + fileExtension : fileExtension;
            nameWithoutNumber = Agent.getFileName(fileNameExpanded, 0, fileExtension);
            fileArray = files;
            n = fileArray.length;
        } else {
            int index = 0;
            while (true) {
                File result;
                if (!(result = new File(directory, Agent.getFileName(fileNameExpanded, index, fileExtension))).exists()) {
                    file = result;
                    if (file == null) throw new IllegalStateException("Method must not return null");
                    return file;
                }
                ++index;
            }
        }
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray[i];
            String name = file2.getName();
            if (name.equals(nameWithoutNumber)) {
                maxFound = Math.max(maxFound, 0);
                continue;
            }
            if (!name.startsWith(start) || !name.endsWith(end)) continue;
            String numberStr = name.substring(start.length(), name.length() - end.length());
            try {
                int value = Integer.parseInt(numberStr);
                maxFound = Math.max(value, maxFound);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        file = new File(directory, Agent.getFileName(fileNameExpanded, maxFound + 1, fileExtension));
        if (file != null) return file;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static byte[][] getBytecode(@NotNull Class[] classes) {
        if (classes == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (Class aClass : classes) {
            Agent.addBytecode(result, new Class[]{aClass});
            result.add(null);
        }
        byte[][] byArray = (byte[][])result.toArray((T[])new byte[result.size()][]);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    private static void addBytecode(@NotNull ArrayList<byte[]> result, @NotNull Class[] classes) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        for (Class aClass : classes) {
            result.add(Agent.getClassBytes(aClass));
            Agent.addBytecode(result, aClass.getDeclaredClasses());
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static byte[] getClassBytes(@NotNull Class aClass) {
        byte[] byArray;
        InputStream stream;
        block6: {
            if (aClass == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            stream = aClass.getResourceAsStream("/" + aClass.getName().replace('.', '/') + ".class");
            byArray = FileUtil.readBytes(stream);
            stream.close();
            if (byArray != null) break block6;
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String validateJavaTypeOrEmpty(String str, boolean addTypeToErrorMessage) {
        if (str.isEmpty()) {
            return null;
        }
        if (Strings.isValidJavaIdentifier(str)) {
            return null;
        }
        return "Invalid class or interface name" + (addTypeToErrorMessage ? " '" + str + "'" : "");
    }
}

