/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandler<Target extends IntroduceTarget, Scope extends PsiElement>
implements RefactoringActionHandler {
    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null || file2 == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int caretCount = editor.getCaretModel().getCaretCount();
        if (caretCount != 1) {
            this.cannotPerformRefactoring(project, editor);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            this.invokeOnSelection(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), project, editor, file2);
        } else {
            Pair<List<Target>, Integer> targetInfo = this.collectTargets(file2, editor, project);
            List list2 = (List)targetInfo.getFirst();
            if (list2.isEmpty()) {
                this.cannotPerformRefactoring(project, editor);
            } else if (list2.size() == 1) {
                this.invokeOnTarget((IntroduceTarget)list2.get(0), file2, editor, project);
            } else {
                IntroduceTargetChooser.showIntroduceTargetChooser(editor, list2, new Pass<Target>(){

                    public void pass(Target target2) {
                        IntroduceHandler.this.invokeOnTarget(target2, file2, editor, project);
                    }
                }, "Expressions", (Integer)targetInfo.getSecond());
            }
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            IntroduceHandler.$$$reportNull$$$0(2);
        }
    }

    private void invokeOnTarget(@NotNull Target target2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project) {
        String message;
        if (target2 == null) {
            IntroduceHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            IntroduceHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(6);
        }
        if ((message = this.checkSelectedTarget(target2, file2, editor, project)) != null) {
            this.showErrorHint(message, editor, project);
            return;
        }
        this.invokeScopeStep(target2, file2, editor, project);
    }

    private void invokeOnSelection(int start2, int end, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Target target2;
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            IntroduceHandler.$$$reportNull$$$0(9);
        }
        if ((target2 = this.findSelectionTarget(start2, end, file2, editor, project)) != null) {
            this.invokeScopeStep(target2, file2, editor, project);
        } else {
            this.cannotPerformRefactoring(project, editor);
        }
    }

    private void invokeScopeStep(@NotNull Target target2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project) {
        List<Scope> scopes;
        if (target2 == null) {
            IntroduceHandler.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            IntroduceHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(12);
        }
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(13);
        }
        if ((scopes = this.collectTargetScopes(target2, editor, file2, project)).isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)this.getEmptyScopeErrorMessage());
            this.showErrorHint(message, editor, project);
            return;
        }
        if (scopes.size() == 1) {
            this.invokeFindUsageStep(target2, (PsiElement)scopes.get(0), file2, editor, project);
        } else {
            PsiElement[] scopeArray = PsiUtilCore.toPsiElementArray(scopes);
            NavigationUtil.getPsiElementPopup((PsiElement[])scopeArray, this.getScopeRenderer(), (String)this.getChooseScopeTitle(), scope -> {
                if (target2 == null) {
                    IntroduceHandler.$$$reportNull$$$0(38);
                }
                if (file2 == null) {
                    IntroduceHandler.$$$reportNull$$$0(39);
                }
                if (editor == null) {
                    IntroduceHandler.$$$reportNull$$$0(40);
                }
                if (project == null) {
                    IntroduceHandler.$$$reportNull$$$0(41);
                }
                this.invokeFindUsageStep(target2, scope, file2, editor, project);
                return false;
            }).showInBestPositionFor(editor);
        }
    }

    private void invokeFindUsageStep(@NotNull Target target2, @NotNull Scope scope, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project) {
        List<UsageInfo> usages;
        String message;
        if (target2 == null) {
            IntroduceHandler.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            IntroduceHandler.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            IntroduceHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(17);
        }
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(18);
        }
        if ((message = this.checkUsages(usages = this.collectUsages(target2, scope))) != null) {
            this.showErrorHint(message, editor, project);
            return;
        }
        this.invokeDialogStep(target2, scope, usages, file2, editor, project);
    }

    private void invokeDialogStep(final @NotNull Target target2, final @NotNull Scope scope, final @NotNull List<UsageInfo> usages, final @NotNull PsiFile file2, final @NotNull Editor editor, final @NotNull Project project) {
        if (target2 == null) {
            IntroduceHandler.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            IntroduceHandler.$$$reportNull$$$0(20);
        }
        if (usages == null) {
            IntroduceHandler.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            IntroduceHandler.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(23);
        }
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(24);
        }
        Map occurrencesMap = this.getOccurrenceOptions(target2, usages);
        OccurrencesChooser<Object> chooser = new OccurrencesChooser<Object>(editor){

            @Override
            protected TextRange getOccurrenceRange(Object occurrence) {
                return IntroduceHandler.this.getOccurrenceRange(occurrence);
            }
        };
        chooser.showChooser(new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                AbstractInplaceIntroducer<?, ?> introducer = IntroduceHandler.this.getIntroducer(target2, scope, usages, choice, file2, editor, project);
                introducer.startInplaceIntroduceTemplate();
            }
        }, occurrencesMap);
    }

    @NotNull
    private TextRange getOccurrenceRange(@NotNull Object occurrence) {
        if (occurrence == null) {
            IntroduceHandler.$$$reportNull$$$0(25);
        }
        if (occurrence instanceof PsiElement) {
            TextRange textRange = ((PsiElement)occurrence).getTextRange();
            if (textRange == null) {
                IntroduceHandler.$$$reportNull$$$0(26);
            }
            return textRange;
        }
        if (occurrence instanceof UsageInfo) {
            Segment segment = ((UsageInfo)occurrence).getSegment();
            assert (segment != null);
            TextRange textRange = TextRange.create((Segment)segment);
            if (textRange == null) {
                IntroduceHandler.$$$reportNull$$$0(27);
            }
            return textRange;
        }
        TextRange textRange = ((IntroduceTarget)occurrence).getTextRange();
        if (textRange == null) {
            IntroduceHandler.$$$reportNull$$$0(28);
        }
        return textRange;
    }

    @NotNull
    private Map<OccurrencesChooser.ReplaceChoice, List<Object>> getOccurrenceOptions(@NotNull Target target2, @NotNull List<UsageInfo> usages) {
        if (target2 == null) {
            IntroduceHandler.$$$reportNull$$$0(29);
        }
        if (usages == null) {
            IntroduceHandler.$$$reportNull$$$0(30);
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        map.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(target2));
        if (usages.size() > 1) {
            map.put(OccurrencesChooser.ReplaceChoice.ALL, ContainerUtil.newArrayList(usages));
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            IntroduceHandler.$$$reportNull$$$0(31);
        }
        return linkedHashMap;
    }

    @NotNull
    protected abstract List<UsageInfo> collectUsages(@NotNull Target var1, @NotNull Scope var2);

    @Nullable
    protected abstract String checkUsages(@NotNull List<UsageInfo> var1);

    @NotNull
    protected abstract List<Scope> collectTargetScopes(@NotNull Target var1, @NotNull Editor var2, @NotNull PsiFile var3, @NotNull Project var4);

    @NotNull
    protected abstract Pair<List<Target>, Integer> collectTargets(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull Project var3);

    @Nullable
    protected abstract Target findSelectionTarget(int var1, int var2, @NotNull PsiFile var3, @NotNull Editor var4, @NotNull Project var5);

    @Nullable
    protected abstract String checkSelectedTarget(@NotNull Target var1, @NotNull PsiFile var2, @NotNull Editor var3, @NotNull Project var4);

    @NotNull
    protected abstract String getRefactoringName();

    @Nullable
    protected abstract String getHelpID();

    @NotNull
    protected abstract String getChooseScopeTitle();

    @NotNull
    protected abstract PsiElementListCellRenderer<Scope> getScopeRenderer();

    @NotNull
    protected abstract AbstractInplaceIntroducer<?, ?> getIntroducer(@NotNull Target var1, @NotNull Scope var2, @NotNull List<UsageInfo> var3, @NotNull OccurrencesChooser.ReplaceChoice var4, @NotNull PsiFile var5, @NotNull Editor var6, @NotNull Project var7);

    @NotNull
    protected String getEmptyScopeErrorMessage() {
        String string = this.getRefactoringName() + " is not available in the current scope";
        if (string == null) {
            IntroduceHandler.$$$reportNull$$$0(32);
        }
        return string;
    }

    protected void showErrorHint(@NotNull String errorMessage, @NotNull Editor editor, @NotNull Project project) {
        if (errorMessage == null) {
            IntroduceHandler.$$$reportNull$$$0(33);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(34);
        }
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(35);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)this.getRefactoringName(), (String)this.getHelpID());
    }

    private void cannotPerformRefactoring(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            IntroduceHandler.$$$reportNull$$$0(36);
        }
        if (editor == null) {
            IntroduceHandler.$$$reportNull$$$0(37);
        }
        this.showErrorHint(RefactoringBundle.message((String)"cannot.perform.refactoring"), editor, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 19: 
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 16: 
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 17: 
            case 23: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduce/IntroduceHandler";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduce/IntroduceHandler";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrenceRange";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrenceOptions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyScopeErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnTarget";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnSelection";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeScopeStep";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invokeFindUsageStep";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialogStep";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceRange";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceOptions";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "cannotPerformRefactoring";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeScopeStep$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

