/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgres.PostgresObjectBuilder;
import com.intellij.database.dialects.postgres.model.PgModAccessMethod;
import com.intellij.database.dialects.postgres.model.PgModAggregate;
import com.intellij.database.dialects.postgres.model.PgModExtension;
import com.intellij.database.dialects.postgres.model.PgModForeignDataWrapper;
import com.intellij.database.dialects.postgres.model.PgModForeignServer;
import com.intellij.database.dialects.postgres.model.PgModLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgModMatView;
import com.intellij.database.dialects.postgres.model.PgModRole;
import com.intellij.database.dialects.postgres.model.PgModRoutine;
import com.intellij.database.dialects.postgres.model.PgModRule;
import com.intellij.database.dialects.postgres.model.PgModSchema;
import com.intellij.database.dialects.postgres.model.PgModSequence;
import com.intellij.database.dialects.postgres.model.PgModTrigger;
import com.intellij.database.dialects.postgres.model.PgModUserMapping;
import com.intellij.database.dialects.postgresbase.PgBaseObjectBuilder;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PgAccessMethodType;
import com.intellij.database.model.properties.PgAggregateKind;
import com.intellij.database.model.properties.PgRoutineConcurrencyKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.psi.PgCreateAggregateStatementImpl;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateSequenceStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateUserStatementImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020!2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\"\u001a\u00020#2\b\u0010\f\u001a\u0004\u0018\u00010$H\u0002J\u0018\u0010%\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020)2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$H\u0002J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\f\u001a\u00020$H\u0002J\u0019\u00101\u001a\u0004\u0018\u0001022\b\u0010\f\u001a\u0004\u0018\u00010$H\u0002\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\b\u0012\u0004\u0012\u00020\u0007052\b\u0010\f\u001a\u0004\u0018\u00010$H\u0002J\u001a\u00106\u001a\u0004\u0018\u0001002\u0006\u0010\f\u001a\u00020$2\u0006\u00107\u001a\u000208H\u0002J\u0014\u00109\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010:\u001a\u0004\u0018\u000100*\u0004\u0018\u00010;H\u0002R*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/database/dialects/postgres/PostgresObjectBuilder;", "Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "()V", "triggerRoutines", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/dialects/postgres/model/PgModTrigger;", "kotlin.jvm.PlatformType", "", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildAccessMethod", "Lcom/intellij/database/dialects/postgres/model/PgModAccessMethod;", "buildAggregate", "Lcom/intellij/database/dialects/postgres/model/PgModAggregate;", "buildExtension", "Lcom/intellij/database/dialects/postgres/model/PgModExtension;", "buildForeignDataWrapper", "Lcom/intellij/database/dialects/postgres/model/PgModForeignDataWrapper;", "buildForeignServer", "Lcom/intellij/database/dialects/postgres/model/PgModForeignServer;", "buildMatView", "Lcom/intellij/database/dialects/postgres/model/PgModMatView;", "buildRole", "Lcom/intellij/database/dialects/postgres/model/PgModRole;", "buildRoutine", "Lcom/intellij/database/dialects/postgres/model/PgModRoutine;", "buildRule", "Lcom/intellij/database/dialects/postgres/model/PgModRule;", "buildSequence", "Lcom/intellij/database/dialects/postgres/model/PgModSequence;", "buildSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "Lcom/intellij/psi/PsiElement;", "buildTrigger", "buildTypedType", "Lcom/intellij/database/model/basic/BasicModTypedElement;", "buildUserMapping", "Lcom/intellij/database/dialects/postgres/model/PgModUserMapping;", "finalize", "finalizeTrigger", "findConcurrencyKind", "Lcom/intellij/database/model/properties/PgRoutineConcurrencyKind;", "element", "findFunctionReference", "Lcom/intellij/database/dialects/postgres/PostgresObjectBuilder$Reference;", "findNumber", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Long;", "findOptions", "", "findReference", "type", "Lcom/intellij/sql/psi/SqlReferenceElementType;", "findUser", "asReferenceData", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Reference", "intellij.database.dialects"})
public class PostgresObjectBuilder
extends PgBaseObjectBuilder {
    private final ConcurrentMap<PgModTrigger, String> triggerRoutines;

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgModSequence) {
            this.buildSequence((PgModSequence)obj2, source);
        } else if (basicModElement instanceof PgModRoutine) {
            this.buildRoutine((PgModRoutine)obj2, source);
        } else if (basicModElement instanceof PgModForeignDataWrapper) {
            this.buildForeignDataWrapper((PgModForeignDataWrapper)obj2, source);
        } else if (basicModElement instanceof PgModForeignServer) {
            this.buildForeignServer((PgModForeignServer)obj2, source);
        } else if (basicModElement instanceof PgModUserMapping) {
            this.buildUserMapping((PgModUserMapping)obj2, source);
        } else if (basicModElement instanceof PgModRole) {
            this.buildRole((PgModRole)obj2, source);
        } else if (basicModElement instanceof PgModRule) {
            this.buildRule((PgModRule)obj2, source);
        } else if (basicModElement instanceof PgModAggregate) {
            this.buildAggregate((PgModAggregate)obj2, source);
        } else if (basicModElement instanceof PgModAccessMethod) {
            this.buildAccessMethod((PgModAccessMethod)obj2, source);
        } else if (basicModElement instanceof PgModTrigger) {
            this.buildTrigger((PgModTrigger)obj2, source);
        } else if (basicModElement instanceof PgModMatView) {
            this.buildMatView((PgModMatView)obj2, source);
        } else if (basicModElement instanceof PgModExtension) {
            this.buildExtension((PgModExtension)obj2, source);
        } else {
            super.build(obj2, source);
        }
    }

    private final void buildExtension(PgModExtension obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String schemaName = null;
            String version = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement child = tmp$iv$iv;
                IElementType iElementType = this.getElementType(child);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    PsiElement first$iv$iv2;
                    PostgresObjectBuilder this_$iv2;
                    PostgresObjectBuilder postgresObjectBuilder2 = this_$iv2 = this;
                    for (PsiElement tmp$iv$iv2 = first$iv$iv2 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it = tmp$iv$iv2;
                        IElementType iElementType2 = this.getElementType(it);
                        if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                        version = this.findString(it);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SCHEMA)) continue;
                schemaName = this.findSchemaInSiblings(child);
            }
            obj2.setSchemaName(schemaName);
            obj2.setVersion(version);
            obj2.setAvailableUpdates(CollectionsKt.emptyList());
            obj2.setSchemaId(null);
        }
    }

    private final void buildMatView(PgModMatView obj2, DasObject source) {
        this.buildBasicElement(obj2, source);
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ PostgresObjectBuilder this$0;
            final /* synthetic */ PgModMatView $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateViewStatement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((object = (SqlCreateViewStatement)dasObject) != null && (object = object.getQueryExpression()) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = postgresObjectBuilder;
                this.$obj = pgModMatView;
                this.$source = dasObject;
            }
        });
    }

    @Override
    public void finalize(@NotNull BasicModElement obj2) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgModTrigger) {
            this.finalizeTrigger((PgModTrigger)obj2);
        } else {
            super.finalize(obj2);
        }
    }

    private final void finalizeTrigger(PgModTrigger obj2) {
        String string = (String)this.triggerRoutines.get(obj2);
        if (string == null) {
            return;
        }
        String fooName = string;
        PgModSchema pgModSchema = obj2.getSchema();
        Intrinsics.checkExpressionValueIsNotNull((Object)pgModSchema, (String)"obj.schema");
        PgModRoutine r = (PgModRoutine)pgModSchema.getRoutines().get(fooName);
        if (r == null) {
            PgModSchema pgModSchema2 = obj2.getSchema();
            Intrinsics.checkExpressionValueIsNotNull((Object)pgModSchema2, (String)"obj.schema");
            Object e = pgModSchema2.getRoutines().createNewOne();
            if (e == null) {
                Intrinsics.throwNpe();
            }
            r = (PgModRoutine)e;
            r.setName(fooName);
        }
        if (r.getObjectId() == Long.MIN_VALUE) {
            r.setObjectId(new Random().nextLong());
        }
        obj2.setCallRoutineId(r.getObjectId());
    }

    private final void buildTrigger(PgModTrigger obj2, DasObject source) {
        String fooName;
        SqlFunctionCallExpression sqlFunctionCallExpression;
        PgModTrigger pgModTrigger = obj2;
        if (pgModTrigger == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        }
        this.buildTrigger((BasicModTrigger)pgModTrigger, source);
        DasObject dasObject = source;
        if (!(dasObject instanceof SqlCreateTriggerStatement)) {
            dasObject = null;
        }
        SqlCreateTriggerStatement sqlCreateTriggerStatement = (SqlCreateTriggerStatement)dasObject;
        Object object = sqlCreateTriggerStatement != null ? sqlCreateTriggerStatement.getTriggerProcedure() : null;
        if (!(object instanceof SqlFunctionCallExpression)) {
            object = null;
        }
        String string = (sqlFunctionCallExpression = (SqlFunctionCallExpression)object) != null && (sqlFunctionCallExpression = sqlFunctionCallExpression.getNameElement()) != null ? sqlFunctionCallExpression.getName() : (fooName = null);
        if (fooName == null) {
            obj2.setCallRoutineId(0L);
        } else {
            Map map = this.triggerRoutines;
            String string2 = fooName;
            map.put(obj2, string2);
        }
    }

    private final void buildAccessMethod(PgModAccessMethod obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            PgAccessMethodType type = PgAccessMethodType.UNKNOWN;
            String handler = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first$iv$iv2;
                PostgresObjectBuilder this_$iv2;
                PsiElement child = tmp$iv$iv;
                IElementType iElementType = this.getElementType(child);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_CLAUSE)) continue;
                PostgresObjectBuilder postgresObjectBuilder2 = this_$iv2 = this;
                for (PsiElement tmp$iv$iv2 = first$iv$iv2 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    PsiElement it = tmp$iv$iv2;
                    IElementType iElementType2 = this.getElementType(it);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_INDEX)) {
                        type = PgAccessMethodType.INDEX;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_HANDLER)) continue;
                    Reference reference = this.findFunctionReference(it);
                    handler = reference != null ? reference.getFullName() : null;
                }
            }
            obj2.setType(type);
            obj2.setHandler(handler);
        }
    }

    private final void buildAggregate(PgModAggregate obj2, DasObject source) {
        if (source instanceof PgCreateAggregateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String transitionFunction = null;
            DataType transitionType = DataType.UNKNOWN;
            String finalFunction = null;
            String initialCondition = null;
            String sortOperator = null;
            boolean finalExtra = false;
            String combineFunction = null;
            String serializationFunction = null;
            String deserializationFunction = null;
            String movingTransition = null;
            String inverseTransition = null;
            DataType movingStateType = DataType.UNKNOWN;
            long stateSize = 0L;
            long movingStateSize = 0L;
            String movingFinalFunction = null;
            boolean movingFinalExtra = false;
            String movingInitialCondition = null;
            PgAggregateKind kind = PgAggregateKind.NORMAL;
            PgRoutineConcurrencyKind concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
            int directArgs = 0;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first$iv$iv2;
                PostgresObjectBuilder this_$iv2;
                PsiElement it;
                PsiElement psiElement;
                IElementType iElementType;
                PsiElement it2;
                PsiElement tmp$iv$iv2;
                PostgresObjectBuilder $receiver$iv;
                PsiElement child = tmp$iv$iv;
                IElementType iElementType2 = this.getElementType(child);
                if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlElementTypes.SQL_PARAMETER_LIST)) {
                    int index2;
                    block35: {
                        int n;
                        Object[] objectArray = child.getChildren();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"child.children");
                        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)buildAggregate.1.index.1.INSTANCE);
                        int index$iv = 0;
                        Iterator iterator = $receiver$iv.iterator();
                        while (iterator.hasNext()) {
                            Object item$iv = iterator.next();
                            if (index$iv < 0) {
                                throw (Throwable)new ArithmeticException("Index overflow has happened.");
                            }
                            PsiElement it3 = (PsiElement)item$iv;
                            if (it3 instanceof SqlOrderByClause) {
                                n = index$iv;
                                break block35;
                            }
                            ++index$iv;
                        }
                        n = index2 = -1;
                    }
                    if (index2 <= 0) continue;
                    directArgs = index2;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE)) {
                    PsiElement first$iv$iv3;
                    PostgresObjectBuilder this_$iv3;
                    $receiver$iv = this_$iv3 = this;
                    for (tmp$iv$iv2 = first$iv$iv3 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        it2 = tmp$iv$iv2;
                        iElementType = this.getElementType(it2);
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            transitionFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INITCOND)) {
                            String string = this.findString(it2);
                            if (string == null) {
                                Float f = this.findNumberInSiblings(it2);
                                string = f != null ? String.valueOf((int)f.floatValue()) : null;
                            }
                            initialCondition = string;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SORTOP)) {
                            SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_OPERATOR_REFERENCE;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_OPERATOR_REFERENCE");
                            Reference reference = this.findReference(it2, sqlReferenceElementType);
                            sortOperator = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FINALFUNC_EXTRA)) {
                            finalExtra = true;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_COMBINEFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            combineFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SERIALFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            serializationFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_DESERIALFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            deserializationFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MSFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            movingTransition = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MINVFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            inverseTransition = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MSTYPE)) {
                            Unit unit;
                            SqlTypeElement sqlTypeElement;
                            SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                            PsiElement psiElement2 = this.findSibling(it2, (IElementType)sqlCompositeElementType);
                            if (!(psiElement2 instanceof SqlTypeElement)) {
                                psiElement2 = null;
                            }
                            if ((sqlTypeElement = (SqlTypeElement)psiElement2) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                                it = psiElement = sqlTypeElement;
                                movingStateType = it;
                                unit = Unit.INSTANCE;
                                continue;
                            }
                            unit = null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SSPACE)) {
                            Float f = this.findNumberInSiblings(it2);
                            stateSize = f != null ? (long)f.floatValue() : 0L;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MSSPACE)) {
                            Float f = this.findNumberInSiblings(it2);
                            movingStateSize = f != null ? (long)f.floatValue() : 0L;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MFINALFUNC)) {
                            Reference reference = this.findFunctionReference(it2);
                            movingFinalFunction = reference != null ? reference.getFullName() : null;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MFINALFUNC_EXTRA)) {
                            movingFinalExtra = true;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_MINITCOND)) {
                            String string = this.findString(it2);
                            if (string == null) {
                                Float f = this.findNumberInSiblings(it2);
                                string = f != null ? String.valueOf((int)f.floatValue()) : null;
                            }
                            movingInitialCondition = string;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HYPOTHETICAL)) {
                            kind = PgAggregateKind.HYPO_SET;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) continue;
                        concurrencyKind = this.findConcurrencyKind(it2);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)((Object)SqlCompositeElementTypes.SQL_RETURNS_CLAUSE))) continue;
                PostgresObjectBuilder this_$iv$iv = this_$iv2 = this;
                for (tmp$iv$iv2 = first$iv$iv2 = child.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    Unit unit;
                    it2 = tmp$iv$iv2;
                    iElementType = this.getElementType(it2);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STYPE)) {
                        Unit unit2;
                        SqlTypeElement sqlTypeElement;
                        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                        PsiElement psiElement3 = this.findSibling(it2, (IElementType)sqlCompositeElementType);
                        if (!(psiElement3 instanceof SqlTypeElement)) {
                            psiElement3 = null;
                        }
                        if ((sqlTypeElement = (SqlTypeElement)psiElement3) != null && (sqlTypeElement = sqlTypeElement.getDataType()) != null) {
                            it = psiElement = sqlTypeElement;
                            transitionType = it;
                            unit2 = Unit.INSTANCE;
                            continue;
                        }
                        unit2 = null;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FINALFUNC)) continue;
                    SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_FUNCTION_CALL;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_FUNCTION_CALL");
                    if (this.findSibling(it2, (IElementType)sqlCompositeElementType) != null) {
                        PsiElement call = psiElement;
                        PsiElement psiElement4 = call;
                        if (!(psiElement4 instanceof SqlFunctionCallExpression)) {
                            psiElement4 = null;
                        }
                        SqlFunctionCallExpression sqlFunctionCallExpression = (SqlFunctionCallExpression)psiElement4;
                        Object object = sqlFunctionCallExpression != null ? sqlFunctionCallExpression.getCallableExpression() : null;
                        if (!(object instanceof SqlReferenceExpression)) {
                            object = null;
                        }
                        SqlReferenceExpression reference = (SqlReferenceExpression)object;
                        Reference reference2 = this.asReferenceData(reference);
                        finalFunction = reference2 != null ? reference2.getFullName() : null;
                        unit = Unit.INSTANCE;
                        continue;
                    }
                    unit = null;
                }
            }
            obj2.setTransition(transitionFunction);
            obj2.setTransitionDataType(transitionType);
            obj2.setFinal(finalFunction);
            obj2.setInitialValue(initialCondition);
            obj2.setSortOperator(sortOperator);
            obj2.setCombine(combineFunction);
            obj2.setSerialization(serializationFunction);
            obj2.setDeserialization(deserializationFunction);
            obj2.setFinalExtra(finalExtra);
            obj2.setMovingTransition(movingTransition);
            obj2.setInverseTransition(inverseTransition);
            obj2.setMovingStateType(movingStateType);
            obj2.setStateSize(stateSize);
            obj2.setMovingStateSize(movingStateSize);
            obj2.setMovingFinal(movingFinalFunction);
            obj2.setMovingFinalExtra(movingFinalExtra);
            obj2.setMovingInitialValue(movingInitialCondition);
            obj2.setAggregateKind(kind);
            obj2.setConcurrencyKind(concurrencyKind);
            obj2.setDirectArgs(directArgs);
        }
    }

    private final void buildRole(PgModRole obj2, DasObject source) {
        boolean isSuper = false;
        boolean isInherit = true;
        boolean canCreateRole = false;
        boolean canCreateDb = false;
        boolean canLogin = source instanceof SqlCreateUserStatementImpl;
        boolean isReplication = false;
        long connectionLimit = -1L;
        String validUntil = null;
        boolean isBypassRls = false;
        if (source instanceof SqlCreateStatement) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement c2;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlClause)) continue;
                PsiElement psiElement = c2 = ((SqlClause)it).getFirstChild();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"c");
                IElementType iElementType = this.getElementType(psiElement);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SUPERUSER)) {
                    isSuper = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOINHERIT)) {
                    isInherit = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEROLE)) {
                    canCreateRole = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CREATEDB)) {
                    canCreateDb = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LOGIN)) {
                    canLogin = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOLOGIN)) {
                    canLogin = false;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_REPLICATION)) {
                    isReplication = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CONNECTION)) {
                    IElementType iElementType2 = PgTypes.PG_LIMIT;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"PG_LIMIT");
                    Float f = this.findNumberInSiblings(this.findSibling(c2, iElementType2));
                    connectionLimit = f != null ? (long)f.floatValue() : -1L;
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALID)) {
                    IElementType iElementType3 = PgTypes.PG_UNTIL;
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_UNTIL");
                    validUntil = this.findString(this.findSibling(c2, iElementType3));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_BYPASSRLS)) continue;
                isBypassRls = true;
            }
        }
        obj2.setSuperRole(isSuper);
        obj2.setInherit(isInherit);
        obj2.setCreateRole(canCreateRole);
        obj2.setCreateDb(canCreateDb);
        obj2.setCanLogin(canLogin);
        obj2.setReplication(isReplication);
        obj2.setConnectionLimit(connectionLimit);
        obj2.setValidUntil(validUntil);
        obj2.setBypassRls(isBypassRls);
    }

    private final void buildRule(PgModRule obj2, DasObject source) {
        Object object;
        PgModRule pgModRule;
        String condition;
        block11: {
            block10: {
                this.buildBasicElement(obj2, source);
                TrigTurn turn = null;
                TrigEvent event = null;
                condition = null;
                if (source instanceof SqlCreateStatement) {
                    PsiElement first$iv$iv;
                    PostgresObjectBuilder this_$iv;
                    PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
                    for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        SqlExpression sqlExpression;
                        PsiElement psiElement;
                        block9: {
                            PsiElement element$iv$iv;
                            PostgresObjectBuilder this_$iv2;
                            IElementType iElementType;
                            PsiElement it = tmp$iv$iv;
                            IElementType iElementType2 = this.getElementType(it);
                            if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_TRIGGER_TIME_CLAUSE)) {
                                PsiElement psiElement2 = it.getFirstChild();
                                IElementType iElementType3 = iElementType = psiElement2 != null ? this.getElementType(psiElement2) : null;
                                turn = Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INSTEAD) ? TrigTurn.INSTEAD_OF : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ALSO) ? TrigTurn.ALSO : null);
                                continue;
                            }
                            if (Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)) {
                                PsiElement psiElement3 = it.getLastChild();
                                IElementType iElementType4 = iElementType = psiElement3 != null ? this.getElementType(psiElement3) : null;
                                event = Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SELECT) ? TrigEvent.SELECT : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_DELETE) ? TrigEvent.DELETE : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UPDATE) ? TrigEvent.UPDATE : (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_INSERT) ? TrigEvent.INSERT : null)));
                                continue;
                            }
                            if (!Intrinsics.areEqual((Object)iElementType2, (Object)SqlCompositeElementTypes.SQL_WHERE_CLAUSE)) continue;
                            PostgresObjectBuilder postgresObjectBuilder2 = this_$iv2 = this;
                            for (PsiElement tmp$iv$iv2 = element$iv$iv = it.getFirstChild(); tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                                PsiElement it$iv = tmp$iv$iv2;
                                if (!(it$iv instanceof SqlExpression)) continue;
                                psiElement = tmp$iv$iv2;
                                break block9;
                            }
                            psiElement = null;
                        }
                        SqlExpression sqlExpression2 = sqlExpression = (SqlExpression)psiElement;
                        condition = sqlExpression2 != null ? sqlExpression2.getText() : null;
                    }
                }
                obj2.setTurn(turn);
                pgModRule = obj2;
                object = event;
                if (object == null) break block10;
                TrigEvent trigEvent = object;
                PgModRule pgModRule2 = pgModRule;
                TrigEvent it = trigEvent;
                Set set = SetsKt.setOf((Object)event);
                pgModRule = pgModRule2;
                object = set;
                if (object != null) break block11;
            }
            object = SetsKt.emptySet();
        }
        pgModRule.setEvents((Set<TrigEvent>)object);
        obj2.setCondition(condition);
        ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
            final /* synthetic */ PostgresObjectBuilder this$0;
            final /* synthetic */ PgModRule $obj;
            final /* synthetic */ DasObject $source;

            public final void run() {
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateStatement)) {
                    dasObject = null;
                }
                this.$obj.setSourceText((object = (SqlCreateStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null);
            }
            {
                this.this$0 = postgresObjectBuilder;
                this.$obj = pgModRule;
                this.$source = dasObject;
            }
        });
    }

    private final void buildForeignDataWrapper(PgModForeignDataWrapper obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            Reference handler = null;
            Reference validator = null;
            List<String> options = CollectionsKt.emptyList();
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_HANDLER)) {
                    handler = this.findFunctionReference(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VALIDATOR)) {
                    validator = this.findFunctionReference(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            Reference reference = handler;
            obj2.setHandler(reference != null ? reference.getName() : null);
            Reference reference2 = handler;
            obj2.setHandlerSchema(reference2 != null ? reference2.getQualifier() : null);
            Reference reference3 = validator;
            obj2.setValidator(reference3 != null ? reference3.getName() : null);
            Reference reference4 = validator;
            obj2.setValidatorSchema(reference4 != null ? reference4.getQualifier() : null);
            obj2.setOptions(options);
        }
    }

    private final void buildForeignServer(PgModForeignServer obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String type = null;
            List<String> options = CollectionsKt.emptyList();
            String version = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    PsiElement first;
                    if (it.getFirstChild() == null) {
                        continue;
                    }
                    IElementType iElementType2 = this.getElementType(first);
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_TYPE)) {
                        type = this.findString(first);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)PgTypes.PG_VERSION)) continue;
                    version = this.findString(first);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj2.setType(type);
            obj2.setOptions(options);
            obj2.setVersion(version);
        }
    }

    private final void buildUserMapping(PgModUserMapping obj2, DasObject source) {
        if (source instanceof SqlCreateStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            String user = null;
            List<String> options = CollectionsKt.emptyList();
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType iElementType = this.getElementType(it);
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_FOR)) {
                    user = this.findUser(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OPTIONS)) continue;
                options = this.findOptions(it);
            }
            obj2.setUser(user);
            obj2.setOptions(options);
        }
    }

    private final void buildSequence(PgModSequence obj2, DasObject source) {
        this.buildBasicElement(obj2, source);
        if (source instanceof SqlCreateSequenceStatementImpl) {
            PsiElement first$iv$iv;
            PostgresObjectBuilder this_$iv;
            obj2.setSequenceIdentity(this.buildSequenceIdentity((PsiElement)source));
            boolean cycle = false;
            boolean owned = false;
            long cacheSize = 1L;
            String dataType = null;
            PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
            for (PsiElement tmp$iv$iv = first$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement type;
                PsiElement it = tmp$iv$iv;
                if (!(it instanceof SqlClause)) continue;
                PsiElement psiElement = ((SqlClause)it).getFirstChild();
                if (psiElement == null || (psiElement = this.getElementType(psiElement)) == null) {
                    continue;
                }
                PsiElement psiElement2 = type = psiElement;
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CYCLE)) {
                    cycle = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_OWNED)) {
                    SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes.SQL_COLUMN_REFERENCE");
                    owned = this.findChild(it, (IElementType)sqlReferenceElementType) != null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_CACHE)) {
                    Long l = this.findNumber(it);
                    cacheSize = l != null ? l : 1L;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)psiElement2, (Object)PgTypes.PG_AS)) continue;
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_TYPE_ELEMENT;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_TYPE_ELEMENT");
                PsiElement psiElement3 = this.findChild(it, (IElementType)sqlCompositeElementType);
                if (!(psiElement3 instanceof SqlTypeElement)) {
                    psiElement3 = null;
                }
                SqlTypeElement sqlTypeElement = (SqlTypeElement)psiElement3;
                dataType = sqlTypeElement != null ? sqlTypeElement.getDisplayName() : null;
            }
            obj2.setCycled(cycle);
            obj2.setOwnedByColumn(owned);
            obj2.setCacheSize(cacheSize);
            obj2.setDataType(dataType);
        }
    }

    @Override
    protected void buildTypedType(@NotNull BasicModTypedElement obj2, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!(obj2 instanceof PgModLocalTableColumn)) {
            super.buildTypedType(obj2, source);
            return;
        }
        DataType type = this.extractType(source);
        boolean serial = false;
        if (StringsKt.equals((String)type.typeName, (String)"bigserial", (boolean)true) || StringsKt.equals((String)type.typeName, (String)"serial8", (boolean)true)) {
            DataType dataType = DataTypeFactory.of("bigint");
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(\"bigint\")");
            type = dataType;
            serial = true;
        } else if (StringsKt.equals((String)type.typeName, (String)"serial", (boolean)true) || StringsKt.equals((String)type.typeName, (String)"serial4", (boolean)true)) {
            DataType dataType = DataTypeFactory.of("int");
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(\"int\")");
            type = dataType;
            serial = true;
        } else if (StringsKt.equals((String)type.typeName, (String)"smallserial", (boolean)true) || StringsKt.equals((String)type.typeName, (String)"serial2", (boolean)true)) {
            DataType dataType = DataTypeFactory.of("smallint");
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(\"smallint\")");
            type = dataType;
            serial = true;
        }
        ((PgModLocalTableColumn)obj2).setDataType(type);
        ((PgModLocalTableColumn)obj2).setBelongingSequenceName(serial ? "unknown" : null);
    }

    private final void buildRoutine(PgModRoutine obj2, DasObject source) {
        super.buildRoutine(obj2, source);
        if (source instanceof SqlCreateProcedureStatement) {
            PsiElement psiElement;
            Object tmp$iv$iv;
            PostgresObjectBuilder this_$iv;
            String language;
            float rows;
            float cost;
            boolean isSecurityDefiner;
            boolean isStrict;
            boolean isWindow;
            boolean isLeakproof;
            PgRoutineConcurrencyKind concurrencyKind;
            ArrayList<String> assignments;
            block15: {
                PsiElement element$iv$iv;
                assignments = new ArrayList<String>();
                concurrencyKind = PgRoutineConcurrencyKind.UNSAFE;
                isLeakproof = false;
                isWindow = false;
                isStrict = false;
                isSecurityDefiner = false;
                cost = 0.0f;
                rows = 0.0f;
                language = null;
                PostgresObjectBuilder postgresObjectBuilder = this_$iv = this;
                for (tmp$iv$iv = element$iv$iv = ((PsiElement)source).getFirstChild(); tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it = tmp$iv$iv;
                    if (!Intrinsics.areEqual((Object)this.getElementType(it), (Object)PostgresElementTypes.Misc.PG_LAZY_CODE_BLOCK_PARENT)) continue;
                    psiElement = tmp$iv$iv;
                    break block15;
                }
                psiElement = null;
            }
            if (psiElement != null) {
                PsiElement first$iv$iv;
                PostgresObjectBuilder createChild = this_$iv = psiElement;
                PostgresObjectBuilder this_$iv2 = this;
                tmp$iv$iv = this_$iv2;
                PostgresObjectBuilder postgresObjectBuilder = createChild;
                for (PsiElement tmp$iv$iv2 = first$iv$iv = (v834011) != null ? (v834011).getFirstChild() : null; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                    IElementType iElementType;
                    PsiElement s;
                    PsiElement it = tmp$iv$iv2;
                    PsiElement psiElement2 = s = it.getFirstChild();
                    IElementType iElementType2 = iElementType = psiElement2 != null ? this.getElementType(psiElement2) : null;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SET)) {
                        PostgresObjectBuilder this_$iv3 = this;
                        for (PsiElement tmp$iv = s; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                            PsiElement it2 = tmp$iv;
                            if (!Intrinsics.areEqual((Object)this.getElementType(it2), (Object)PgTypes.PG_SET_ASSIGNMENT)) continue;
                            assignments.add(it2.getText());
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PARALLEL)) {
                        PsiElement psiElement3 = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"s");
                        concurrencyKind = this.findConcurrencyKind(psiElement3);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_NOT)) {
                        isLeakproof = false;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LEAKPROOF)) {
                        isLeakproof = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_WINDOW)) {
                        isWindow = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STRICT)) {
                        isStrict = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SECURITY) || Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_EXTERNAL)) {
                        IElementType iElementType3 = PgTypes.PG_DEFINER;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType3, (String)"PG_DEFINER");
                        isSecurityDefiner = this.findSibling(s, iElementType3) != null;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_COST)) {
                        Float f = this.findNumberInSiblings(s);
                        cost = f != null ? f.floatValue() : 0.0f;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_ROWS)) {
                        Float f = this.findNumberInSiblings(s);
                        rows = f != null ? f.floatValue() : 0.0f;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_LANGUAGE)) continue;
                    PsiElement psiElement4 = it.getLastChild();
                    language = psiElement4 != null ? this.extractName(psiElement4) : null;
                }
            }
            obj2.setConfigurationParameters((List<String>)assignments);
            obj2.setConcurrencyKind(concurrencyKind);
            obj2.setLeakproof(isLeakproof);
            obj2.setWindow(isWindow);
            obj2.setStrict(isStrict);
            obj2.setSecurityDefiner(isSecurityDefiner);
            obj2.setCost(cost);
            obj2.setRows(rows);
            obj2.setLanguageName(language);
            boolean isProcedure = !(source instanceof SqlCreateFunctionStatementImpl);
            obj2.setRoutineKind(isProcedure ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
            if (!isProcedure) {
                return;
            }
            BasicModArgument basicModArgument = obj2.createOrGetReturnArgument();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModArgument, (String)"obj.createOrGetReturnArgument()");
            BasicModArgument returnArgument2 = basicModArgument;
            boolean hasOutParameters2 = obj2.getArguments().has(buildRoutine.hasOutParameters.1.INSTANCE);
            returnArgument2.setDataType(DataTypeFactory.of(hasOutParameters2 ? "record" : "void"));
        }
    }

    private final SequenceIdentity buildSequenceIdentity(PsiElement source) {
        Long startVal;
        Long maxVal;
        Long minVal;
        PsiElement first$iv$iv;
        Long l;
        Long[] longArray;
        Object object = longArray = new Long[4];
        Long l2 = l = object[0];
        object = longArray;
        Long l3 = l = object[1];
        object = longArray;
        Long l4 = l = object[2];
        object = longArray;
        Long incVal = l = object[3];
        PostgresObjectBuilder this_$iv = this;
        object = this_$iv;
        PsiElement psiElement = source;
        for (PsiElement tmp$iv$iv = first$iv$iv = (v834198) != null ? (v834198).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            PsiElement type;
            PsiElement it = tmp$iv$iv;
            if (!(it instanceof SqlClause)) continue;
            PsiElement psiElement2 = ((SqlClause)it).getFirstChild();
            if (psiElement2 == null || (psiElement2 = this.getElementType(psiElement2)) == null) {
                continue;
            }
            PsiElement psiElement3 = type = psiElement2;
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MINVALUE)) {
                minVal = this.findNumber(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_MAXVALUE)) {
                maxVal = this.findNumber(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_START)) {
                startVal = this.findNumber(it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)psiElement3, (Object)PgTypes.PG_INCREMENT)) continue;
            incVal = this.findNumber(it);
        }
        SequenceIdentity sequenceIdentity = SequenceIdentity.of(minVal, startVal, incVal, maxVal);
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity, (String)"SequenceIdentity.of(minV\u2026startVal, incVal, maxVal)");
        return sequenceIdentity;
    }

    private final PgRoutineConcurrencyKind findConcurrencyKind(PsiElement element2) {
        PostgresObjectBuilder this_$iv = this;
        for (PsiElement tmp$iv = element2; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_SAFE)) {
                return PgRoutineConcurrencyKind.SAFE;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_RESTRICTED)) {
                return PgRoutineConcurrencyKind.RESTRICTED;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_UNSAFE)) continue;
            return PgRoutineConcurrencyKind.UNSAFE;
        }
        return PgRoutineConcurrencyKind.UNSAFE;
    }

    private final List<String> findOptions(PsiElement source) {
        return this.findOptions(source, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>(this){
            final /* synthetic */ PostgresObjectBuilder this$0;

            @Nullable
            public final PsiElement invoke(@NotNull PsiElement current) {
                PsiElement psiElement;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                    PostgresObjectBuilder this_$iv = this.this$0;
                    for (PsiElement tmp$iv = current; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                        PsiElement it = tmp$iv;
                        if (!(Intrinsics.areEqual((Object)it, (Object)current) ^ true && Intrinsics.areEqual((Object)PostgresObjectBuilder.access$getElementType$p(this.this$0, it), (Object)SqlElementTypes.SQL_STRING_LITERAL) ^ true && Intrinsics.areEqual((Object)PostgresObjectBuilder.access$getElementType$p(this.this$0, it), (Object)SqlElementTypes.WHITE_SPACE) ^ true)) continue;
                        psiElement = tmp$iv;
                        break block1;
                    }
                    psiElement = null;
                }
                return psiElement;
            }
            {
                this.this$0 = postgresObjectBuilder;
                super(1);
            }
        }), (Function1<? super String, String>)((Function1)findOptions.2.INSTANCE));
    }

    private final Long findNumber(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toLongOrNull((String)object) : null;
    }

    private final Reference findFunctionReference(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_FUNCTION_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_FUNCTION_REFERENCE");
        return this.findReference(source, sqlReferenceElementType);
    }

    private final Reference findReference(PsiElement source, SqlReferenceElementType type) {
        PsiElement psiElement = this.findSibling(source, (IElementType)type);
        if (!(psiElement instanceof SqlReferenceExpression)) {
            psiElement = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression reference = sqlReferenceExpression;
        return this.asReferenceData(reference);
    }

    private final Reference asReferenceData(@Nullable SqlReferenceExpression $receiver) {
        if ($receiver == null) {
            return null;
        }
        Object object = $receiver.getIdentifier();
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"identifier?.name ?: return null");
        Object name = object;
        SqlExpression sqlExpression = $receiver.getQualifierExpression();
        String qualifier = sqlExpression != null ? sqlExpression.getName() : null;
        Object[] objectArray = new String[2];
        SqlExpression sqlExpression2 = $receiver.getQualifierExpression();
        objectArray[0] = sqlExpression2 != null ? sqlExpression2.getText() : null;
        SqlIdentifier sqlIdentifier = $receiver.getIdentifier();
        objectArray[1] = sqlIdentifier != null ? sqlIdentifier.getText() : null;
        String fullText = CollectionsKt.joinToString$default((Iterable)ArraysKt.filterNotNull((Object[])objectArray), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return new Reference(qualifier, (String)name, fullText);
    }

    private final String findUser(PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
        PsiElement userReference = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (userReference instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)userReference).getName();
        }
        PostgresObjectBuilder this_$iv = this;
        for (PsiElement tmp$iv = source; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
            PsiElement it = tmp$iv;
            ASTNode aSTNode = it.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            IElementType iElementType = aSTNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_USER_REFERENCE)) {
                if (!(userReference instanceof SqlReferenceExpression)) continue;
                return ((SqlReferenceExpression)userReference).getName();
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_USER)) {
                return "user";
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_CURRENT_USER)) {
                return "current_user";
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_PUBLIC)) continue;
            return "public";
        }
        return null;
    }

    public PostgresObjectBuilder() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026p<PgModTrigger, String>()");
        this.triggerRoutines = concurrentMap;
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findSibling(PostgresObjectBuilder $this, @Nullable PsiElement element2, @NotNull Function1 action) {
        return $this.findSibling(element2, (Function1<? super PsiElement, Boolean>)action);
    }

    @Nullable
    public static final /* synthetic */ IElementType access$getElementType$p(PostgresObjectBuilder $this, @NotNull PsiElement $receiver) {
        return $this.getElementType($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/postgres/PostgresObjectBuilder$Reference;", "", "qualifier", "", "name", "fullName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFullName", "()Ljava/lang/String;", "getName", "getQualifier", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.dialects"})
    private static final class Reference {
        @Nullable
        private final String qualifier;
        @NotNull
        private final String name;
        @NotNull
        private final String fullName;

        @Nullable
        public final String getQualifier() {
            return this.qualifier;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public Reference(@Nullable String qualifier, @NotNull String name, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            this.qualifier = qualifier;
            this.name = name;
            this.fullName = fullName;
        }

        @Nullable
        public final String component1() {
            return this.qualifier;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.fullName;
        }

        @NotNull
        public final Reference copy(@Nullable String qualifier, @NotNull String name, @NotNull String fullName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
            return new Reference(qualifier, name, fullName);
        }

        @NotNull
        public static /* synthetic */ Reference copy$default(Reference reference, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reference.qualifier;
            }
            if ((n & 2) != 0) {
                string2 = reference.name;
            }
            if ((n & 4) != 0) {
                string3 = reference.fullName;
            }
            return reference.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Reference(qualifier=" + this.qualifier + ", name=" + this.name + ", fullName=" + this.fullName + ")";
        }

        public int hashCode() {
            String string = this.qualifier;
            String string2 = this.name;
            String string3 = this.fullName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Reference)) break block3;
                    Reference reference = (Reference)object;
                    if (!Intrinsics.areEqual((Object)this.qualifier, (Object)reference.qualifier) || !Intrinsics.areEqual((Object)this.name, (Object)reference.name) || !Intrinsics.areEqual((Object)this.fullName, (Object)reference.fullName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

