/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeColumnListBase;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeForeignKey
extends DeColumnListBase
implements DasForeignKey {
    @Nullable
    public DeTable target;
    @NotNull
    public final List<Ref> refs;
    public DasForeignKey.RuleAction updateRule;
    public DasForeignKey.RuleAction deleteRule;
    public DasForeignKey.Deferrability deferrability;

    protected DeForeignKey(@NotNull DeModel model) {
        if (model == null) {
            DeForeignKey.$$$reportNull$$$0(0);
        }
        super(model);
        this.refs = ContainerUtil.newArrayList();
        this.updateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    public DeForeignKey(@NotNull String name, @NotNull DeTable table, @NotNull DeModel model) {
        if (name == null) {
            DeForeignKey.$$$reportNull$$$0(1);
        }
        if (table == null) {
            DeForeignKey.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DeForeignKey.$$$reportNull$$$0(3);
        }
        super(name, table, model);
        this.refs = ContainerUtil.newArrayList();
        this.updateRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deleteRule = DasForeignKey.RuleAction.NO_ACTION;
        this.deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj2, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj2 == null) {
            DeForeignKey.$$$reportNull$$$0(4);
        }
        if (copier == null) {
            DeForeignKey.$$$reportNull$$$0(5);
        }
        super.copyFrom(obj2, withChildren, copier);
        DeForeignKey fk = (DeForeignKey)obj2;
        this.target = copier.copy(fk.target, true);
        this.refs.clear();
        for (Ref ref : fk.refs) {
            DeColumn reference = copier.copy(ref.ref, false);
            DeColumn target = copier.copy(ref.target, false);
            this.refs.add(new Ref(reference, target));
        }
        this.updateRule = fk.updateRule;
        this.deleteRule = fk.deleteRule;
        this.deferrability = fk.deferrability;
        DeForeignKey deForeignKey = this;
        if (deForeignKey == null) {
            DeForeignKey.$$$reportNull$$$0(6);
        }
        return deForeignKey;
    }

    @Override
    @NotNull
    public Iterable<DeColumn> getColumns() {
        JBIterable jBIterable = JBIterable.from(this.refs).transform(ref -> ref.ref);
        if (jBIterable == null) {
            DeForeignKey.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<DeColumn> getTargetColumns() {
        JBIterable jBIterable = JBIterable.from(this.refs).transform(ref -> ref.target);
        if (jBIterable == null) {
            DeForeignKey.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            DeForeignKey.$$$reportNull$$$0(9);
        }
        DeForeignKey deForeignKey = new DeForeignKey(model);
        if (deForeignKey == null) {
            DeForeignKey.$$$reportNull$$$0(10);
        }
        return deForeignKey;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            DeForeignKey.$$$reportNull$$$0(11);
        }
        if (children2 == null) {
            DeForeignKey.$$$reportNull$$$0(12);
        }
        if (otherChildren == null) {
            DeForeignKey.$$$reportNull$$$0(13);
        }
        DeForeignKey otherFk = (DeForeignKey)other;
        return this.updateRule != otherFk.updateRule || this.deleteRule != otherFk.deleteRule || this.deferrability != otherFk.deferrability || DeForeignKey.isObjectIdentityAltered(this.target, otherFk.target) || DeForeignKey.isObjectsIdentityAltered(this.getTargetColumns(), otherFk.getTargetColumns()) || super.isAlteredIgnoringChild(other, children2, otherChildren);
    }

    public String getRefTableName() {
        return this.target == null ? null : this.target.name;
    }

    public String getRefTableSchema() {
        DasObject schema = DasUtil.getParentOfKind((DasObject)this.target, (ObjectKind)ObjectKind.SCHEMA, (boolean)true);
        return schema == null ? null : schema.getName();
    }

    public String getRefTableCatalog() {
        return null;
    }

    @Nullable
    public DasTable getRefTable() {
        return this.target;
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getRefColumns() {
        MultiRef multiRef = DasUtil.asRef(this.getTargetColumns());
        if (multiRef == null) {
            DeForeignKey.$$$reportNull$$$0(14);
        }
        return multiRef;
    }

    public DasForeignKey.RuleAction getDeleteRule() {
        return this.deleteRule;
    }

    public DasForeignKey.RuleAction getUpdateRule() {
        return this.updateRule;
    }

    public DasForeignKey.Deferrability getDeferrability() {
        return this.deferrability;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            DeForeignKey.$$$reportNull$$$0(15);
        }
        return objectKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeForeignKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeForeignKey";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetColumns";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyClone";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefColumns";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Ref {
        public final DeColumn ref;
        public final DeColumn target;

        public Ref(DeColumn ref, DeColumn target) {
            this.ref = ref;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ref ref1 = (Ref)o;
            if (this.ref != null ? !this.ref.equals(ref1.ref) : ref1.ref != null) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(ref1.target) : ref1.target != null);
        }

        public int hashCode() {
            int result2 = this.ref != null ? this.ref.hashCode() : 0;
            result2 = 31 * result2 + (this.target != null ? this.target.hashCode() : 0);
            return result2;
        }
    }
}

