/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIndexPatternBuilder
implements IndexPatternBuilder {
    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        SqlLanguageDialect language;
        if (file == null) {
            SqlIndexPatternBuilder.$$$reportNull$$$0(0);
        }
        SyntaxHighlighter highlighter = (language = (SqlLanguageDialect)ObjectUtils.tryCast((Object)file.getLanguage(), SqlLanguageDialect.class)) == null ? null : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)file.getProject(), (VirtualFile)file.getVirtualFile());
        return highlighter == null ? null : highlighter.getHighlightingLexer();
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            SqlIndexPatternBuilder.$$$reportNull$$$0(1);
        }
        return SqlTokens.COMMENT_TOKENS;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        if (tokenType == SqlTokens.ORAP_LINE_COMMENT) {
            return 3;
        }
        if (tokenType == SqlTokens.SQL_BLOCK_COMMENT || tokenType == SqlTokens.SQL_LINE_COMMENT) {
            return 2;
        }
        return tokenType == SqlTokens.MYSQL_LINE_COMMENT ? 1 : 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == SqlTokens.SQL_BLOCK_COMMENT ? 2 : 0;
    }

    @NotNull
    public String getCharsAllowedInContinuationPrefix(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            SqlIndexPatternBuilder.$$$reportNull$$$0(2);
        }
        String string = tokenType == SqlTokens.SQL_BLOCK_COMMENT ? "*" : "";
        if (string == null) {
            SqlIndexPatternBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlIndexPatternBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlIndexPatternBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsAllowedInContinuationPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCommentTokenSet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCharsAllowedInContinuationPrefix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

