/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowTraverser;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.psi.SqlElementTypes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u00020\u001e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0%H\u0004J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0010H\u0016J\b\u0010(\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020\u001eH\u0014J\u0012\u0010+\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010,H\u0004J+\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\b0J#\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u000202H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "()V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "grown", "", "minLength", "", "getMinLength", "()I", "setMinLength", "(I)V", "nestedNodes", "", "Lcom/intellij/lang/ASTNode;", "getNestedNodes", "()Ljava/util/List;", "setNestedNodes", "(Ljava/util/List;)V", "<set-?>", "Lcom/intellij/openapi/util/TextRange;", "range", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "setRange", "(Lcom/intellij/openapi/util/TextRange;)V", "adjustNestedNodes", "", "adjustProducedNestedBlocks", "contains", "char", "", "flattenNestedNodes", "whetherToFlatten", "Lkotlin/Function1;", "getSubBlocks", "Lcom/intellij/sql/formatter/model/SqlBlock;", "grow", "isLeaf", "produceNestedBlocks", "produceNestedBlocksInRange", "Lkotlin/ranges/IntRange;", "setup", "parent", "nodes", "setup$intellij_database_sql_impl", "toString", "", "intellij.database.sql.impl"})
public abstract class SqlRangeBlock
extends SqlFlowBlock {
    @NotNull
    private TextRange range;
    @NotNull
    protected List<? extends ASTNode> nestedNodes;
    private int minLength;
    private boolean grown;

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public final TextRange getRange() {
        TextRange textRange = this.range;
        if (textRange == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"range");
        }
        return textRange;
    }

    private final void setRange(TextRange textRange) {
        this.range = textRange;
    }

    @NotNull
    protected final List<ASTNode> getNestedNodes() {
        List<ASTNode> list = this.nestedNodes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        return list;
    }

    protected final void setNestedNodes(@NotNull List<? extends ASTNode> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.nestedNodes = list;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(int n) {
        this.minLength = n;
    }

    public final void setup$intellij_database_sql_impl(@NotNull SqlBlock parent2, @NotNull List<? extends ASTNode> nodes2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        Collection collection = nodes2;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        TextRange textRange = ((ASTNode)CollectionsKt.first(nodes2)).getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"nodes.first().textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = ((ASTNode)CollectionsKt.last(nodes2)).getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"nodes.last().textRange");
        TextRange range = new TextRange(n, textRange2.getEndOffset());
        this.setup$intellij_database_sql_impl(parent2, range, nodes2);
    }

    public final void setup$intellij_database_sql_impl(@NotNull SqlBlock parent2, @NotNull TextRange range, @NotNull List<? extends ASTNode> nodes2) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        super.setup$intellij_database_sql_impl(parent2);
        this.range = range;
        this.nestedNodes = nodes2;
        this.adjustNestedNodes();
    }

    protected void adjustNestedNodes() {
    }

    protected final void flattenNestedNodes(@NotNull Function1<? super ASTNode, Boolean> whetherToFlatten) {
        Intrinsics.checkParameterIsNotNull(whetherToFlatten, (String)"whetherToFlatten");
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.astTraverser();
        List<? extends ASTNode> list = this.nestedNodes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        List list2 = ((SyntaxTraverser)((SyntaxTraverser)syntaxTraverser.withRoots((Iterable)list)).expandAndSkip((Condition)new Condition<ASTNode>(whetherToFlatten){
            final /* synthetic */ Function1 $whetherToFlatten;

            public final boolean value(ASTNode it) {
                ASTNode aSTNode = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
                return (Boolean)this.$whetherToFlatten.invoke((Object)aSTNode) != false || it.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK;
            }
            {
                this.$whetherToFlatten = function1;
            }
        })).traverse().filter((Condition)flattenNestedNodes.2.INSTANCE).toList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"SyntaxTraverser.astTrave\u2026ace() }\n        .toList()");
        this.nestedNodes = list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grow() {
        if (this.grown) {
            return;
        }
        try {
            this.produceNestedBlocks();
            this.adjustProducedNestedBlocks();
        }
        finally {
            this.grown = true;
        }
    }

    protected void produceNestedBlocks() {
        this.produceNestedBlocksInRange(null);
    }

    protected final void produceNestedBlocksInRange(@Nullable IntRange range) {
        Map<IElementType, FlowPattern> patterns2;
        List<? extends ASTNode> nodesToProcess;
        List<? extends ASTNode> list;
        if (range == null) {
            list = this.nestedNodes;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
            }
        } else {
            List<? extends ASTNode> list2 = this.nestedNodes;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
            }
            list = nodesToProcess = list2.subList(range.getFirst(), range.getLast() + 1);
        }
        if ((patterns2 = this.flowPatterns()) != null) {
            FlowTraverser flowTraverser = new FlowTraverser(this, nodesToProcess, patterns2);
            flowTraverser.processAll();
        } else {
            for (ASTNode aSTNode : nodesToProcess) {
                SqlBlock block = this.makeBlock(aSTNode);
                if (block.getRole() == BlockRole.NOTHING) {
                    block.setRole(this.determineRole$intellij_database_sql_impl(aSTNode));
                }
                this.addNestedBlock$intellij_database_sql_impl(block);
            }
        }
    }

    protected void adjustProducedNestedBlocks() {
    }

    @Override
    public boolean contains(char c2) {
        SqlFormattingContext sqlFormattingContext = this.getContext();
        TextRange textRange = this.range;
        if (textRange == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"range");
        }
        return sqlFormattingContext.textContains(textRange, c2);
    }

    @Override
    @NotNull
    public List<SqlBlock> getSubBlocks() {
        this.grow();
        return this.getNestedBlocks();
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        List<? extends ASTNode> list = this.nestedNodes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        if (list.isEmpty()) {
            return super.toString();
        }
        List<? extends ASTNode> list2 = this.nestedNodes;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        ASTNode aSTNode = SqlUtilFun.firstLeaf((ASTNode)CollectionsKt.first(list2));
        List<? extends ASTNode> list3 = this.nestedNodes;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nestedNodes");
        }
        String str = SqlBlockKt.access$rangeRepresentation(aSTNode, SqlUtilFun.lastLeaf((ASTNode)CollectionsKt.last(list3)));
        return super.toString() + ": " + str;
    }

    public SqlRangeBlock() {
        super(null);
    }
}

