/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import b.h.la;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private static final long a = la.a(5220803620514850984L, 7100736873066311931L, MethodHandles.lookup().lookupClass()).a(247252374267235L);

    private JsonUtil() {
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String content) {
        return JsonUtil.tryParseJsonObject(content, true);
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String content, boolean lenient) {
        try {
            return JsonUtil.parseJsonObject(content, lenient);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static JsonObject parseJsonObject(@Nullable String content) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        JsonObject jsonObject = JsonUtil.parseJsonObject(content, true);
        if (jsonObject == null) {
            JsonUtil.a(0);
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsonObject parseJsonObject(@Nullable String content, boolean lenient) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)content)));
        jsonReader.setLenient(lenient);
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            JsonUtil.a(1);
        }
        return jsonObject2;
        finally {
            try {
                jsonReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsonArray parseJsonArray(@Nullable String content) throws JsonParseException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)content)));
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        JsonArray jsonArray2 = jsonArray;
        if (jsonArray2 == null) {
            JsonUtil.a(2);
        }
        return jsonArray2;
        finally {
            try {
                jsonReader.close();
            }
            catch (Exception exception) {}
        }
    }

    @NotNull
    public static List<Object> nextList(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.a(3);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.a(4);
            }
            return list2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        while (reader.hasNext()) {
            arrayList.add(JsonUtil.nextAny(reader));
        }
        reader.endArray();
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JsonUtil.a(5);
        }
        return arrayList2;
    }

    @NotNull
    public static List<String> nextStringList(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.a(6);
        }
        reader.beginArray();
        if (!reader.hasNext()) {
            reader.endArray();
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.a(7);
            }
            return list2;
        }
        ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)2);
        while (reader.hasNext()) {
            String string = JsonUtil.nextStringOrSkip(reader);
            if (string == null) continue;
            arrayList.add(string);
        }
        reader.endArray();
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            JsonUtil.a(8);
        }
        return arrayList2;
    }

    @NotNull
    public static Map<String, Object> nextMap(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.a(9);
        }
        reader.beginObject();
        if (!reader.hasNext()) {
            reader.endObject();
            Map<String, Object> map = Collections.emptyMap();
            if (map == null) {
                JsonUtil.a(10);
            }
            return map;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        while (reader.hasNext()) {
            hashMap.put(reader.nextName(), JsonUtil.nextAny(reader));
        }
        reader.endObject();
        HashMap<String, Object> hashMap2 = hashMap;
        if (hashMap2 == null) {
            JsonUtil.a(11);
        }
        return hashMap2;
    }

    @Nullable
    public static String nextStringOrSkip(@NotNull JsonReader reader) throws IOException {
        JsonToken jsonToken;
        if (reader == null) {
            JsonUtil.a(12);
        }
        if ((jsonToken = reader.peek()) == JsonToken.STRING) {
            return reader.nextString();
        }
        reader.skipValue();
        return null;
    }

    @Nullable
    public static Object nextAny(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            JsonUtil.a(13);
        }
        switch (reader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(reader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextMap(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case NUMBER: {
                return reader.nextDouble();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Deprecated
    @Nullable
    public static String getString(@NotNull JsonObject object, @NotNull String key) {
        if (object == null) {
            JsonUtil.a(14);
        }
        if (key == null) {
            JsonUtil.a(15);
        }
        return JsonUtil.getChildAsString(object, key);
    }

    @Nullable
    public static String getChildAsString(@Nullable JsonObject object, @NotNull String key) {
        if (key == null) {
            JsonUtil.a(16);
        }
        JsonElement jsonElement = object != null ? object.get(key) : null;
        return JsonUtil.getString(jsonElement);
    }

    @Nullable
    public static JsonArray getChildAsArray(@Nullable JsonObject object, @NotNull String memberName) {
        JsonElement jsonElement;
        if (memberName == null) {
            JsonUtil.a(17);
        }
        JsonElement jsonElement2 = jsonElement = object != null ? object.get(memberName) : null;
        if (jsonElement != null && jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsStringList(@Nullable JsonObject object, @NotNull String memberName) {
        if (memberName == null) {
            JsonUtil.a(18);
        }
        JsonElement jsonElement = object != null ? object.get(memberName) : null;
        return JsonUtil.getAsStringList(jsonElement);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static List<String> getAsStringList(@Nullable JsonElement element) {
        if (element != null && element.isJsonArray()) {
            return ContainerUtil.mapNotNull((Iterable)element.getAsJsonArray(), JsonUtil::getString);
        }
        return null;
    }

    @Nullable
    public static JsonObject getChildAsObject(@Nullable JsonObject object, @NotNull String memberName) {
        if (memberName == null) {
            JsonUtil.a(19);
        }
        return JsonUtil.getAsObject(object != null ? object.get(memberName) : null);
    }

    @Nullable
    public static JsonObject getAsObject(@Nullable JsonElement value) {
        return value != null && value.isJsonObject() ? value.getAsJsonObject() : null;
    }

    @Nullable
    public static JsonElement findChild(@Nullable JsonObject object, String ... names) {
        if (object == null) {
            return null;
        }
        for (String string : names) {
            JsonElement jsonElement = object.get(string);
            if (jsonElement == null) continue;
            return jsonElement;
        }
        return null;
    }

    @NotNull
    public static List<String> keys(@NotNull JsonObject jsonObject) {
        if (jsonObject == null) {
            JsonUtil.a(20);
        }
        List list2 = ContainerUtil.map((Collection)jsonObject.entrySet(), entry -> (String)entry.getKey());
        if (list2 == null) {
            JsonUtil.a(21);
        }
        return list2;
    }

    @Nullable
    public static Boolean getChildAsBooleanObj(@Nullable JsonObject object, @NotNull String memberName) {
        JsonPrimitive jsonPrimitive;
        JsonElement jsonElement;
        if (memberName == null) {
            JsonUtil.a(22);
        }
        JsonElement jsonElement2 = jsonElement = object != null ? object.get(memberName) : null;
        if (jsonElement != null && jsonElement.isJsonPrimitive() && (jsonPrimitive = jsonElement.getAsJsonPrimitive()).isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        return null;
    }

    public static boolean getChildAsBoolean(@Nullable JsonObject object, @NotNull String memberName, boolean defaultValue) {
        if (memberName == null) {
            JsonUtil.a(23);
        }
        return (Boolean)ObjectUtils.notNull((Object)JsonUtil.getChildAsBooleanObj(object, memberName), (Object)defaultValue);
    }

    @Nullable
    public static String getString(@Nullable JsonElement element) {
        JsonPrimitive jsonPrimitive;
        if (element != null && element.isJsonPrimitive() && (jsonPrimitive = element.getAsJsonPrimitive()).isString()) {
            return jsonPrimitive.getAsString();
        }
        return null;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader reader, @NotNull String memberName) throws IOException {
        if (reader == null) {
            JsonUtil.a(24);
        }
        if (memberName == null) {
            JsonUtil.a(25);
        }
        return JsonUtil.getChildAsString(reader, memberName, null);
    }

    @NotNull
    public static Map<String, String> getTopLevelStringValues(@NotNull JsonReader reader, @NotNull Set<String> names) throws IOException {
        JsonToken jsonToken;
        if (reader == null) {
            JsonUtil.a(26);
        }
        if (names == null) {
            JsonUtil.a(27);
        }
        if ((jsonToken = reader.peek()) != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                JsonUtil.a(28);
            }
            return map;
        }
        reader.beginObject();
        HashMap<String, String> hashMap = new HashMap<String, String>(names.size(), 1.0f);
        while (reader.hasNext()) {
            String string = reader.nextName();
            if (names.contains(string)) {
                String string2 = JsonUtil.nextStringOrSkip(reader);
                if (string2 == null) continue;
                hashMap.put(string, string2);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            JsonUtil.a(29);
        }
        return hashMap2;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader reader, @NotNull String memberName, @Nullable String failoverMemberName) throws IOException {
        if (reader == null) {
            JsonUtil.a(30);
        }
        if (memberName == null) {
            JsonUtil.a(31);
        }
        Set set = failoverMemberName == null ? Collections.singleton(memberName) : ContainerUtil.set((Object[])new String[]{memberName, failoverMemberName});
        Map<String, String> map = JsonUtil.getTopLevelStringValues(reader, set);
        String string = map.get(memberName);
        return string != null ? string : map.get(failoverMemberName);
    }

    public static int getChildAsInteger(@Nullable JsonObject object, @NotNull String key, int defaultValue) {
        Integer n2;
        if (key == null) {
            JsonUtil.a(32);
        }
        return (n2 = JsonUtil.getChildAsIntegerObj(object, key)) != null ? n2 : defaultValue;
    }

    @Nullable
    public static Integer getChildAsIntegerObj(@Nullable JsonObject object, @NotNull String key) {
        JsonElement jsonElement;
        if (key == null) {
            JsonUtil.a(33);
        }
        JsonElement jsonElement2 = jsonElement = object != null ? object.get(key) : null;
        if (jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isNumber()) {
            return jsonElement.getAsInt();
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x11F017C4208BL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/util/JsonUtil";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 15: 
            case 16: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsonObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsonArray";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/util/JsonUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "nextList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextStringList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nextMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStringValues";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nextStringList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nextMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nextStringOrSkip";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "nextAny";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 16: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsArray";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsStringList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsObject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "keys";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsBooleanObj";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsBoolean";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelStringValues";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsInteger";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsIntegerObj";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

