/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import b.h.la;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;

public class GemDependency
implements Comparable {
    private static final String m;
    @NonNls
    public static final String DEPENDENCY = "dependency";
    @NonNls
    public static final String NAME = "name";
    @NonNls
    public static final String VERSION = "version";
    @NonNls
    public static final String URL = "url";
    @NonNls
    public static final String LIB = "lib";
    @NonNls
    public static final String PLATFORM = "platform";
    @NonNls
    public static final String GIT = "git";
    @NonNls
    public static final String FROM_PATH = "path";
    @NonNls
    public static final String REF = "ref";
    @NonNls
    public static final String BOUND = "bound";
    @NonNls
    public static final String DO_REQUIRE = "doRequire";
    public static final String VERSION_PATTERN = "([0-9]+(\\.[0-9A-z]+)*)";
    @NonNls
    private static final Pattern i;
    @NonNls
    private static final Pattern b;
    @NonNls
    private static final Pattern e;
    private final String k;
    private final List<Pair<Bound, String>> f;
    private final String g;
    @Nullable
    private final String d;
    private final boolean c;
    private final boolean j;
    @Nullable
    private final String[] a;
    private final boolean l;
    private final String h;
    private static final long n;

    public Element getState() {
        long l2 = n ^ 0x6C3DA7EBDBE5L;
        Element element = new Element(DEPENDENCY);
        element.setAttribute(NAME, this.k);
        for (Pair<Bound, String> pair : this.f) {
            Element element2 = new Element(BOUND);
            element2.setAttribute(VERSION, (String)pair.second);
            element2.setAttribute(BOUND, ((Bound)((Object)pair.first)).name());
            element.addContent(element2);
        }
        if (this.g != null) {
            element.setAttribute(URL, this.g);
        }
        if (this.d != null) {
            element.setAttribute(LIB, this.d);
        }
        element.setAttribute(GIT, Boolean.toString(this.c));
        element.setAttribute(FROM_PATH, Boolean.toString(this.j));
        if (this.h != null) {
            element.setAttribute(REF, this.h);
        }
        if (this.a != null) {
            element.setAttribute(PLATFORM, this.a());
        }
        element.setAttribute(DO_REQUIRE, Boolean.toString(this.l));
        return element;
    }

    private String a() {
        assert (this.a != null);
        return StringUtil.join((String[])this.a, (String)",");
    }

    public static GemDependency create(Element element) {
        Object object;
        Object object2;
        Object object32;
        long l2 = n ^ 0x146EF4073906L;
        String string = element.getAttributeValue(NAME);
        ArrayList<Pair<Bound, String>> arrayList = new ArrayList<Pair<Bound, String>>();
        for (Object object32 : element.getChildren(BOUND)) {
            object2 = (Element)object32;
            String string2 = object2.getAttributeValue(VERSION);
            object = Bound.valueOf(object2.getAttributeValue(BOUND));
            assert (object != null);
            arrayList.add(Pair.create((Object)object, (Object)string2));
        }
        String string3 = element.getAttributeValue(URL);
        object32 = element.getAttributeValue(LIB);
        object2 = element.getAttributeValue(GIT);
        boolean bl2 = object2 != null && ((String)object2).equals("true");
        object = element.getAttributeValue(FROM_PATH);
        boolean bl3 = object != null && ((String)object).equals("true");
        String string4 = element.getAttributeValue(REF);
        String string5 = element.getAttributeValue(DO_REQUIRE);
        boolean bl4 = string5 == null || !string5.equals("false");
        String[] stringArray = GemDependency.a(element);
        return new GemDependency(string, (List<Pair<Bound, String>>)arrayList, string3, (String)object32, bl2, string4, bl4, bl3, stringArray);
    }

    @Nullable
    private static String[] a(Element element) {
        long l2 = n ^ 0x58412FB07C41L;
        String string = element.getAttributeValue(PLATFORM);
        return string != null ? string.split(",") : null;
    }

    public String getDescription() {
        long l2 = n ^ 0x46A7E99C1AB4L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        if (!this.isAny()) {
            stringBuilder.append(" (");
            if (!this.isExact()) {
                for (Pair<Bound, String> pair : this.f) {
                    if (pair != this.f.get(0)) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((Bound)((Object)pair.first)).getOperator()).append(" ").append((String)pair.second);
                }
            } else {
                stringBuilder.append((String)this.getBounds().get((int)0).second);
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public boolean isExact() {
        return this.f.size() == 1 && this.f.get((int)0).first == Bound.EQUAL;
    }

    public int compareTo(@NotNull Object o2) {
        if (o2 == null) {
            GemDependency.a(0);
        }
        return this.getVersionString().compareTo(((GemDependency)o2).getVersionString());
    }

    private GemDependency(@NotNull String name, @NotNull List<Pair<Bound, String>> bounds, @Nullable String url, @Nullable String lib, boolean git, String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(1);
        }
        if (bounds == null) {
            GemDependency.a(2);
        }
        this.k = name;
        if (bounds.size() > 1) {
            Collections.sort(bounds, (pair, pair2) -> {
                int n2 = ((String)pair.second).compareTo((String)pair2.second);
                return n2 != 0 ? n2 : ((Bound)((Object)((Object)pair.first))).compareTo((Enum)pair2.first);
            });
        }
        this.f = Collections.unmodifiableList(bounds);
        this.g = url;
        this.d = lib;
        this.c = git;
        this.h = ref;
        this.l = doRequire;
        this.j = fromPath;
        this.a = platforms;
    }

    @NotNull
    public static GemDependency exact(@NotNull GemInfo gem) {
        if (gem == null) {
            GemDependency.a(3);
        }
        Pair pair = Pair.create((Object)((Object)Bound.EQUAL), (Object)gem.getVersion());
        GemDependency gemDependency = new GemDependency(gem.getName(), Collections.singletonList(pair), gem.isRemote() ? gem.getUrl() : null, null, gem.isGit(), gem.getRef(), true, false, null);
        if (gemDependency == null) {
            GemDependency.a(4);
        }
        return gemDependency;
    }

    public static GemDependency any(@NotNull @NonNls String name) {
        if (name == null) {
            GemDependency.a(5);
        }
        return GemDependency.any(name, null, null, false, null, true, false, null);
    }

    public static GemDependency any(@NotNull @NonNls String name, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(6);
        }
        return GemDependency.any(name, null, null, false, null, true, false, platforms);
    }

    public static GemDependency any(@NotNull @NonNls String name, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(7);
        }
        Pair pair = Pair.create((Object)((Object)Bound.GREATER_OR_EQUAL), (Object)"0");
        return new GemDependency(name, Collections.singletonList(pair), url, lib, isGit, ref, doRequire, fromPath, platforms);
    }

    public boolean isAny() {
        return this.f.size() == 0 || this.f.size() == 1 && GemDependency.b(this.f.get(0));
    }

    private static boolean b(Pair<Bound, String> pair) {
        return pair.first == Bound.GREATER_OR_EQUAL && "0".equals(pair.second);
    }

    public static GemDependency equal(@NotNull String name, @Nullable String version) {
        if (name == null) {
            GemDependency.a(8);
        }
        Pair pair = Pair.create((Object)((Object)Bound.EQUAL), (Object)(version == null ? "0" : version));
        return new GemDependency(name, Collections.singletonList(pair), null, null, false, null, true, false, null);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, String ... deps) {
        if (name == null) {
            GemDependency.a(9);
        }
        if (deps == null) {
            GemDependency.a(10);
        }
        return GemDependency.create(name, deps, null, null, false, null, true, false, null);
    }

    @Nullable
    public static GemDependency create(@NotNull String name, @NotNull String[] deps, @Nullable String url, @Nullable String lib, boolean isGit, @Nullable String ref, boolean doRequire, boolean fromPath, @Nullable String[] platforms) {
        if (name == null) {
            GemDependency.a(11);
        }
        if (deps == null) {
            GemDependency.a(12);
        }
        ArrayList<Pair<Bound, String>> arrayList = new ArrayList<Pair<Bound, String>>();
        for (String string : deps) {
            Object object;
            Object object2;
            Matcher matcher = i.matcher(string);
            if (matcher.matches()) {
                object2 = matcher.group(1);
                object = Bound.getBound(object2);
                String string2 = matcher.group(2);
                if (object != null) {
                    arrayList.add((Pair<Bound, String>)Pair.create((Object)object, (Object)string2));
                }
            }
            if ((matcher = b.matcher(string)).matches()) {
                object2 = Bound.EQUAL;
                object = matcher.group(1);
                arrayList.add((Pair<Bound, String>)Pair.create((Object)object2, (Object)object));
            }
            if (!(matcher = e.matcher(string)).matches() || (object = Bound.getBound(object2 = matcher.group(1))) == null) continue;
            arrayList.add((Pair<Bound, String>)Pair.create((Object)object, (Object)"0"));
        }
        return arrayList.size() == deps.length ? new GemDependency(name, arrayList, url, lib, isGit, ref, doRequire, fromPath, platforms) : null;
    }

    public String getName() {
        return this.k;
    }

    public List<Pair<Bound, String>> getBounds() {
        return this.f;
    }

    public String getVersionString() {
        long l2 = n ^ 0x6BDA5EEAE216L;
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair<Bound, String> pair : this.f) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((Bound)((Object)pair.first)).getOperator()).append(" ").append((String)pair.second);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String[] getPlatforms() {
        return this.a;
    }

    public String getRef() {
        return this.h;
    }

    public boolean isSatisfied(GemInfo gem) {
        String string;
        if (!Comparing.strEqual((String)this.k, (String)gem.getName())) {
            return false;
        }
        if (this.c && this.h != null) {
            return this.h.equals(gem.getRef());
        }
        if (!this.c && gem.isGit()) {
            return false;
        }
        if (this.j && this.g != null) {
            return SystemInfo.isMac || SystemInfo.isWindows ? StringUtil.startsWithIgnoreCase((String)gem.getUrl(), (String)this.g) : StringUtil.startsWith((CharSequence)gem.getUrl(), (CharSequence)this.g);
        }
        boolean bl2 = gem instanceof FrozenGemInfo;
        if (!this.j && gem.isFromPath() && !bl2) {
            return false;
        }
        String string2 = string = bl2 ? ((FrozenGemInfo)gem).getUnfrozenVersion() : gem.getVersion();
        return !this.b(string);
    }

    public boolean isUnsatisfied(String version) {
        return this.b(version);
    }

    private boolean b(String string) {
        for (Pair<Bound, String> pair : this.f) {
            if (GemDependency.compareVersions(string, (String)pair.second, (Bound)((Object)pair.first))) continue;
            return true;
        }
        return false;
    }

    public boolean isGit() {
        return this.c;
    }

    public boolean isFromPath() {
        return this.j;
    }

    public boolean doRequire() {
        return this.l;
    }

    public String getUrl() {
        return this.g;
    }

    @Contract(value="null -> false")
    public boolean isLocalProjectDependency(@Nullable Module module) {
        return module != null && this.isLocalProjectDependency(module.getProject());
    }

    @Contract(value="null -> false")
    public boolean isLocalProjectDependency(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            VirtualFile virtualFile = this.getGemRootDirectory();
            return virtualFile != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile);
        });
    }

    @Nullable
    public VirtualFile getGemRootDirectory() {
        String string = this.getUrl();
        if (string == null) {
            return null;
        }
        return VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Nullable
    public String getLibScript() {
        return this.d;
    }

    static boolean compareVersions(String versionToCheck, String version, Bound bound) {
        switch (bound) {
            case EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) == 0;
            }
            case GREATER: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) > 0;
            }
            case GREATER_OR_EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) >= 0;
            }
            case LATEST_IN_BRANCH: {
                String string = GemDependency.bump(version);
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) >= 0 && VersionComparatorUtil.compare((String)versionToCheck, (String)string) < 0;
            }
            case LESS: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) < 0;
            }
            case LESS_OR_EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) <= 0;
            }
            case NOT_EQUAL: {
                return VersionComparatorUtil.compare((String)versionToCheck, (String)version) != 0;
            }
        }
        return false;
    }

    static String bump(String version) {
        int n2;
        long l2 = n ^ 0x2A6519CAF78AL;
        String[] stringArray = version.split("\\.");
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = stringArray.length - 1; n2 >= 0 && GemDependency.a(stringArray[n2]); --n2) {
        }
        String string = n2 > 1 ? stringArray[n2 - 1] : stringArray[0];
        String string2 = GemDependency.succ(string);
        for (int i10 = 0; i10 < n2 - 1; ++i10) {
            stringBuilder.append(stringArray[i10]).append(".");
        }
        stringBuilder.append(string2).append(".snap");
        return stringBuilder.toString();
    }

    static String succ(String number) {
        StringBuilder stringBuilder = new StringBuilder(number.length());
        int n2 = 1;
        int n3 = 49;
        for (int i10 = number.length() - 1; i10 >= 0; --i10) {
            n3 = number.charAt(i10);
            if (Character.isLetter(n3)) {
                n2 = (n3 += n2 - 97) / 26;
                n3 = n3 % 26 + 97;
            } else if (Character.isDigit(n3)) {
                n2 = (n3 += n2 - 48) / 10;
                n3 = n3 % 10 + 48;
            }
            stringBuilder.append((char)n3);
        }
        if (n2 != 0) {
            stringBuilder.append((char)(Character.isLetter(n3) ? 97 : n2 + 48));
        }
        return stringBuilder.reverse().toString();
    }

    private static boolean a(String string) {
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (!Character.isLetter(string.charAt(i10))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GemDependency gemDependency = (GemDependency)o2;
        if (this.l != gemDependency.l) {
            return false;
        }
        if (this.j != gemDependency.j) {
            return false;
        }
        if (this.c != gemDependency.c) {
            return false;
        }
        if (this.f != null ? !this.f.equals(gemDependency.f) : gemDependency.f != null) {
            return false;
        }
        if (this.d != null ? !this.d.equals(gemDependency.d) : gemDependency.d != null) {
            return false;
        }
        if (!this.k.equals(gemDependency.k)) {
            return false;
        }
        if (this.h != null ? !this.h.equals(gemDependency.h) : gemDependency.h != null) {
            return false;
        }
        return !(this.g != null ? !this.g.equals(gemDependency.g) : gemDependency.g != null);
    }

    public int hashCode() {
        int n2 = this.k.hashCode();
        n2 = 31 * n2 + (this.f != null ? this.f.hashCode() : 0);
        n2 = 31 * n2 + (this.g != null ? this.g.hashCode() : 0);
        n2 = 31 * n2 + (this.d != null ? this.d.hashCode() : 0);
        n2 = 31 * n2 + (this.c ? 1 : 0);
        n2 = 31 * n2 + (this.j ? 1 : 0);
        n2 = 31 * n2 + (this.l ? 1 : 0);
        n2 = 31 * n2 + (this.h != null ? this.h.hashCode() : 0);
        return n2;
    }

    public String toString() {
        long l2 = n ^ 0x2BAF045A2837L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GemDependency");
        stringBuilder.append("{myName='").append(this.k).append('\'');
        stringBuilder.append(", myBounds=").append(this.f);
        stringBuilder.append(", myUrl='").append(this.g).append('\'');
        stringBuilder.append(", myLib='").append(this.d).append('\'');
        stringBuilder.append(", myIsGit=").append(this.c);
        stringBuilder.append(", myFromPath=").append(this.j);
        stringBuilder.append(", myPlatforms=").append(this.a == null ? "null" : Arrays.asList(this.a).toString());
        stringBuilder.append(", myDoRequire=").append(this.l);
        stringBuilder.append(", myRef='").append(this.h).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean canBeSatisfied() {
        return this.a(Interval.UNIVERSUM, 0);
    }

    private boolean a(Interval interval, int n2) {
        for (int i10 = n2; i10 < this.f.size(); ++i10) {
            Pair<Bound, String> pair = this.f.get(i10);
            Interval[] intervalArray = GemDependency.a(pair);
            if (intervalArray.length != 1) {
                return this.a(interval.intersect(intervalArray[0]), i10 + 1) || this.a(interval.intersect(intervalArray[1]), i10 + 1);
            }
            interval = interval.intersect(intervalArray[0]);
        }
        return !interval.isEmpty();
    }

    public boolean canEat(@NotNull GemDependency dependency) {
        if (dependency == null) {
            GemDependency.a(13);
        }
        if (!this.getName().equals(dependency.getName())) {
            return false;
        }
        if (dependency.isAny()) {
            return true;
        }
        if (this.isAny()) {
            return false;
        }
        if (this.getBounds().size() > 1 || dependency.getBounds().size() > 1) {
            return false;
        }
        Pair<Bound, String> pair = this.getBounds().get(0);
        Pair<Bound, String> pair2 = dependency.getBounds().get(0);
        Interval[] intervalArray = GemDependency.a(pair);
        Interval[] intervalArray2 = GemDependency.a(pair2);
        if (intervalArray.length != 1 || intervalArray2.length != 1) {
            return false;
        }
        return intervalArray[0].a(intervalArray2[0]);
    }

    public int size() {
        return this.f.size();
    }

    private static Interval[] a(Pair<Bound, String> pair) {
        long l2 = n ^ 0x1F18439F5794L;
        String string = (String)pair.second;
        Bound bound = (Bound)((Object)pair.first);
        switch (bound) {
            case EQUAL: {
                return new Interval[]{new Interval(string, true, string, true)};
            }
            case GREATER: {
                return new Interval[]{new Interval(string, false, m, false)};
            }
            case GREATER_OR_EQUAL: {
                return new Interval[]{new Interval(string, true, m, false)};
            }
            case LATEST_IN_BRANCH: {
                return new Interval[]{new Interval(string, true, GemDependency.bump(string), false)};
            }
            case LESS: {
                return new Interval[]{new Interval("0", true, string, false)};
            }
            case LESS_OR_EQUAL: {
                return new Interval[]{new Interval("0", true, string, true)};
            }
            case NOT_EQUAL: {
                return new Interval[]{new Interval("0", true, string, false), new Interval(string, false, m, false)};
            }
        }
        throw new IllegalArgumentException("unknown bound");
    }

    static /* synthetic */ String access$100() {
        return m;
    }

    static {
        n = la.a(-3733220568801907985L, 887707796560966348L, MethodHandles.lookup().lookupClass()).a(271135284196926L);
        long l2 = n ^ 0xE157BDD6C11L;
        m = Integer.valueOf(Integer.MAX_VALUE).toString();
        i = Pattern.compile("^\\s*([^0-9\\s]*)\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*$");
        b = Pattern.compile("^\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*$");
        e = Pattern.compile("^\\s*([^0-9\\s]*)\\s*$");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x273DDB920D23L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemDependency";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deps";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = DEPENDENCY;
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemDependency";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "exact";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exact";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "any";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canEat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Interval {
        public static final Interval UNIVERSUM = new Interval("0", true, GemDependency.access$100(), false);
        private final String b;
        private final boolean d;
        private final String a;
        private final boolean c;

        Interval(String low, boolean lowIncluded, String high, boolean highIncluded) {
            this.b = low;
            this.d = lowIncluded;
            this.a = high;
            this.c = highIncluded;
        }

        boolean isEmpty() {
            int n2 = VersionComparatorUtil.compare((String)this.b, (String)this.a);
            return n2 > 0 || n2 == 0 && (!this.d || !this.c);
        }

        Interval intersect(Interval other) {
            String string = VersionComparatorUtil.max((String)this.b, (String)other.b);
            String string2 = VersionComparatorUtil.min((String)this.a, (String)other.a);
            return new Interval(string, this.b(other, string), string2, this.a(other, string2));
        }

        private boolean a(Interval interval, String string) {
            if (!this.a.equals(interval.a)) {
                return this.a.equals(string) ? this.c : interval.c;
            }
            return this.c && interval.c;
        }

        private boolean b(Interval interval, String string) {
            if (!this.b.equals(interval.b)) {
                return this.b.equals(string) ? this.d : interval.d;
            }
            return this.d && interval.d;
        }

        private boolean a(Interval interval) {
            return (interval.d || !this.d ? VersionComparatorUtil.compare((String)this.b, (String)interval.b) >= 0 : VersionComparatorUtil.compare((String)this.b, (String)interval.b) > 0) && (interval.c || !this.c ? VersionComparatorUtil.compare((String)this.a, (String)interval.a) <= 0 : VersionComparatorUtil.compare((String)this.a, (String)interval.a) < 0);
        }
    }

    public static final class Bound
    extends Enum<Bound> {
        public static final /* enum */ Bound EQUAL;
        public static final /* enum */ Bound NOT_EQUAL;
        public static final /* enum */ Bound LESS;
        public static final /* enum */ Bound GREATER;
        public static final /* enum */ Bound LESS_OR_EQUAL;
        public static final /* enum */ Bound GREATER_OR_EQUAL;
        public static final /* enum */ Bound LATEST_IN_BRANCH;
        private final String a;
        private static final /* synthetic */ Bound[] b;

        public static Bound[] values() {
            return (Bound[])b.clone();
        }

        public static Bound valueOf(String name) {
            return Enum.valueOf(Bound.class, name);
        }

        private Bound(String op) {
            this.a = op;
        }

        @Nullable
        public static Bound getBound(String op) {
            for (Bound bound : Bound.values()) {
                if (!bound.a.equals(op)) continue;
                return bound;
            }
            return null;
        }

        public String getOperator() {
            return this.a;
        }

        static {
            long l2 = la.a(1390789555294446728L, 6984236569873675542L, MethodHandles.lookup().lookupClass()).a(278930053795517L) ^ 0x461A2AA8F550L;
            EQUAL = new Bound("=");
            NOT_EQUAL = new Bound("!=");
            LESS = new Bound("<");
            GREATER = new Bound(">");
            LESS_OR_EQUAL = new Bound("<=");
            GREATER_OR_EQUAL = new Bound(">=");
            LATEST_IN_BRANCH = new Bound("~>");
            b = new Bound[]{EQUAL, NOT_EQUAL, LESS, GREATER, LESS_OR_EQUAL, GREATER_OR_EQUAL, LATEST_IN_BRANCH};
        }
    }
}

