/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline;

import org.jetbrains.plugins.ruby.rails.run.configuration.server.RailsServerRunConfiguration;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.BaseRailsServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.JRubyServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.PassengerServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.RailsServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.ThinServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.TorqueBoxServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.UnicornServerRunCommandLineGenerator;
import org.jetbrains.plugins.ruby.rails.run.configuration.server.commandline.ZeusServerRunCommandLineGenerator;

public class RailsServerRunCommandLineGeneratorFactory {
    public static RailsServerRunCommandLineGenerator create(RailsServerRunConfiguration config) {
        if (config.isUnicornServer()) {
            return new UnicornServerRunCommandLineGenerator(config);
        }
        if (config.isJrubyServer()) {
            return new JRubyServerRunCommandLineGenerator(config);
        }
        if (config.isTorqueBox()) {
            return new TorqueBoxServerRunCommandLineGenerator(config);
        }
        if (config.isPassenger()) {
            return new PassengerServerRunCommandLineGenerator(config);
        }
        if (config.isZeusServer()) {
            return new ZeusServerRunCommandLineGenerator(config);
        }
        if (config.isThinServer()) {
            return new ThinServerRunCommandLineGenerator(config);
        }
        return new BaseRailsServerRunCommandLineGenerator(config);
    }
}

