/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import b.h.la;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;

public class RunConfigurationUtil {
    private static final long a = la.a(1879931504270778986L, -499968855504416081L, MethodHandles.lookup().lookupClass()).a(10207059529324L);

    private RunConfigurationUtil() {
    }

    public static RunnerAndConfigurationSettings createSettings(Project project, ConfigurationFactory factory, String name) {
        return RunManager.getInstance((Project)project).createConfiguration(name, factory);
    }

    public static String collectArguments(String[] args) {
        return StringUtil.join((String[])args, (String)" ");
    }

    public static void inspectWorkingDirectory(boolean allowEmptyWorkDir, AbstractRubyRunConfigurationParams conf, boolean isExecution) throws Exception {
        RunConfigurationUtil.inspectWorkingDirectory(allowEmptyWorkDir, isExecution, conf.getWorkingDirectory());
    }

    public static void inspectWorkingDirectory(boolean allowEmptyWorkDir, boolean isExecution, @Nullable String workingDirectory) throws Exception {
        long l2 = a ^ 0x2554751D8156L;
        if (workingDirectory != null && workingDirectory.trim().length() != 0) {
            File file = new File(workingDirectory);
            if (!file.exists()) {
                RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message((String)"run.configuration.working.directory.not.exists"), isExecution);
            }
            if (!file.isDirectory()) {
                RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message((String)"run.configuration.working.directory.error"), isExecution);
            }
        } else if (allowEmptyWorkDir) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message((String)"run.configuration.working.directory.not.specified"), isExecution);
        }
    }

    public static void inspectSDK(AbstractRubyRunConfiguration conf, boolean isExecution) throws Exception {
        long l2 = a ^ 0x4A77F3945886L;
        Sdk sdk = conf.getSdk();
        if (sdk == null) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message((String)"jdk.no.specified"), isExecution);
        }
        if (!RubySdkUtil.isRubySDK(sdk)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message((String)"jdk.type.incorrect"), isExecution);
        }
        if (!RubySdkUtil.isRubyInterpreterExist(sdk)) {
            RunConfigurationUtil.throwExecutionOrRuntimeException(RBundle.message((String)"sdk.error.homepath.doesnt.exists", (Object[])new Object[]{sdk.getHomePath(), sdk}), isExecution);
        }
    }

    public static void throwExecutionOrRuntimeException(String msg, boolean isExecution) throws Exception {
        if (isExecution) {
            throw new ExecutionException(msg);
        }
        throw new RuntimeException(msg);
    }

    public static void setupRubyArgs(AbstractRubyRunConfiguration conf, String rubyArgs) {
        Sdk sdk = conf.getSdk();
        if ((sdk == null || !(sdk.getSdkType() instanceof JRubySdkType)) && StringUtil.isEmptyOrSpaces((String)conf.getRubyArgs())) {
            conf.setRubyArgs(rubyArgs);
        }
    }

    public static void setRailsDefaultTestEnvironment(@NotNull AbstractRubyRunConfiguration conf, @Nullable Module module) {
        long l2 = a ^ 0x46A60DA3B62EL;
        if (conf == null) {
            RunConfigurationUtil.a(0);
        }
        RunConfigurationUtil.setRailsTestEnvironment(conf, module, "test");
    }

    public static void setRailsTestEnvironment(@NotNull AbstractRubyRunConfigurationParams conf, @Nullable Module module, @NotNull String envName) {
        long l2 = a ^ 0x20E8AFB1CEA5L;
        if (conf == null) {
            RunConfigurationUtil.a(1);
        }
        if (envName == null) {
            RunConfigurationUtil.a(2);
        }
        if (module != null && RailsFacetUtil.hasRailsSupport(module)) {
            Map<String, String> map = conf.getEnvs();
            map.putIfAbsent("RAILS_ENV", envName);
        }
    }

    public static int getIntByString(String value, int errorValue) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return errorValue;
        }
    }

    public static String getStringByInt(int value, int errorValue, String errorString) {
        return value != errorValue ? String.valueOf(value) : errorString;
    }

    public static void executeConfiguration(@NotNull RunManager runManager, @NotNull RunnerAndConfigurationSettings confSettings, @Nullable ProgramRunner.Callback executionCallback) {
        ExecutionEnvironment executionEnvironment;
        long l2 = a ^ 0x6ECBCE3D56A8L;
        if (runManager == null) {
            RunConfigurationUtil.a(3);
        }
        if (confSettings == null) {
            RunConfigurationUtil.a(4);
        }
        runManager.setSelectedConfiguration(confSettings);
        try {
            executionEnvironment = ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunnerAndConfigurationSettings)confSettings).build();
        }
        catch (ExecutionException executionException) {
            return;
        }
        try {
            executionEnvironment.getRunner().execute(executionEnvironment, executionCallback);
        }
        catch (ExecutionException executionException) {
            Messages.showErrorDialog((Project)confSettings.getConfiguration().getProject(), (String)executionException.getMessage(), (String)ExecutionBundle.message((String)"error.common.title", (Object[])new Object[0]));
        }
    }

    @NotNull
    public static String argsToString(@NotNull String[] args) {
        if (args == null) {
            RunConfigurationUtil.a(5);
        }
        String string = ParametersList.join((String[])args);
        if (string == null) {
            RunConfigurationUtil.a(6);
        }
        return string;
    }

    public static void writeLauncherArgsToEnv(@NotNull RubySdkSystemAccessor accessor, @NotNull Map<String, String> envMap, @NotNull GeneralCommandLine commandLine) {
        long l2 = a ^ 0x64E6B428F10EL;
        if (accessor == null) {
            RunConfigurationUtil.a(7);
        }
        if (envMap == null) {
            RunConfigurationUtil.a(8);
        }
        if (commandLine == null) {
            RunConfigurationUtil.a(9);
        }
        Platform platform = accessor.isWindows() ? Platform.WINDOWS : Platform.UNIX;
        envMap.put("INTELLIJ_IDEA_RUN_CONF_LAUNCHER_CMDLINE", commandLine.getPreparedCommandLine(platform));
    }

    public static void addPortForwarding(@NotNull RubyCommandLineData data, @NotNull PortForwarding forwarding) {
        Collection collection;
        if (data == null) {
            RunConfigurationUtil.a(10);
        }
        if (forwarding == null) {
            RunConfigurationUtil.a(11);
        }
        if ((collection = (Collection)data.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)) == null) {
            collection = Lists.newArrayList();
        }
        collection.add(forwarding);
        data.putUserData(RubyCommandLineData.PORT_FORWARDING_KEY, collection);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1AF2536A9562L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwarding";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "argsToString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRailsDefaultTestEnvironment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRailsTestEnvironment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "argsToString";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeLauncherArgsToEnv";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPortForwarding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

