/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RubyUmlElementManager
extends AbstractDiagramElementManager<RContainer> {
    public RContainer findInDataContext(DataContext context) {
        RContainer result = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element instanceof RClass || element instanceof RModule) {
            result = (RContainer)element;
        } else {
            VirtualFile virtualFile;
            PsiFile psiFile;
            PsiFile psiFile2 = psiFile = element instanceof PsiFile ? (PsiFile)element : (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            if (psiFile instanceof RFile && (virtualFile = psiFile.getVirtualFile()) != null) {
                RContainer container = (RContainer)psiFile;
                result = RContainerUtil.findClassByName((RContainer)container, (String)NamingConventions.toCamelCase((String)virtualFile.getNameWithoutExtension()));
            }
        }
        return result;
    }

    public Object[] getNodeItems(RContainer container) {
        if (container instanceof RClass || container instanceof RModule) {
            ArrayList elements = new ArrayList();
            elements.addAll(((RMethodHolder)container).getMethods());
            elements.addAll(((RFieldHolder)container).getFieldsDeclarations());
            elements.addAll(((RConstantHolder)container).getConstantDeclarations());
            return elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof RClass || element instanceof RModule;
    }

    public String getElementTitle(RContainer element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        String text = null;
        if (element instanceof RContainer && ((RContainer)element).isValid()) {
            if (element instanceof RClass || element instanceof RModule) {
                Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)element));
                if (symbol != null) {
                    text = symbol.getFQNWithNesting().toString();
                }
            } else {
                text = ((RContainer)element).getName();
            }
        } else {
            text = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : "";
        }
        if (text == null) {
            text = element.toString();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    public String getNodeTooltip(RContainer element) {
        return null;
    }
}

