/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.javacvsSpecificImpls;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class AdminReaderForLightFiles
implements IAdminReader {
    private final Map<File, Entry> myFileToEntryMap;

    public AdminReaderForLightFiles(Map<File, Entry> fileToEntryMap) {
        this.myFileToEntryMap = fileToEntryMap;
    }

    public Collection getEntries(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        String path = directoryObject.getPath();
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            path = path.substring(1);
        }
        return this.collectEntriesForPath(new File(path));
    }

    private Collection collectEntriesForPath(File parent) {
        HashSet<Entry> result = new HashSet<Entry>();
        for (File file : this.myFileToEntryMap.keySet()) {
            if (!file.getParentFile().equals(parent)) continue;
            result.add(this.myFileToEntryMap.get(file));
        }
        return result;
    }

    public boolean isModified(FileObject fileObject, Date entryLastModified, ICvsFileSystem cvsFileSystem) {
        return false;
    }

    public boolean isStatic(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        return false;
    }

    public Entry getEntry(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) {
        String path = fileObject.getPath();
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            path = path.substring(1);
        }
        return this.getEntryForPath(new File(path));
    }

    private Entry getEntryForPath(File requested) {
        for (File file : this.myFileToEntryMap.keySet()) {
            if (!file.equals(requested)) continue;
            return this.myFileToEntryMap.get(file);
        }
        return null;
    }

    public String getRepositoryForDirectory(DirectoryObject directoryObject, String repository, ICvsFileSystem cvsFileSystem) {
        String path = directoryObject.getPath();
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            path = path.substring(1);
        }
        return repository + path.replace(File.separatorChar, '/');
    }

    public boolean hasCvsDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        return false;
    }

    public String getStickyTagForDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        return null;
    }
}

