/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ContentsUtil {
    protected static final String DISPOSABLE_KEY = "TabContentDisposable";

    public static void addOrReplaceContent(ContentManager manager, Content content, boolean select) {
        String contentName = content.getDisplayName();
        Content[] contents = manager.getContents();
        Content oldContentFound = null;
        for (Content oldContent : contents) {
            if (oldContent.isPinned() || !oldContent.getDisplayName().equals(contentName)) continue;
            oldContentFound = oldContent;
            break;
        }
        manager.addContent(content);
        if (oldContentFound != null) {
            manager.removeContent(oldContentFound, true);
        }
        if (select) {
            manager.setSelectedContent(content);
        }
    }

    public static void addContent(ContentManager manager, Content content, boolean select) {
        manager.addContent(content);
        if (select) {
            manager.setSelectedContent(content);
        }
    }

    public static void closeContentTab(@NotNull ContentManager contentManager, @NotNull Content content) {
        TabbedContent tabbedContent;
        if (contentManager == null) {
            ContentsUtil.$$$reportNull$$$0(0);
        }
        if (content == null) {
            ContentsUtil.$$$reportNull$$$0(1);
        }
        if (content instanceof TabbedContent && (tabbedContent = (TabbedContent)content).hasMultipleTabs()) {
            JComponent component = tabbedContent.getComponent();
            tabbedContent.removeContent(component);
            contentManager.setSelectedContent(tabbedContent, true, true);
            ContentsUtil.dispose(component);
            return;
        }
        contentManager.removeContent(content, true);
    }

    public static void dispose(@NotNull JComponent component) {
        Object disposable;
        if (component == null) {
            ContentsUtil.$$$reportNull$$$0(2);
        }
        if ((disposable = component.getClientProperty(DISPOSABLE_KEY)) instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)disposable));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ContentsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "closeContentTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "dispose";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

