/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

public class NameEnumerator {
    private final TObjectIntHashMap<String> myNames = new TObjectIntHashMap();
    private int myNextNameId = 1;
    private final Object myNameLock = "NameLock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int enumerate(String name) {
        Object object = this.myNameLock;
        synchronized (object) {
            int enumerated = this.myNames.get(name);
            if (enumerated != 0) {
                return enumerated;
            }
            int newId = this.myNextNameId++;
            this.updateDataIncrement(name, newId);
            this.myNames.put(name, newId);
            return newId;
        }
    }

    TObjectIntHashMap<String> getNamesMap() {
        return this.myNames;
    }

    protected void updateDataIncrement(String name, int id) {
    }

    static int[] enumerate(String[] names, NameEnumerator enumerator) {
        int[] ids = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ids[i] = enumerator.enumerate(name);
        }
        return ids;
    }

    static class Incremental
    extends NameEnumerator {
        private List<NameAndId> myDataIncrement = new ArrayList<NameAndId>();
        private final Object myDataIncrementLock = "DataIncrementLock";

        Incremental() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateDataIncrement(String name, int id) {
            Object object = this.myDataIncrementLock;
            synchronized (object) {
                this.myDataIncrement.add(new NameAndId(name, id));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<NameAndId> getAndClearDataIncrement() {
            Object object = this.myDataIncrementLock;
            synchronized (object) {
                List<NameAndId> dataIncrement = this.myDataIncrement;
                this.myDataIncrement = new ArrayList<NameAndId>();
                return dataIncrement;
            }
        }

        static final class NameAndId {
            private final String myName;
            private final int myId;

            NameAndId(String myName, int myId) {
                this.myName = myName;
                this.myId = myId;
            }

            String getName() {
                return this.myName;
            }

            int getId() {
                return this.myId;
            }
        }
    }
}

