/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myGulpfilePath;
    private final String myGulpfileSystemIndependentPath;
    private final List<String> myTasks;
    private final String myArguments;
    private final EnvironmentVariablesData myEnvData;
    private final boolean myNewEnvFormat;

    public GulpRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            GulpRunSettings.$$$reportNull$$$0(0);
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myGulpfilePath = FileUtil.toSystemDependentName((String)builder.myGulpfilePath);
        this.myGulpfileSystemIndependentPath = FileUtil.toSystemIndependentName((String)builder.myGulpfilePath);
        this.myTasks = ImmutableList.copyOf((Collection)builder.myTasks);
        this.myArguments = builder.myArguments;
        this.myEnvData = builder.myEnvData;
        this.myNewEnvFormat = builder.myNewEnvFormat;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            GulpRunSettings.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getGulpfilePath() {
        String string = this.myGulpfilePath;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public VirtualFile getGulpfile() {
        if (this.myGulpfileSystemIndependentPath.isEmpty()) {
            return null;
        }
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(this.myGulpfileSystemIndependentPath);
        return file2 == null || file2.isDirectory() ? null : file2;
    }

    @NotNull
    public String getGulpfileSystemIndependentPath() {
        String string = this.myGulpfileSystemIndependentPath;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            GulpRunSettings.$$$reportNull$$$0(5);
        }
        return environmentVariablesData;
    }

    public boolean isNewEnvFormat() {
        return this.myNewEnvFormat;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list = this.myTasks;
        if (list == null) {
            GulpRunSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            GulpRunSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GulpRunSettings that = (GulpRunSettings)o;
        return this.myEnvData.equals((Object)that.myEnvData) && this.myNodeOptions.equals(that.myNodeOptions) && this.myGulpfilePath.equals(that.myGulpfilePath) && this.myTasks.equals(that.myTasks) && this.myArguments.equals(that.myArguments);
    }

    public int hashCode() {
        int result2 = this.myGulpfilePath.hashCode();
        result2 = 31 * result2 + this.myNodeOptions.hashCode();
        result2 = 31 * result2 + this.myTasks.hashCode();
        result2 = 31 * result2 + this.myArguments.hashCode();
        result2 = 31 * result2 + this.myEnvData.hashCode();
        return result2;
    }

    @NotNull
    public static Builder builder(@NotNull GulpRunSettings settings) {
        if (settings == null) {
            GulpRunSettings.$$$reportNull$$$0(8);
        }
        Builder builder = new Builder(settings);
        if (builder == null) {
            GulpRunSettings.$$$reportNull$$$0(9);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGulpfilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGulpfileSystemIndependentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private String myGulpfilePath;
        private List<String> myTasks;
        private String myArguments;
        private EnvironmentVariablesData myEnvData;
        private boolean myNewEnvFormat;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGulpfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
        }

        public Builder(@NotNull GulpRunSettings settings) {
            if (settings == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGulpfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
            this.myNodeOptions = settings.getNodeOptions();
            this.myGulpfilePath = settings.getGulpfilePath();
            this.myTasks = ImmutableList.copyOf(settings.getTasks());
            this.myEnvData = settings.getEnvData();
            this.myNewEnvFormat = settings.isNewEnvFormat();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@Nullable String nodeOptions) {
            this.myNodeOptions = StringUtil.notNullize((String)nodeOptions);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setGulpfilePath(@Nullable String gulpfilePath) {
            this.myGulpfilePath = StringUtil.notNullize((String)gulpfilePath);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setTasks(@NotNull List<String> tasks) {
            if (tasks == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myTasks = ImmutableList.copyOf(tasks);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myArguments = arguments;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        public void setNewEnvFormat(boolean newEnvFormat) {
            this.myNewEnvFormat = newEnvFormat;
        }

        @NotNull
        public GulpRunSettings build() {
            GulpRunSettings gulpRunSettings = new GulpRunSettings(this);
            if (gulpRunSettings == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return gulpRunSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGulpfilePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTasks";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTasks";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

