/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class TextFragment
implements Comparable<TextFragment>,
Serializable {
    @NotNull
    public final String text;
    final int row;
    final int pos;

    public TextFragment(@NotNull String text, int row, int pos) {
        this.text = text;
        this.row = row;
        this.pos = pos;
    }

    @NotNull
    protected String getTextName() {
        return "SQL";
    }

    @Override
    public int compareTo(@NotNull TextFragment that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            throw new IllegalArgumentException("Comparison with null");
        }
        int z = this.getTextName().compareTo(that.getTextName());
        if (z == 0) {
            z = this.row - that.row;
        }
        if (z == 0) {
            z = this.pos - that.pos;
        }
        if (z == 0) {
            z = this.text.compareTo(that.text);
        }
        return z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextFragment that = (TextFragment)o;
        return this.row == that.row && this.pos == that.pos && this.text.equals(that.text);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    @NotNull
    protected String getTextLocationHumanReadable() {
        return "Fragment at " + this.row + ':' + this.pos;
    }

    public String toString() {
        return this.getTextLocationHumanReadable() + '\n' + this.text;
    }
}

